/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.indexing;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.compiler.util.SimpleLookupTable;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuiltinModuleProvider;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceElementParser;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.core.search.indexing.IndexManager;
import org.eclipse.dltk.core.search.indexing.IndexRequest;
import org.eclipse.dltk.core.search.indexing.ReadWriteMonitor;
import org.eclipse.dltk.core.search.indexing.SourceIndexerRequestor;
import org.eclipse.dltk.internal.core.BuiltinProjectFragment;
import org.eclipse.dltk.internal.core.search.DLTKSearchDocument;

class AddBuiltinFolderToIndex
extends IndexRequest {
    IProject project;
    IScriptProject scriptProject;

    public AddBuiltinFolderToIndex(IPath folderPath, IProject project, IndexManager manager) {
        super(folderPath, manager);
        this.project = project;
        this.scriptProject = DLTKCore.create(this.project);
    }

    public int hashCode() {
        IDLTKLanguageToolkit languageToolkit = DLTKLanguageManager.getLanguageToolkit(this.scriptProject);
        return languageToolkit.getNatureId().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof AddBuiltinFolderToIndex) {
            IDLTKLanguageToolkit languageToolkit = DLTKLanguageManager.getLanguageToolkit(this.scriptProject);
            IDLTKLanguageToolkit languageToolki2 = DLTKLanguageManager.getLanguageToolkit(((AddBuiltinFolderToIndex)o).scriptProject);
            if (languageToolkit.getNatureId().equals(languageToolki2.getNatureId())) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor progressMonitor) {
        String pathToString;
        Index index;
        if (this.isCancelled) return true;
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        if (!this.project.isAccessible()) {
            return true;
        }
        String cfp = this.containerPath.toString();
        if (cfp.startsWith("#special#builtin#")) {
            cfp = cfp.substring("#special#builtin#".length());
        }
        if ((index = this.manager.getSpecialIndex("builtin", cfp, pathToString = this.containerPath.toString())) == null) {
            return true;
        }
        ReadWriteMonitor monitor = index.monitor;
        if (monitor == null) {
            return true;
        }
        try {
            try {
                monitor.enterRead();
                IPath container = this.containerPath;
                IndexManager indexManager = this.manager;
                ISourceElementParser parser = indexManager.getSourceElementParser(this.scriptProject);
                SourceIndexerRequestor requestor = indexManager.getSourceRequestor(this.scriptProject);
                System.currentTimeMillis();
                SearchParticipant participant = SearchEngine.getDefaultSearchParticipant();
                this.visit(null, this.scriptProject, parser, requestor, indexManager, container, true, participant, index);
                this.manager.saveIndex(index);
            }
            catch (IOException iOException) {
                Object var11_11 = null;
                monitor.exitRead();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            monitor.exitRead();
            throw throwable;
        }
        {
            Object var11_13 = null;
            monitor.exitRead();
            return true;
        }
    }

    private void visit(SimpleLookupTable table, IScriptProject project, ISourceElementParser parser, SourceIndexerRequestor requestor, IndexManager indexManager, IPath container, boolean operation, SearchParticipant participant, Index index) {
        IDLTKLanguageToolkit toolkit = null;
        toolkit = DLTKLanguageManager.getLanguageToolkit(project);
        IBuiltinModuleProvider provider = BuiltinProjectFragment.getBuiltinProvider(project);
        if (provider == null) {
            return;
        }
        String[] files = provider.getBuiltinModules();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (this.isCancelled) {
                    return;
                }
                this.indexDocument(parser, requestor, participant, index, files[i], toolkit, provider.getBuiltinModuleContent(files[i]));
                ++i;
            }
        }
    }

    private void indexDocument(ISourceElementParser parser, SourceIndexerRequestor requestor, SearchParticipant participant, Index index, String path, IDLTKLanguageToolkit toolkit, String contents) {
        IPath dpath = new Path(path).setDevice(null);
        DLTKSearchDocument entryDocument = new DLTKSearchDocument(dpath.toString(), (IPath)Path.EMPTY, contents.toCharArray(), participant, true, this.project);
        entryDocument.parser = parser;
        entryDocument.requestor = requestor;
        entryDocument.toolkit = toolkit;
        entryDocument.fullPath = this.containerPath.append(dpath);
        this.manager.indexDocument(entryDocument, participant, index, this.containerPath);
    }

    public String toString() {
        return "adding " + this.containerPath + " to index " + this.containerPath;
    }
}

