/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKContentTypeManager;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.internal.core.BuiltinSourceModule;
import org.eclipse.dltk.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.internal.core.ExternalSourceModule;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ModelElementDelta;
import org.eclipse.dltk.internal.core.ModelStatus;
import org.eclipse.dltk.internal.core.MultiOperation;
import org.eclipse.dltk.internal.core.ProjectFragment;
import org.eclipse.dltk.internal.core.ScriptFolder;
import org.eclipse.dltk.internal.core.SourceModule;
import org.eclipse.dltk.internal.core.util.Messages;
import org.eclipse.dltk.internal.core.util.Util;

public class CopyResourceElementsOperation
extends MultiOperation {
    protected ArrayList createdElements;
    protected Map deltasPerProject = new HashMap(1);

    public CopyResourceElementsOperation(IModelElement[] resourcesToCopy, IModelElement destContainer, boolean force) {
        this(resourcesToCopy, new IModelElement[]{destContainer}, force);
    }

    public CopyResourceElementsOperation(IModelElement[] resourcesToCopy, IModelElement[] destContainers, boolean force) {
        super(resourcesToCopy, destContainers, force);
    }

    private IResource[] collectResourcesOfInterest(IScriptFolder source) throws ModelException {
        IModelElement[] children = source.getChildren();
        int childOfInterest = 5;
        ArrayList<IResource> correctKindChildren = new ArrayList<IResource>(children.length);
        int i = 0;
        while (i < children.length) {
            IModelElement child = children[i];
            if (child.getElementType() == childOfInterest) {
                correctKindChildren.add(child.getResource());
            }
            ++i;
        }
        Object[] nonScriptResources = source.getForeignResources();
        int actualNonScriptResourceCount = 0;
        int i2 = 0;
        int max = nonScriptResources.length;
        while (i2 < max) {
            if (nonScriptResources[i2] instanceof IResource) {
                ++actualNonScriptResourceCount;
            }
            ++i2;
        }
        IResource[] actualNonScriptResources = new IResource[actualNonScriptResourceCount];
        int i3 = 0;
        int max2 = nonScriptResources.length;
        int index = 0;
        while (i3 < max2) {
            if (nonScriptResources[i3] instanceof IResource) {
                actualNonScriptResources[index++] = (IResource)nonScriptResources[i3];
            }
            ++i3;
        }
        if (actualNonScriptResourceCount != 0) {
            int correctKindChildrenSize = correctKindChildren.size();
            IResource[] result = new IResource[correctKindChildrenSize + actualNonScriptResourceCount];
            correctKindChildren.toArray(result);
            System.arraycopy(actualNonScriptResources, 0, result, correctKindChildrenSize, actualNonScriptResourceCount);
            return result;
        }
        IResource[] result = new IResource[correctKindChildren.size()];
        correctKindChildren.toArray(result);
        return result;
    }

    private boolean createNeededScriptFolders(IContainer sourceFolder, ProjectFragment root, IPath newFragName, boolean moveFolder) throws ModelException {
        boolean containsReadOnlyScriptFolder = false;
        IContainer parentFolder = (IContainer)root.getResource();
        ModelElementDelta projectDelta = null;
        Path sideEffectPackageName = new Path("");
        char[][] inclusionPatterns = root.fullInclusionPatternChars();
        char[][] exclusionPatterns = root.fullExclusionPatternChars();
        int i = 0;
        while (i < newFragName.segmentCount()) {
            String subFolderName = newFragName.segment(i);
            sideEffectPackageName = sideEffectPackageName.append(subFolderName);
            IResource subFolder = parentFolder.findMember(subFolderName);
            if (subFolder == null) {
                if (!moveFolder || i != newFragName.segmentCount() - 1) {
                    this.createFolder(parentFolder, subFolderName, this.force);
                }
                parentFolder = parentFolder.getFolder((IPath)new Path(subFolderName));
                if (Util.isReadOnly((IResource)(sourceFolder = sourceFolder.getFolder((IPath)new Path(subFolderName))))) {
                    containsReadOnlyScriptFolder = true;
                }
                IScriptFolder sideEffectPackage = root.getScriptFolder((IPath)sideEffectPackageName);
                if (i < newFragName.segmentCount() - 1 && !Util.isExcluded((IResource)parentFolder, inclusionPatterns, exclusionPatterns)) {
                    if (projectDelta == null) {
                        projectDelta = this.getDeltaFor(root.getScriptProject());
                    }
                    projectDelta.added(sideEffectPackage);
                }
                this.createdElements.add(sideEffectPackage);
            } else {
                parentFolder = (IContainer)subFolder;
            }
            ++i;
        }
        return containsReadOnlyScriptFolder;
    }

    private ModelElementDelta getDeltaFor(IScriptProject scriptProject) {
        ModelElementDelta delta = (ModelElementDelta)this.deltasPerProject.get(scriptProject);
        if (delta == null) {
            delta = new ModelElementDelta(scriptProject);
            this.deltasPerProject.put(scriptProject, delta);
        }
        return delta;
    }

    protected String getMainTaskName() {
        return Messages.operation_copyResourceProgress;
    }

    protected void prepareDeltas(IModelElement sourceElement, IModelElement destinationElement, boolean isMove) {
        if (Util.isExcluded(sourceElement) || Util.isExcluded(destinationElement)) {
            return;
        }
        IScriptProject destProject = destinationElement.getScriptProject();
        if (isMove) {
            IScriptProject sourceProject = sourceElement.getScriptProject();
            this.getDeltaFor(sourceProject).movedFrom(sourceElement, destinationElement);
            this.getDeltaFor(destProject).movedTo(destinationElement, sourceElement);
        } else {
            this.getDeltaFor(destProject).added(destinationElement);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processSourceModuleResource(ISourceModule source, ScriptFolder dest) throws ModelException {
        String newCUName = this.getNewNameFor(source);
        String destName = newCUName != null ? newCUName : source.getElementName();
        IFile sourceResource = (IFile)source.getResource();
        IContainer destFolder = (IContainer)dest.getResource();
        IFile destFile = destFolder.getFile((IPath)new Path(destName));
        SourceModule destCU = new SourceModule(dest, destName, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
        if (sourceResource != null && destFile.equals((Object)sourceResource)) {
            if (this.force) return;
            throw new ModelException(new ModelStatus(977, Messages.bind(Messages.status_nameCollision, destFile.getFullPath().toString())));
        }
        try {
            if (!destCU.isWorkingCopy()) {
                int flags;
                if (destFile.exists()) {
                    if (!this.force) throw new ModelException(new ModelStatus(977, Messages.bind(Messages.status_nameCollision, destFile.getFullPath().toString())));
                    this.deleteResource((IResource)destFile, 2);
                    destCU.close();
                }
                int n = flags = this.force ? 1 : 0;
                if (this.isMove()) {
                    flags |= 2;
                    if (sourceResource == null) {
                        if (!DLTKCore.DEBUG) throw new ModelException(new ModelStatus(977, Messages.bind(Messages.status_invalidResource, destFile.getFullPath().toString())));
                        System.err.println("TODO: Add correct status message here...");
                        throw new ModelException(new ModelStatus(977, Messages.bind(Messages.status_invalidResource, destFile.getFullPath().toString())));
                    }
                    sourceResource.move(destFile.getFullPath(), flags, this.getSubProgressMonitor(1));
                } else if (sourceResource == null) {
                    ByteArrayInputStream bais = new ByteArrayInputStream(new byte[0]);
                    destFile.create((InputStream)bais, 1, this.getSubProgressMonitor(1));
                    destCU.getBuffer().setContents(source.getSourceAsCharArray());
                    destCU.save(this.getSubProgressMonitor(1), true);
                } else {
                    sourceResource.copy(destFile.getFullPath(), flags, this.getSubProgressMonitor(1));
                }
                this.setAttribute("hasModifiedResource", "true");
            } else {
                destCU.getBuffer().setContents(source.getBuffer().getContents());
            }
        }
        catch (ModelException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
        this.prepareDeltas(source, destCU, this.isMove());
        if (newCUName == null) return;
        if (DLTKCore.DEBUG) {
            System.err.println("TODO: Add remove extensions here...");
        }
        String oldName = source.getElementName();
        String newName = newCUName;
        this.prepareDeltas(source.getType(oldName), destCU.getType(newName), this.isMove());
    }

    protected void processDeltas() {
        Iterator deltas = this.deltasPerProject.values().iterator();
        while (deltas.hasNext()) {
            this.addDelta((IModelElementDelta)deltas.next());
        }
    }

    protected void processElement(IModelElement element) throws ModelException {
        IModelElement dest = this.getDestinationParent(element);
        switch (element.getElementType()) {
            case 5: {
                this.processSourceModuleResource((ISourceModule)element, (ScriptFolder)dest);
                this.createdElements.add(((IScriptFolder)dest).getSourceModule(element.getElementName()));
                break;
            }
            case 4: {
                this.processScriptFolderResource((ScriptFolder)element, (ProjectFragment)dest, this.getNewNameFor(element));
                break;
            }
            default: {
                throw new ModelException(new ModelStatus(967, element));
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processElements() throws ModelException {
        this.createdElements = new ArrayList(this.elementsToProcess.length);
        try {
            super.processElements();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.resultElements = new IModelElement[this.createdElements.size()];
            this.createdElements.toArray(this.resultElements);
            this.processDeltas();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.resultElements = new IModelElement[this.createdElements.size()];
        this.createdElements.toArray(this.resultElements);
        this.processDeltas();
    }

    private void processScriptFolderResource(ScriptFolder source, ProjectFragment root, String newName) throws ModelException {
        try {
            IPath newFragName = newName == null ? source.path : new Path(newName);
            IScriptFolder newFrag = root.getScriptFolder(newFragName);
            IResource[] resources = this.collectResourcesOfInterest(source);
            boolean shouldMoveFolder = this.isMove() && newFrag.getResource() != null && !newFrag.getResource().exists();
            IFolder srcFolder = (IFolder)source.getResource();
            IPath destPath = newFrag.getPath();
            if (shouldMoveFolder) {
                if (srcFolder.getFullPath().isPrefixOf(destPath)) {
                    shouldMoveFolder = false;
                } else {
                    IResource[] members = srcFolder.members();
                    int i = 0;
                    while (i < members.length) {
                        if (members[i] instanceof IFolder) {
                            shouldMoveFolder = false;
                            break;
                        }
                        ++i;
                    }
                }
            }
            boolean containsReadOnlySubScriptFolders = this.createNeededScriptFolders((IContainer)source.getParent().getResource(), root, newFragName, shouldMoveFolder);
            boolean sourceIsReadOnly = Util.isReadOnly((IResource)srcFolder);
            if (shouldMoveFolder) {
                if (sourceIsReadOnly) {
                    Util.setReadOnly((IResource)srcFolder, false);
                }
                srcFolder.move(destPath, this.force, true, this.getSubProgressMonitor(1));
                if (sourceIsReadOnly) {
                    Util.setReadOnly((IResource)srcFolder, true);
                }
                this.setAttribute("hasModifiedResource", "true");
            } else if (resources.length > 0) {
                IResource destinationResource;
                int max;
                int i;
                if (this.isRename()) {
                    if (!destPath.equals((Object)source.getPath())) {
                        this.moveResources(resources, destPath);
                    }
                } else if (this.isMove()) {
                    i = 0;
                    max = resources.length;
                    while (i < max) {
                        destinationResource = ResourcesPlugin.getWorkspace().getRoot().findMember(destPath.append(resources[i].getName()));
                        if (destinationResource != null) {
                            if (this.force) {
                                this.deleteResource(destinationResource, 2);
                            } else {
                                throw new ModelException(new ModelStatus(977, Messages.bind(Messages.status_nameCollision, destinationResource.getFullPath().toString())));
                            }
                        }
                        ++i;
                    }
                    this.moveResources(resources, destPath);
                } else {
                    i = 0;
                    max = resources.length;
                    while (i < max) {
                        destinationResource = ResourcesPlugin.getWorkspace().getRoot().findMember(destPath.append(resources[i].getName()));
                        if (destinationResource != null) {
                            if (this.force) {
                                this.deleteResource(destinationResource, 2);
                            } else {
                                throw new ModelException(new ModelStatus(977, Messages.bind(Messages.status_nameCollision, destinationResource.getFullPath().toString())));
                            }
                        }
                        ++i;
                    }
                    this.copyResources(resources, destPath);
                }
            }
            if (!Util.equalArraysOrNull(new Object[]{newFragName}, new Object[]{source.path})) {
                char[][] inclusionPatterns = root.fullInclusionPatternChars();
                char[][] exclusionPatterns = root.fullExclusionPatternChars();
                int i = 0;
                while (i < resources.length) {
                    ISourceModule cu;
                    String resourceName = resources[i].getName();
                    IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(newFrag);
                    if (toolkit != null && DLTKContentTypeManager.isValidResourceForContentType(toolkit, resources[i]) && !Util.isExcluded((cu = newFrag.getSourceModule(resourceName)).getPath(), inclusionPatterns, exclusionPatterns, false)) {
                        if (DLTKCore.DEBUG) {
                            System.err.println("TODO:Add source module modification code here...");
                        }
                        cu.save(null, false);
                    }
                    ++i;
                }
            }
            boolean isEmpty = true;
            if (this.isMove() && srcFolder != null) {
                this.updateReadOnlyScriptFoldersForMove((IContainer)source.getParent().getResource(), root, newFragName, sourceIsReadOnly);
                if (srcFolder.exists()) {
                    IResource[] remaining = srcFolder.members();
                    int i = 0;
                    int length = remaining.length;
                    while (i < length) {
                        IResource file = remaining[i];
                        if (file instanceof IFile) {
                            if (Util.isReadOnly(file)) {
                                Util.setReadOnly(file, false);
                            }
                            this.deleteResource(file, 3);
                        } else {
                            isEmpty = false;
                        }
                        ++i;
                    }
                }
                if (isEmpty) {
                    IResource rootResource = destPath.isPrefixOf(srcFolder.getFullPath()) ? newFrag.getResource() : source.getParent().getResource();
                    this.deleteEmptyScriptFolder(source, false, rootResource);
                }
            } else if (containsReadOnlySubScriptFolders) {
                this.updateReadOnlyScriptFoldersForCopy((IContainer)source.getParent().getResource(), root, newFragName);
            }
            if (isEmpty && this.isMove() && !Util.isExcluded(source) && !Util.isExcluded(newFrag)) {
                IScriptProject sourceProject = source.getScriptProject();
                this.getDeltaFor(sourceProject).movedFrom(source, newFrag);
                IScriptProject destProject = newFrag.getScriptProject();
                this.getDeltaFor(destProject).movedTo(newFrag, source);
            }
        }
        catch (ModelException e) {
            throw e;
        }
        catch (CoreException ce) {
            throw new ModelException(ce);
        }
    }

    private void updateReadOnlyScriptFoldersForCopy(IContainer sourceFolder, IProjectFragment root, IPath newFragName) {
        IContainer parentFolder = (IContainer)root.getResource();
        int i = 0;
        int length = newFragName.segmentCount();
        while (i < length) {
            String subFolderName = newFragName.segment(i);
            parentFolder = parentFolder.getFolder((IPath)new Path(subFolderName));
            if ((sourceFolder = sourceFolder.getFolder((IPath)new Path(subFolderName))).exists() && Util.isReadOnly((IResource)sourceFolder)) {
                Util.setReadOnly((IResource)parentFolder, true);
            }
            ++i;
        }
    }

    private void updateReadOnlyScriptFoldersForMove(IContainer sourceFolder, IProjectFragment root, IPath newFragName, boolean sourceFolderIsReadOnly) {
        IContainer parentFolder = (IContainer)root.getResource();
        int i = 0;
        int length = newFragName.segmentCount();
        while (i < length) {
            String subFolderName = newFragName.segment(i);
            parentFolder = parentFolder.getFolder((IPath)new Path(subFolderName));
            if ((sourceFolder = sourceFolder.getFolder((IPath)new Path(subFolderName))).exists() && Util.isReadOnly((IResource)sourceFolder) || i == length - 1 && sourceFolderIsReadOnly) {
                Util.setReadOnly((IResource)parentFolder, true);
                Util.setReadOnly((IResource)sourceFolder, false);
            }
            ++i;
        }
    }

    protected IModelStatus verify() {
        IModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        if (this.renamingsList != null && this.renamingsList.length != this.elementsToProcess.length) {
            return new ModelStatus(980);
        }
        return ModelStatus.VERIFIED_OK;
    }

    protected void verify(IModelElement element) throws ModelException {
        int elementType;
        IResource resource;
        if (element == null || !element.exists()) {
            this.error(969, element);
        }
        if (element.isReadOnly() && (this.isRename() || this.isMove())) {
            this.error(976, element);
        }
        if ((resource = element.getResource()) instanceof IFolder && resource.isLinked()) {
            this.error(995, element);
        }
        if ((elementType = element.getElementType()) == 5 && element instanceof SourceModule) {
            SourceModule compilationUnit = (SourceModule)element;
            if (this.isMove() && compilationUnit.isWorkingCopy() && !compilationUnit.isPrimary()) {
                this.error(967, element);
            }
        } else if (elementType == 5 && element instanceof ExternalSourceModule) {
            if (this.isMove()) {
                this.error(967, element);
            }
        } else if (elementType == 5 && element instanceof BuiltinSourceModule) {
            if (this.isMove()) {
                this.error(967, element);
            }
        } else if (elementType != 4) {
            this.error(967, element);
        }
        ModelElement dest = (ModelElement)this.getDestinationParent(element);
        this.verifyDestination(element, dest);
        if (this.renamings != null) {
            this.verifyRenaming(element);
        }
    }
}

