/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.testing.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.testing.MemberResolverManager;
import org.eclipse.dltk.internal.testing.ui.DLTKTestingMessages;
import org.eclipse.dltk.internal.testing.ui.TestRunnerViewPart;
import org.eclipse.dltk.testing.ITestingElementResolver;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class OpenEditorAction
extends Action {
    protected String fName;
    protected TestRunnerViewPart fTestRunner;
    private final boolean fActivate;

    protected OpenEditorAction(TestRunnerViewPart testRunner, String testClassName) {
        this(testRunner, testClassName, true);
    }

    public OpenEditorAction(TestRunnerViewPart testRunner, String className, boolean activate) {
        super(DLTKTestingMessages.OpenEditorAction_action_label);
        this.fName = className;
        this.fTestRunner = testRunner;
        this.fActivate = activate;
    }

    public void run() {
        ITextEditor textEditor = null;
        try {
            IModelElement element = this.findMember(this.getLaunchedProject(), this.fName);
            if (element == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)DLTKTestingMessages.OpenEditorAction_error_cannotopen_title, (String)DLTKTestingMessages.OpenEditorAction_error_cannotopen_message);
                return;
            }
            textEditor = (ITextEditor)DLTKUIPlugin.openInEditor((IModelElement)element, (boolean)this.fActivate, (boolean)false);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)DLTKTestingMessages.OpenEditorAction_error_dialog_title, (String)DLTKTestingMessages.OpenEditorAction_error_dialog_message, (IStatus)e.getStatus());
            return;
        }
        if (textEditor == null) {
            this.fTestRunner.registerInfoMessage(DLTKTestingMessages.OpenEditorAction_message_cannotopen);
            return;
        }
        this.reveal(textEditor);
    }

    protected Shell getShell() {
        return this.fTestRunner.getSite().getShell();
    }

    protected IScriptProject getLaunchedProject() {
        return this.fTestRunner.getLaunchedProject();
    }

    protected String getClassName() {
        return this.fName;
    }

    protected IModelElement findMember(IScriptProject project, String name) throws ModelException {
        String id;
        IModelElement element;
        ILaunchConfiguration launchConfiguration;
        IScriptProject launchedProject;
        block5: {
            launchedProject = this.fTestRunner.getLaunchedProject();
            ILaunch launch = this.fTestRunner.getLaunch();
            launchConfiguration = launch.getLaunchConfiguration();
            element = null;
            id = null;
            try {
                id = launchConfiguration.getAttribute("org.eclipse.dltk.testing.engineId", "");
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block5;
                e.printStackTrace();
            }
        }
        if (id != null) {
            ITestingElementResolver resolver = MemberResolverManager.getResolver(id);
            if (resolver == null) {
                return element;
            }
            ISourceModule module = this.resolveSourceModule(launchedProject, launchConfiguration);
            element = resolver.resolveElement(launchedProject, launchConfiguration, module, name);
            if (element == null) {
                String title = DLTKTestingMessages.OpenTestAction_error_title;
                String message = "Error";
                MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
                return element;
            }
        }
        return element;
    }

    protected ISourceModule resolveSourceModule(IScriptProject launchedProject, ILaunchConfiguration launchConfiguration) {
        String scriptName;
        try {
            scriptName = launchConfiguration.getAttribute("mainScript", null);
        }
        catch (CoreException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
        IProject prj = launchedProject.getProject();
        IResource file = prj.findMember((IPath)new Path(scriptName));
        if (file instanceof IFile) {
            return (ISourceModule)DLTKCore.create((IResource)file);
        }
        return null;
    }

    protected abstract void reveal(ITextEditor var1);
}

