/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.launching;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.dltk.internal.launching.LazyFileHandle;
import org.eclipse.dltk.launching.EnvironmentVariable;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.InterpreterStandin;
import org.eclipse.dltk.launching.LaunchingMessages;
import org.eclipse.dltk.launching.LibraryLocation;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class InterpreterDefinitionsContainer {
    private static final String PATH_ATTR = "path";
    private static final String INTERPRETER_NAME_ATTR = "name";
    private static final String INTERPRETER_TAG = "interpreter";
    private static final String INTERPRETER_TYPE_TAG = "interpreterType";
    private static final String ID_ATTR = "id";
    private static final String NATURE_ATTR = "nature";
    private static final String ENVIRONMENT_ATTR = "environment";
    private static final String DEFAULT_INTERPRETER_TAG = "defaultInterpreter";
    private static final String INTERPRETER_SETTINGS_TAG = "interpreterSettings";
    private static final String VARIABLE_VALUE_ATTR = "variableValue";
    private static final String VARIABLE_NAME_ATTR = "variableName";
    private static final String LIBRARY_PATH_ATTR = "libraryPath";
    private static final String IARGS_ATTR = "iargs";
    private static final String ENVIRONMENT_VARIABLES_TAG = "environmentVariables";
    private static final String ENVIRONMENT_VARIABLE_TAG = "environmentVariable";
    private static final String LIBRARY_LOCATIONS_TAG = "libraryLocations";
    private static final String LIBRARY_LOCATION_TAG = "libraryLocation";
    private static final String ENVIRONMENT_ID = "environmentId";
    private Map fInterTypeToInterMap = new HashMap(10);
    private List fInterpreterList = new ArrayList(10);
    private Map fDefaultInterpreterInstallCompositeID = new HashMap();
    private Map fDefaultInterpreterInstallConnectorTypeID = new HashMap();

    public ScriptRuntime.DefaultInterpreterEntry[] getInterpreterNatures() {
        Set s = this.fDefaultInterpreterInstallCompositeID.keySet();
        return s.toArray(new ScriptRuntime.DefaultInterpreterEntry[s.size()]);
    }

    public void addInterpreter(IInterpreterInstall Interpreter) {
        if (!this.fInterpreterList.contains(Interpreter)) {
            IInterpreterInstallType InterpreterInstallType = Interpreter.getInterpreterInstallType();
            ArrayList<IInterpreterInstall> InterpreterList = (ArrayList<IInterpreterInstall>)this.fInterTypeToInterMap.get(InterpreterInstallType);
            if (InterpreterList == null) {
                InterpreterList = new ArrayList<IInterpreterInstall>(3);
                this.fInterTypeToInterMap.put(InterpreterInstallType, InterpreterList);
            }
            InterpreterList.add(Interpreter);
            Interpreter.getInstallLocation();
            this.fInterpreterList.add(Interpreter);
        }
    }

    public void addInterpreterList(List InterpreterList) {
        Iterator iterator = InterpreterList.iterator();
        while (iterator.hasNext()) {
            IInterpreterInstall Interpreter = (IInterpreterInstall)iterator.next();
            this.addInterpreter(Interpreter);
        }
    }

    public Map getInterpreterTypeToInterpreterMap() {
        return this.fInterTypeToInterMap;
    }

    public List getInterpreterList() {
        return this.fInterpreterList;
    }

    public List getInterpreterList(ScriptRuntime.DefaultInterpreterEntry nature) {
        ArrayList<IInterpreterInstall> res = new ArrayList<IInterpreterInstall>(this.fInterpreterList.size());
        Iterator iter = this.fInterpreterList.iterator();
        while (iter.hasNext()) {
            IInterpreterInstall interpreter = (IInterpreterInstall)iter.next();
            IEnvironment environment = interpreter.getEnvironment();
            if (environment == null) continue;
            String id = environment.getId();
            if (!interpreter.getInterpreterInstallType().getNatureId().equals(nature.getNature()) || !id.equals(nature.getEnvironment())) continue;
            res.add(interpreter);
        }
        return res;
    }

    public List getValidInterpreterList() {
        List Interpreters = this.getInterpreterList();
        ArrayList resultList = new ArrayList(Interpreters.size());
        resultList.addAll(Interpreters);
        return resultList;
    }

    public List getValidInterpreterList(ScriptRuntime.DefaultInterpreterEntry nature) {
        List interpreters = this.getInterpreterList(nature);
        ArrayList resultList = new ArrayList(interpreters.size());
        resultList.addAll(interpreters);
        return resultList;
    }

    public String getDefaultInterpreterInstallCompositeID(ScriptRuntime.DefaultInterpreterEntry nature) {
        return (String)this.fDefaultInterpreterInstallCompositeID.get(nature);
    }

    public String[] getDefaultInterpreterInstallCompositeID() {
        Collection ids = this.fDefaultInterpreterInstallCompositeID.values();
        return ids.toArray(new String[ids.size()]);
    }

    public void setDefaultInterpreterInstallCompositeID(ScriptRuntime.DefaultInterpreterEntry nature, String id) {
        if (id != null) {
            this.fDefaultInterpreterInstallCompositeID.put(nature, id);
        } else {
            this.fDefaultInterpreterInstallCompositeID.remove(nature);
        }
    }

    public String getDefaultInterpreterInstallConnectorTypeID(ScriptRuntime.DefaultInterpreterEntry nature) {
        return (String)this.fDefaultInterpreterInstallConnectorTypeID.get(nature);
    }

    public void setDefaultInterpreterInstallConnectorTypeID(ScriptRuntime.DefaultInterpreterEntry nature, String id) {
        this.fDefaultInterpreterInstallConnectorTypeID.put(nature, id);
    }

    public String getAsXML() throws ParserConfigurationException, IOException, TransformerException {
        Document doc = DLTKLaunchingPlugin.getDocument();
        Element config = doc.createElement(INTERPRETER_SETTINGS_TAG);
        doc.appendChild(config);
        ArrayList keys = new ArrayList();
        keys.addAll(this.fDefaultInterpreterInstallCompositeID.keySet());
        Collections.sort(keys, new DefaultInterpreterComparator());
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            ScriptRuntime.DefaultInterpreterEntry entry = (ScriptRuntime.DefaultInterpreterEntry)iter.next();
            Element defaulte = doc.createElement(DEFAULT_INTERPRETER_TAG);
            config.appendChild(defaulte);
            defaulte.setAttribute(NATURE_ATTR, entry.getNature());
            defaulte.setAttribute(ENVIRONMENT_ATTR, entry.getEnvironment());
            defaulte.setAttribute(ID_ATTR, (String)this.fDefaultInterpreterInstallCompositeID.get(entry));
        }
        ArrayList keys2 = new ArrayList();
        keys2.addAll(this.fDefaultInterpreterInstallConnectorTypeID.keySet());
        Collections.sort(keys2, new DefaultInterpreterComparator());
        Iterator iter2 = keys2.iterator();
        while (iter2.hasNext()) {
            ScriptRuntime.DefaultInterpreterEntry entry = (ScriptRuntime.DefaultInterpreterEntry)iter2.next();
            Element defaulte = doc.createElement("defaultInterpreterConnector");
            config.appendChild(defaulte);
            defaulte.setAttribute(NATURE_ATTR, entry.getNature());
            defaulte.setAttribute(ENVIRONMENT_ATTR, entry.getEnvironment());
            defaulte.setAttribute(ID_ATTR, (String)this.fDefaultInterpreterInstallConnectorTypeID.get(entry));
        }
        Set InterpreterInstallTypeSet = this.getInterpreterTypeToInterpreterMap().keySet();
        Iterator keyIterator = InterpreterInstallTypeSet.iterator();
        while (keyIterator.hasNext()) {
            IInterpreterInstallType InterpreterInstallType = (IInterpreterInstallType)keyIterator.next();
            Element InterpreterTypeElement = this.interpreterTypeAsElement(doc, InterpreterInstallType);
            config.appendChild(InterpreterTypeElement);
        }
        return DLTKLaunchingPlugin.serializeDocument(doc);
    }

    private Element interpreterTypeAsElement(Document doc, IInterpreterInstallType InterpreterType) {
        Element element = doc.createElement(INTERPRETER_TYPE_TAG);
        element.setAttribute(ID_ATTR, InterpreterType.getId());
        List InterpreterList = (List)this.getInterpreterTypeToInterpreterMap().get(InterpreterType);
        Iterator InterpreterIterator = InterpreterList.iterator();
        while (InterpreterIterator.hasNext()) {
            IInterpreterInstall Interpreter = (IInterpreterInstall)InterpreterIterator.next();
            Element InterpreterElement = this.interpreterAsElement(doc, Interpreter);
            element.appendChild(InterpreterElement);
        }
        return element;
    }

    private Element interpreterAsElement(Document doc, IInterpreterInstall interpreter) {
        String[] InterpreterArgs;
        EnvironmentVariable[] environmentVariables;
        Element element = doc.createElement(INTERPRETER_TAG);
        element.setAttribute(ID_ATTR, interpreter.getId());
        element.setAttribute(INTERPRETER_NAME_ATTR, interpreter.getName());
        element.setAttribute(ENVIRONMENT_ID, interpreter.getInstallLocation().getEnvironmentId());
        String installPath = "";
        IFileHandle installLocation = interpreter.getRawInstallLocation();
        if (installLocation != null) {
            installPath = installLocation.getPath().toPortableString();
        }
        element.setAttribute(PATH_ATTR, installPath);
        LibraryLocation[] libraryLocations = interpreter.getLibraryLocations();
        if (libraryLocations != null) {
            Element libLocationElement = InterpreterDefinitionsContainer.libraryLocationsAsElement(doc, libraryLocations);
            element.appendChild(libLocationElement);
        }
        if ((environmentVariables = interpreter.getEnvironmentVariables()) != null) {
            Element environmentVariableElement = InterpreterDefinitionsContainer.environmentVariablesAsElement(doc, environmentVariables);
            element.appendChild(environmentVariableElement);
        }
        if ((InterpreterArgs = interpreter.getInterpreterArguments()) != null && InterpreterArgs.length > 0) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < InterpreterArgs.length) {
                buffer.append(String.valueOf(InterpreterArgs[i]) + " ");
                ++i;
            }
            element.setAttribute(IARGS_ATTR, buffer.toString());
        }
        return element;
    }

    private static Element libraryLocationsAsElement(Document doc, LibraryLocation[] locations) {
        Element root = doc.createElement(LIBRARY_LOCATIONS_TAG);
        int i = 0;
        while (i < locations.length) {
            Element element = doc.createElement(LIBRARY_LOCATION_TAG);
            element.setAttribute(LIBRARY_PATH_ATTR, locations[i].getLibraryPath().toString());
            root.appendChild(element);
            ++i;
        }
        return root;
    }

    private static Element environmentVariablesAsElement(Document doc, EnvironmentVariable[] variables) {
        Element root = doc.createElement(ENVIRONMENT_VARIABLES_TAG);
        int i = 0;
        while (i < variables.length) {
            Element element = doc.createElement(ENVIRONMENT_VARIABLE_TAG);
            element.setAttribute(VARIABLE_NAME_ATTR, variables[i].getName());
            element.setAttribute(VARIABLE_VALUE_ATTR, variables[i].getValue());
            root.appendChild(element);
            ++i;
        }
        return root;
    }

    public static InterpreterDefinitionsContainer parseXMLIntoContainer(InputStream inputStream) throws IOException {
        InterpreterDefinitionsContainer container = new InterpreterDefinitionsContainer();
        InterpreterDefinitionsContainer.parseXMLIntoContainer(inputStream, container);
        return container;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void parseXMLIntoContainer(InputStream inputStream, InterpreterDefinitionsContainer container) throws IOException {
        BufferedInputStream stream = new BufferedInputStream(inputStream);
        Element config = null;
        try {
            try {
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                parser.setErrorHandler(new DefaultHandler());
                config = parser.parse(new InputSource(stream)).getDocumentElement();
            }
            catch (SAXException sAXException) {
                throw new IOException(LaunchingMessages.ScriptRuntime_badFormat);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                ((InputStream)stream).close();
                throw new IOException(LaunchingMessages.ScriptRuntime_badFormat);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            ((InputStream)stream).close();
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        ((InputStream)stream).close();
        if (!config.getNodeName().equalsIgnoreCase(INTERPRETER_SETTINGS_TAG)) {
            throw new IOException(LaunchingMessages.ScriptRuntime_badFormat);
        }
        NodeList list = config.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type == 1) {
                ScriptRuntime.DefaultInterpreterEntry entry;
                String nature;
                Element interpreterTypeElement = (Element)node;
                if (interpreterTypeElement.getNodeName().equalsIgnoreCase(INTERPRETER_TYPE_TAG)) {
                    InterpreterDefinitionsContainer.populateInterpreterTypes(interpreterTypeElement, container);
                }
                if (interpreterTypeElement.getNodeName().equalsIgnoreCase(DEFAULT_INTERPRETER_TAG)) {
                    nature = interpreterTypeElement.getAttribute(NATURE_ATTR);
                    String id = interpreterTypeElement.getAttribute(ID_ATTR);
                    String environment = interpreterTypeElement.getAttribute(ENVIRONMENT_ATTR);
                    if ("".equals(environment)) {
                        environment = "org.eclipse.dltk.core.environment.localEnvironment";
                    }
                    entry = new ScriptRuntime.DefaultInterpreterEntry(nature, environment);
                    container.setDefaultInterpreterInstallCompositeID(entry, id);
                }
                if (interpreterTypeElement.getNodeName().equalsIgnoreCase("defaultInterpreterConnector")) {
                    nature = interpreterTypeElement.getAttribute(NATURE_ATTR);
                    String environment = interpreterTypeElement.getAttribute(ENVIRONMENT_ATTR);
                    String id = interpreterTypeElement.getAttribute(ID_ATTR);
                    entry = new ScriptRuntime.DefaultInterpreterEntry(nature, environment);
                    container.setDefaultInterpreterInstallConnectorTypeID(entry, id);
                }
            }
            ++i;
        }
        return;
    }

    private static void populateInterpreterTypes(Element InterpreterTypeElement, InterpreterDefinitionsContainer container) {
        String id = InterpreterTypeElement.getAttribute(ID_ATTR);
        IInterpreterInstallType InterpreterType = ScriptRuntime.getInterpreterInstallType(id);
        if (InterpreterType != null) {
            NodeList InterpreterNodeList = InterpreterTypeElement.getChildNodes();
            int i = 0;
            while (i < InterpreterNodeList.getLength()) {
                Element InterpreterElement;
                Node InterpreterNode = InterpreterNodeList.item(i);
                short type = InterpreterNode.getNodeType();
                if (type == 1 && (InterpreterElement = (Element)InterpreterNode).getNodeName().equalsIgnoreCase(INTERPRETER_TAG)) {
                    InterpreterDefinitionsContainer.populateInterpreterForType(InterpreterType, InterpreterElement, container);
                }
                ++i;
            }
        } else {
            DLTKLaunchingPlugin.log("Interpreter type element with unknown id.");
        }
    }

    private static void populateInterpreterForType(IInterpreterInstallType installType, Element element, InterpreterDefinitionsContainer container) {
        String id = element.getAttribute(ID_ATTR);
        if (id != null) {
            String installPath = element.getAttribute(PATH_ATTR);
            if (installPath == null) {
                return;
            }
            String envId = element.getAttribute(ENVIRONMENT_ID);
            InterpreterStandin standin = new InterpreterStandin(installType, id);
            standin.setName(element.getAttribute(INTERPRETER_NAME_ATTR));
            standin.setInstallLocation(new LazyFileHandle(envId, (IPath)new Path(installPath)));
            container.addInterpreter(standin);
            NodeList list = element.getChildNodes();
            int length = list.getLength();
            int i = 0;
            while (i < length) {
                Node node = list.item(i);
                short type = node.getNodeType();
                if (type == 1) {
                    Element subElement = (Element)node;
                    String subElementName = subElement.getNodeName();
                    if (subElementName.equals(LIBRARY_LOCATION_TAG)) {
                        LibraryLocation loc = InterpreterDefinitionsContainer.getLibraryLocation(subElement);
                        standin.setLibraryLocations(new LibraryLocation[]{loc});
                    } else if (subElementName.equals(LIBRARY_LOCATIONS_TAG)) {
                        InterpreterDefinitionsContainer.setLibraryLocations(standin, subElement);
                    } else if (subElementName.equals(ENVIRONMENT_VARIABLE_TAG)) {
                        EnvironmentVariable var = InterpreterDefinitionsContainer.getEnvironmentVariable(subElement);
                        standin.setEnvironmentVariables(new EnvironmentVariable[]{var});
                    } else if (subElementName.equals(ENVIRONMENT_VARIABLES_TAG)) {
                        InterpreterDefinitionsContainer.setEnvironmentVariables(standin, subElement);
                    }
                }
                ++i;
            }
            String args = element.getAttribute(IARGS_ATTR);
            if (args != null && args.length() > 0) {
                standin.setInterpreterArgs(args);
            }
        } else {
            DLTKLaunchingPlugin.log("id attribute missing from Interpreter element specification.");
        }
    }

    private static LibraryLocation getLibraryLocation(Element libLocationElement) {
        String interpreterEnvironmentArchive = libLocationElement.getAttribute(LIBRARY_PATH_ATTR);
        if (interpreterEnvironmentArchive != null) {
            return new LibraryLocation(Path.fromPortableString((String)interpreterEnvironmentArchive));
        }
        DLTKLaunchingPlugin.log("Library location element is specified incorrectly.");
        return null;
    }

    private static EnvironmentVariable getEnvironmentVariable(Element libLocationElement) {
        String name = libLocationElement.getAttribute(VARIABLE_NAME_ATTR);
        String value = libLocationElement.getAttribute(VARIABLE_VALUE_ATTR);
        if (name != null && value != null) {
            return new EnvironmentVariable(name, value);
        }
        DLTKLaunchingPlugin.log("Environment variable element is specified incorrectly.");
        return null;
    }

    private static void setLibraryLocations(IInterpreterInstall Interpreter, Element libLocationsElement) {
        NodeList list = libLocationsElement.getChildNodes();
        int length = list.getLength();
        ArrayList<LibraryLocation> locations = new ArrayList<LibraryLocation>(length);
        int i = 0;
        while (i < length) {
            Element libraryLocationElement;
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type == 1 && (libraryLocationElement = (Element)node).getNodeName().equals(LIBRARY_LOCATION_TAG)) {
                locations.add(InterpreterDefinitionsContainer.getLibraryLocation(libraryLocationElement));
            }
            ++i;
        }
        Interpreter.setLibraryLocations(locations.toArray(new LibraryLocation[locations.size()]));
    }

    private static void setEnvironmentVariables(IInterpreterInstall Interpreter, Element environmentVariablesElement) {
        NodeList list = environmentVariablesElement.getChildNodes();
        int length = list.getLength();
        ArrayList<EnvironmentVariable> variables = new ArrayList<EnvironmentVariable>(length);
        int i = 0;
        while (i < length) {
            Element envVarElement;
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type == 1 && (envVarElement = (Element)node).getNodeName().equals(ENVIRONMENT_VARIABLE_TAG)) {
                variables.add(InterpreterDefinitionsContainer.getEnvironmentVariable(envVarElement));
            }
            ++i;
        }
        Interpreter.setEnvironmentVariables(variables.toArray(new EnvironmentVariable[variables.size()]));
    }

    public void removeInterpreter(IInterpreterInstall Interpreter) {
        this.fInterpreterList.remove(Interpreter);
        List list = (List)this.fInterTypeToInterMap.get(Interpreter.getInterpreterInstallType());
        if (list != null) {
            list.remove(Interpreter);
        }
    }

    private final class DefaultInterpreterComparator
    implements Comparator {
        private DefaultInterpreterComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            ScriptRuntime.DefaultInterpreterEntry entry0 = (ScriptRuntime.DefaultInterpreterEntry)arg0;
            ScriptRuntime.DefaultInterpreterEntry entry1 = (ScriptRuntime.DefaultInterpreterEntry)arg1;
            String k0 = String.valueOf(entry0.getEnvironment()) + ":" + entry0.getNature();
            String k1 = String.valueOf(entry1.getEnvironment()) + ":" + entry1.getNature();
            return k0.compareTo(k1);
        }
    }
}

