/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.packages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.compiler.problem.DefaultProblem;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemFactory;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.builder.IScriptBuilder;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.core.ast.TclPackageDeclaration;
import org.eclipse.dltk.tcl.internal.core.packages.PackagesManager;

public class TclCheckBuilder
implements IScriptBuilder {
    public static final String TCL_PROBLEM_REQUIRE = "tcl.problem.require";
    IScriptProject project;

    public IStatus buildModelElements(IScriptProject project, List elements, IProgressMonitor monitor, int status) {
        Set names;
        IInterpreterInstall install;
        HashSet packagesInBuild;
        HashMap resourceToPackagesList;
        IDLTKLanguageToolkit toolkit;
        block15: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            int est = this.estimateElementsToBuild(elements);
            this.project = project;
            if (est == 0) {
                monitor.done();
                return null;
            }
            toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)project);
            if (!toolkit.getNatureId().equals("org.eclipse.dltk.tcl.core.nature")) {
                return null;
            }
            monitor.beginTask("Perfoming code checks", 101);
            resourceToPackagesList = new HashMap();
            packagesInBuild = new HashSet();
            install = null;
            try {
                install = ScriptRuntime.getInterpreterInstall((IScriptProject)project);
            }
            catch (CoreException e1) {
                if (!DLTKCore.DEBUG) break block15;
                e1.printStackTrace();
            }
        }
        if (install == null) {
            return null;
        }
        PackagesManager manager = PackagesManager.getInstance();
        Set packageNames = manager.getPackageNames(install);
        Set buildpath = TclCheckBuilder.getBuildpath(project);
        HashSet packageNamesInProject = new HashSet();
        if (status != 1 && (names = manager.getInternalPackageNames(install, project)) != null) {
            packageNamesInProject.addAll(names);
        }
        HashMap codeModels = new HashMap();
        this.processSources(elements, (IProgressMonitor)new SubProgressMonitor(monitor, 50), resourceToPackagesList, packagesInBuild, packageNamesInProject, codeModels);
        manager.setInternalPackageNames(install, packageNamesInProject);
        manager.getPathsForPackages(install, packagesInBuild);
        SubProgressMonitor spm = new SubProgressMonitor(monitor, 1);
        spm.beginTask("Seaching for packages information...", 1);
        PackagesManager.getInstance().getPathsForPackagesWithDeps(install, packagesInBuild);
        spm.worked(1);
        spm.done();
        Set keySet = resourceToPackagesList.keySet();
        IProblemFactory factory = DLTKLanguageManager.getProblemFactory((String)toolkit.getNatureId());
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 50);
        int i = 0;
        subMonitor.beginTask("Setting markers", keySet.size());
        Iterator iterator = keySet.iterator();
        while (iterator.hasNext()) {
            ISourceModule module;
            block16: {
                if (subMonitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                module = (ISourceModule)iterator.next();
                String taskTitle = "Setting markers for " + project.getElementName() + " (" + (keySet.size() - i) + "):" + module.getElementName();
                ++i;
                subMonitor.subTask(taskTitle);
                try {
                    TclCheckBuilder.cleanMarkers(module.getResource());
                }
                catch (CoreException e1) {
                    if (!DLTKCore.DEBUG) break block16;
                    e1.printStackTrace();
                }
            }
            List pkgs = (List)resourceToPackagesList.get(module);
            TclParseUtil.CodeModel model = null;
            model = (TclParseUtil.CodeModel)codeModels.get(module);
            if (model == null) {
                try {
                    model = new TclParseUtil.CodeModel(module.getSource());
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG) continue;
                    e.printStackTrace();
                    continue;
                }
            }
            IProblemReporter reporter = factory.createReporter(module.getResource());
            Iterator iterator2 = pkgs.iterator();
            while (iterator2.hasNext()) {
                TclPackageDeclaration pkg = (TclPackageDeclaration)((Object)iterator2.next());
                TclCheckBuilder.checkPackage(pkg, packageNames, reporter, model, manager, install, buildpath, project, (IProgressMonitor)subMonitor);
                if (!subMonitor.isCanceled()) continue;
                return null;
            }
            subMonitor.worked(1);
        }
        subMonitor.done();
        monitor.done();
        return null;
    }

    private static Set getBuildpath(IScriptProject project) {
        IBuildpathEntry[] resolvedBuildpath;
        try {
            resolvedBuildpath = project.getResolvedBuildpath(true);
        }
        catch (ModelException e1) {
            e1.printStackTrace();
            return null;
        }
        HashSet<IPath> buildpath = new HashSet<IPath>();
        int i = 0;
        while (i < resolvedBuildpath.length) {
            if (resolvedBuildpath[i].getEntryKind() == 1 && resolvedBuildpath[i].isExternal()) {
                buildpath.add(EnvironmentPathUtils.getLocalPath((IPath)resolvedBuildpath[i].getPath()));
            }
            ++i;
        }
        return buildpath;
    }

    private void processSources(List elements, IProgressMonitor monitor, Map resourceToPackagesList, Set packagesInBuild, Set packageNamesInProject, final Map codeModels) {
        monitor.beginTask("Performing code checks", 1);
        int i = 0;
        while (i < elements.size()) {
            block10: {
                IProjectFragment projectFragment;
                if (monitor.isCanceled()) {
                    return;
                }
                IModelElement element = (IModelElement)elements.get(i);
                if (element.getElementType() == 5 && !(projectFragment = (IProjectFragment)element.getAncestor(3)).isExternal()) {
                    try {
                        String taskTitle = "Performing code checks for " + this.project.getElementName() + " (" + (elements.size() - i) + "):" + element.getElementName();
                        monitor.subTask(taskTitle);
                        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)element);
                        if (toolkit == null) {
                            monitor.worked(1);
                        } else {
                            ISourceModule module = (ISourceModule)element;
                            SourceParserUtil.IContentAction action = new SourceParserUtil.IContentAction(){

                                public void run(ISourceModule cmodule, char[] content) {
                                    codeModels.put(cmodule, new TclParseUtil.CodeModel(new String(content)));
                                }
                            };
                            ModuleDeclaration declaration = SourceParserUtil.getModuleDeclaration((ISourceModule)module, null, (int)0, (SourceParserUtil.IContentAction)action);
                            if (declaration == null) {
                                return;
                            }
                            ArrayList list = new ArrayList();
                            resourceToPackagesList.put(module, list);
                            TclCheckBuilder.fillPackagesDeclarations(declaration, list, packagesInBuild, packageNamesInProject);
                            monitor.worked(1);
                        }
                    }
                    catch (CoreException e) {
                        if (DLTKCore.DEBUG) {
                            e.printStackTrace();
                        }
                    }
                    catch (Exception e) {
                        if (!DLTKCore.DEBUG) break block10;
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
        monitor.done();
    }

    public static void cleanMarkers(IResource resource) throws CoreException {
        IMarker[] findMarkers = resource.findMarkers("org.eclipse.dltk.core.problem", true, 2);
        int j = 0;
        while (j < findMarkers.length) {
            if (findMarkers[j].getAttribute(TCL_PROBLEM_REQUIRE, null) != null) {
                findMarkers[j].delete();
            }
            ++j;
        }
    }

    public static void fillPackagesDeclarations(ModuleDeclaration declaration, final ArrayList list, final Set packagesInBuild, final Set packageNamesInProject) throws Exception {
        declaration.traverse(new ASTVisitor(){

            public boolean visit(Statement s) throws Exception {
                if (s instanceof TclPackageDeclaration) {
                    TclPackageDeclaration pkg = (TclPackageDeclaration)s;
                    if (pkg.getStyle() == 2) {
                        TclPackageDeclaration copy = new TclPackageDeclaration(pkg);
                        String name = copy.getName();
                        if (name.indexOf("$") == -1) {
                            if (list != null) {
                                list.add(copy);
                            }
                            packagesInBuild.add(name);
                        }
                    } else if (pkg.getStyle() == 1 || pkg.getStyle() == 0) {
                        packageNamesInProject.add(pkg.getName());
                    }
                    return false;
                }
                return super.visit(s);
            }
        });
    }

    private static void reportPackageProblem(TclPackageDeclaration pkg, IProblemReporter reporter, TclParseUtil.CodeModel model, String name, String pkgName) {
        block2: {
            try {
                IMarker marker = reporter.reportProblem((IProblem)new DefaultProblem("", name, 777, null, 1, pkg.sourceStart(), pkg.sourceEnd(), model.getLineNumber(pkg.sourceStart(), pkg.sourceEnd())));
                marker.setAttribute(TCL_PROBLEM_REQUIRE, (Object)pkgName);
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    public static void checkPackage(TclPackageDeclaration pkg, Set packageNames, IProblemReporter reporter, TclParseUtil.CodeModel model, PackagesManager manager, IInterpreterInstall install, Set buildpath, IScriptProject scriptProject, IProgressMonitor monitor) {
        if (pkg.getStyle() == 2) {
            String packageName = pkg.getName();
            Set internalNames = manager.getInternalPackageNames(install, scriptProject);
            if (internalNames.contains(packageName)) {
                return;
            }
            if (TclCheckBuilder.packageIsFiltered(packageName)) {
                return;
            }
            if (!packageNames.contains(packageName) && !internalNames.contains(packageName)) {
                block9: {
                    try {
                        IMarker marker = reporter.reportProblem((IProblem)new DefaultProblem("", "Unknown package:" + packageName, 777, null, 1, pkg.sourceStart(), pkg.sourceEnd(), model.getLineNumber(pkg.sourceStart(), pkg.sourceEnd())));
                        marker.setAttribute(TCL_PROBLEM_REQUIRE, (Object)packageName);
                    }
                    catch (CoreException e) {
                        if (!DLTKCore.DEBUG) break block9;
                        e.printStackTrace();
                    }
                }
                return;
            }
            boolean error = TclCheckBuilder.checkPackage(pkg, reporter, model, manager, install, buildpath, packageName, scriptProject);
            Map dependencies = manager.getDependencies(packageName, install);
            Iterator iterator = dependencies.keySet().iterator();
            while (iterator.hasNext()) {
                if (monitor != null && monitor.isCanceled()) {
                    return;
                }
                String pkgName = (String)iterator.next();
                boolean fail = TclCheckBuilder.checkPackage(pkg, reporter, model, manager, install, buildpath, pkgName, scriptProject);
                if (!fail) continue;
                error = true;
            }
            if (error) {
                TclCheckBuilder.reportPackageProblem(pkg, reporter, model, "Package " + packageName + " has unresolved dependencies.", packageName);
            }
        }
    }

    private static boolean packageIsFiltered(String packageName) {
        if (packageName == null || packageName.length() == 0) {
            return true;
        }
        return packageName.indexOf("$") != -1 || packageName.indexOf("[") != -1 || packageName.indexOf("]") != -1;
    }

    public static boolean checkPackage(TclPackageDeclaration pkg, IProblemReporter reporter, TclParseUtil.CodeModel model, PackagesManager manager, IInterpreterInstall install, Set buildpath, String packageName, IScriptProject project) {
        Set names = manager.getInternalPackageNames(install, project);
        if (names != null && names.contains(packageName)) {
            return false;
        }
        IPath[] paths = manager.getPathsForPackage(install, packageName);
        return TclCheckBuilder.checkPackagePaths(pkg, reporter, model, buildpath, paths, packageName);
    }

    private static boolean checkPackagePaths(TclPackageDeclaration pkg, IProblemReporter reporter, TclParseUtil.CodeModel model, Set buildpath, IPath[] paths, String packageName) {
        boolean error = false;
        ArrayList<IPath> notPaths = new ArrayList<IPath>();
        if (paths != null) {
            int i = 0;
            while (i < paths.length) {
                if (!buildpath.contains(paths[i])) {
                    boolean prefix = false;
                    Iterator iterator = buildpath.iterator();
                    while (iterator.hasNext()) {
                        IPath pp = (IPath)iterator.next();
                        if (!pp.isPrefixOf(paths[i])) continue;
                        prefix = true;
                        break;
                    }
                    if (!prefix) {
                        error = true;
                        notPaths.add(paths[i]);
                    }
                }
                ++i;
            }
        }
        return error;
    }

    public IStatus buildResources(IScriptProject project, List resources, IProgressMonitor monitor, int status) {
        return null;
    }

    public int estimateElementsToBuild(List elements) {
        int estimation = 0;
        int i = 0;
        while (i < elements.size()) {
            IProjectFragment projectFragment;
            IModelElement element = (IModelElement)elements.get(i);
            if (element.getElementType() == 5 && !(projectFragment = (IProjectFragment)element.getAncestor(3)).isExternal()) {
                ++estimation;
            }
            ++i;
        }
        return estimation;
    }

    public static void checkPackage(TclPackageDeclaration pkg, IProblemReporter reporter, IScriptProject scriptProject, TclParseUtil.CodeModel model, IProgressMonitor monitor) {
        IInterpreterInstall install;
        block3: {
            install = null;
            try {
                install = ScriptRuntime.getInterpreterInstall((IScriptProject)scriptProject);
            }
            catch (CoreException e1) {
                if (!DLTKCore.DEBUG) break block3;
                e1.printStackTrace();
            }
        }
        if (install == null) {
            return;
        }
        Set buildpath = TclCheckBuilder.getBuildpath(scriptProject);
        PackagesManager manager = PackagesManager.getInstance();
        Set packageNames = manager.getPackageNames(install);
        TclCheckBuilder.checkPackage(pkg, packageNames, reporter, model, manager, install, buildpath, scriptProject, monitor);
    }

    public Set getDependencies(IScriptProject project, Set resources, Set allResources, Set oldExternalFolders, Set externalFolders) {
        if (oldExternalFolders.size() != externalFolders.size()) {
            return allResources;
        }
        HashSet min = new HashSet();
        min.addAll(oldExternalFolders);
        min.removeAll(externalFolders);
        if (min.size() != 0) {
            return allResources;
        }
        return null;
    }
}

