/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.dbgp.tests;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.dltk.dbgp.IDbgpStackLevel;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.dbgp.internal.DbgpRequest;
import org.eclipse.dltk.dbgp.internal.commands.DbgpStackCommands;
import org.eclipse.dltk.dbgp.internal.commands.IDbgpCommunicator;
import org.eclipse.dltk.debug.dbgp.tests.AbstractCommunicator;
import org.eclipse.dltk.debug.dbgp.tests.DbgpProtocolTests;
import org.w3c.dom.Element;

public class DbgpStackCommandsTests
extends DbgpProtocolTests {
    protected Element getStackDepthResponse(int transaction_id, int depth) throws IOException {
        String xml = this.getResourceAsString("get_stack_depth.xml");
        xml = MessageFormat.format(xml, Integer.toString(transaction_id), Integer.toString(depth));
        return this.parseResponse(xml);
    }

    protected Element getStackGetResponse(int transaction_id) throws IOException {
        String xml = this.getResourceAsString("stack_get.xml");
        xml = MessageFormat.format(xml, Integer.toString(transaction_id));
        return this.parseResponse(xml);
    }

    protected Element getStackLevelsResponse() {
        return null;
    }

    public void testStackDepth() throws Exception {
        final Element response = this.getStackDepthResponse(0, 3);
        DbgpStackCommands commands = new DbgpStackCommands((IDbgpCommunicator)new AbstractCommunicator(){

            public Element communicate(DbgpRequest request) throws DbgpException {
                DbgpStackCommandsTests.assertEquals((int)1, (int)request.optionCount());
                DbgpStackCommandsTests.assertTrue((boolean)request.hasOption("-i"));
                return response;
            }
        });
        int depth = commands.getStackDepth();
        DbgpStackCommandsTests.assertEquals((int)3, (int)depth);
    }

    public void testGetStackLevel() throws Exception {
        final Element response = this.getStackGetResponse(0);
        DbgpStackCommands commands = new DbgpStackCommands((IDbgpCommunicator)new AbstractCommunicator(){

            public Element communicate(DbgpRequest request) throws DbgpException {
                DbgpStackCommandsTests.assertTrue((boolean)request.hasOption("-i"));
                return response;
            }
        });
        IDbgpStackLevel level = commands.getStackLevel(0);
        DbgpStackCommandsTests.assertEquals((int)0, (int)level.getLevel());
        DbgpStackCommandsTests.assertEquals((int)8, (int)level.getLineNumber());
    }
}

