/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.dbgp.tests.service;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.dltk.dbgp.DbgpServer;
import org.eclipse.dltk.debug.dbgp.tests.service.ISocketOperation;
import org.eclipse.dltk.internal.debug.core.model.DbgpService;

public class AbstractDbgpServiceTests
extends TestCase {
    protected static final int ANY_PORT = -1;
    private static final int TIMEOUT = 5000;
    protected static final int MIN_PORT = 32768;
    protected static final int MAX_PORT = 65535;
    private final List sockets = new ArrayList();

    protected Socket connect(int port) throws IOException {
        Socket socket = new Socket();
        try {
            socket.connect(new InetSocketAddress(port), 5000);
        }
        catch (IOException e) {
            this.closeQuietly(socket);
            throw e;
        }
        this.sockets.add(socket);
        return socket;
    }

    protected Socket performOperation(int port, ISocketOperation operation) throws IOException {
        Socket socket = this.connect(port);
        operation.execute(socket);
        return socket;
    }

    protected static int findAvailablePort(int minPort, int maxPort) {
        int port = DbgpServer.findAvailablePort((int)minPort, (int)maxPort);
        AbstractDbgpServiceTests.assertTrue((port > 0 ? 1 : 0) != 0);
        return port;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.sockets.clear();
    }

    protected void tearDown() throws Exception {
        Iterator i = this.sockets.iterator();
        while (i.hasNext()) {
            this.closeQuietly((Socket)i.next());
        }
        this.sockets.clear();
        super.tearDown();
    }

    protected void closeQuietly(Socket socket) {
        try {
            socket.close();
        }
        catch (Exception exception) {}
    }

    protected DbgpService createService(int port1) {
        DbgpService service = new DbgpService(port1);
        AbstractDbgpServiceTests.assertTrue((boolean)service.waitStarted());
        return service;
    }
}

