/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.dbgp.tests.service;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class TestInitPacket {
    TestInitPacket() {
    }

    public static byte[] build(String ideKey) {
        Map attributes = TestInitPacket.createTestInitAttributes();
        attributes.put("idekey", ideKey);
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<init");
        TestInitPacket.appendAttributes(sb, attributes);
        sb.append("/>");
        try {
            return sb.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private static Map createTestInitAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("appid", "APPID");
        attributes.put("session", "DBGP_COOKIE");
        attributes.put("thread", "THREAD_ID");
        attributes.put("parent", "PARENT_APPID");
        attributes.put("language", "LANGUAGE_NAME");
        attributes.put("protocol_version", "1.0");
        attributes.put("fileuri", "file://path/to/file");
        return attributes;
    }

    private static void appendAttributes(StringBuffer sb, Map attributes) {
        Iterator i = attributes.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            TestInitPacket.appendAttribute(sb, entry.getKey(), entry.getValue());
        }
    }

    private static void appendAttribute(StringBuffer sb, Object name, Object value) {
        sb.append(' ');
        sb.append(name);
        sb.append("=\"");
        sb.append(value);
        sb.append('\"');
    }
}

