/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.debug;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.debug.core.ISmartStepEvaluator;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.launching.sourcelookup.ScriptSourceLookupDirector;

public class RubySmartStepEvaluator
implements ISmartStepEvaluator {
    public boolean skipSuspend(String[] filters, IScriptThread thread) {
        block9: {
            IDebugTarget debugTarget = thread.getDebugTarget();
            ScriptSourceLookupDirector lookup = new ScriptSourceLookupDirector();
            try {
                lookup.initializeDefaults(debugTarget.getLaunch().getLaunchConfiguration());
            }
            catch (CoreException e1) {
                if (DLTKCore.DEBUG) {
                    e1.printStackTrace();
                }
                return false;
            }
            try {
                IStackFrame topStackFrame = thread.getTopStackFrame();
                Object sourceElement = lookup.getSourceElement(topStackFrame);
                if (sourceElement instanceof IFile) {
                    IType type;
                    String typeQualifiedName;
                    IModelElement ancestor;
                    int[] bounds;
                    IModelElement elementAt;
                    ISourceModule module = (ISourceModule)DLTKCore.create((IFile)((IFile)sourceElement));
                    CodeModel codeModel = new CodeModel(module.getSource());
                    if (module.exists() && (elementAt = module.getElementAt((bounds = codeModel.getBounds(topStackFrame.getLineNumber()))[0] + 1)) != null && (ancestor = elementAt.getAncestor(7)) != null && this.filter(typeQualifiedName = (type = (IType)ancestor).getTypeQualifiedName("."), filters)) {
                        return false;
                    }
                }
            }
            catch (DebugException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block9;
                e.printStackTrace();
            }
        }
        return true;
    }

    private boolean filter(String typeQualifiedName, String[] filters) {
        int i = 0;
        while (i < filters.length) {
            if (filters[i].equals(typeQualifiedName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static class CodeModel {
        private String[] codeLines;
        private int[] codeLineLengths;

        public CodeModel(String code) {
            this.codeLines = code.split("\n");
            int count = this.codeLines.length;
            this.codeLineLengths = new int[count];
            int sum = 0;
            int i = 0;
            while (i < count) {
                this.codeLineLengths[i] = sum;
                sum += this.codeLines[i].length() + 1;
                ++i;
            }
        }

        public int[] getBounds(int lineNumber) {
            String codeLine = this.codeLines[lineNumber];
            int start = this.codeLineLengths[lineNumber];
            int end = start + codeLine.length();
            return new int[]{start, end};
        }
    }
}

