/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.tests.navigator.scriptexplorer;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import junit.framework.TestCase;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.ui.scriptview.ScriptExplorerPart;
import org.eclipse.dltk.internal.ui.util.CoreUtility;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.tests.ScriptProjectHelper;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ContentProviderTests5
extends TestCase {
    private boolean fEnableAutoBuildAfterTesting;
    private ITreeContentProvider fProvider;
    private IScriptProject fJProject;
    private IFile fDotBuildpath;
    private IFile fDotProject;

    public ContentProviderTests5(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        ContentProviderTests5.assertNotNull((Object)workspace);
        IWorkspaceDescription workspaceDesc = workspace.getDescription();
        this.fEnableAutoBuildAfterTesting = workspaceDesc.isAutoBuilding();
        if (this.fEnableAutoBuildAfterTesting) {
            ScriptProjectHelper.setAutoBuilding(false);
        }
        this.fJProject = ScriptProjectHelper.createScriptProject("ContentProviderProject");
        ContentProviderTests5.assertNotNull((Object)this.fJProject);
        Object[] resource = this.fJProject.getForeignResources();
        int i = 0;
        while (i < resource.length) {
            Object object = resource[i];
            if (object instanceof IFile) {
                IFile file = (IFile)object;
                if (".buildpath".equals(file.getName())) {
                    this.fDotBuildpath = file;
                } else if (".project".equals(file.getName())) {
                    this.fDotProject = file;
                }
            }
            ++i;
        }
        ContentProviderTests5.assertNotNull((Object)this.fDotBuildpath);
        ContentProviderTests5.assertNotNull((Object)this.fDotProject);
        this.setUpView();
    }

    private void setUpView() throws PartInitException {
        IWorkbench workbench = PlatformUI.getWorkbench();
        ContentProviderTests5.assertNotNull((Object)workbench);
        IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
        ContentProviderTests5.assertNotNull((Object)page);
        IViewPart myPart = page.showView("org.eclipse.dltk.ui.ScriptExplorer");
        if (myPart instanceof ScriptExplorerPart) {
            ScriptExplorerPart ScriptExplorerPart2 = (ScriptExplorerPart)myPart;
            this.fProvider = (ITreeContentProvider)ScriptExplorerPart2.getTreeViewer().getContentProvider();
            this.setFolding(false);
        } else {
            ContentProviderTests5.assertTrue((String)"Unable to get view", (boolean)false);
        }
        ContentProviderTests5.assertNotNull((Object)this.fProvider);
    }

    private void setFolding(boolean fold) {
        DLTKUIPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.dltk.ui.flatPackagesInPackageExplorer", fold);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        ScriptProjectHelper.delete((IModelElement)this.fJProject);
        if (this.fEnableAutoBuildAfterTesting) {
            ScriptProjectHelper.setAutoBuilding(true);
        }
    }

    private ByteArrayInputStream asInputStream(String string) throws UnsupportedEncodingException {
        return new ByteArrayInputStream(string.getBytes(ResourcesPlugin.getEncoding()));
    }

    public void REM_testProjectSource1() throws Exception {
        IPath[] inclusionFilters = new IPath[]{new Path("**"), new Path("excl/incl/")};
        IPath[] exclusionFilters = new IPath[]{new Path("excl/*"), new Path("x/*.txt"), new Path("y/")};
        IProjectFragment root = ScriptProjectHelper.addSourceContainer(this.fJProject, "", inclusionFilters, exclusionFilters);
        IScriptFolder defaultPackage = root.createScriptFolder("", true, null);
        IFolder ab = this.fJProject.getProject().getFolder("a-b");
        CoreUtility.createFolder((IFolder)ab, (boolean)true, (boolean)true, null);
        IFile description = ab.getFile("description.txt");
        description.create((InputStream)this.asInputStream("description"), true, null);
        IScriptFolder exclInclPackage = root.createScriptFolder("excl/incl", true, null);
        ISourceModule In = exclInclPackage.createSourceModule("In.txt", "package excl.incl;\r\npublic class In {\r\n}\r\n", true, null);
        IFolder excl = this.fJProject.getProject().getFolder("excl");
        IFile Ex = excl.getFile("Ex.txt");
        Ex.create((InputStream)this.asInputStream("package excl;\npublic class Ex{}"), false, null);
        IScriptFolder xPackage = root.createScriptFolder("x", true, null);
        IFolder x = this.fJProject.getProject().getFolder("x");
        IFile xhidden = x.getFile(".hidden");
        xhidden.create((InputStream)this.asInputStream(""), true, null);
        IFile X = x.getFile("X.txt");
        X.create((InputStream)this.asInputStream("package x;\r\npublic class X {\r\n\t\r\n}\r\n"), true, null);
        x.copy((IPath)new Path("y"), true, null);
        IFolder y = this.fJProject.getProject().getFolder("y");
        IFile yX = y.getFile("X.txt");
        IFile yhidden = y.getFile(".hidden");
        IScriptFolder zPackage = root.createScriptFolder("z", true, null);
        ISourceModule Z = zPackage.createSourceModule("Z.txt", "package z;public class Z{}", true, null);
        this.assertEqualElements(new Object[]{defaultPackage, exclInclPackage, xPackage, zPackage, ab, excl, y, this.fDotBuildpath, this.fDotProject}, this.fProvider.getChildren((Object)this.fJProject));
        this.assertEqualElements(new Object[0], this.fProvider.getChildren((Object)defaultPackage));
        this.assertEqualElements(new Object[]{In}, this.fProvider.getChildren((Object)exclInclPackage));
        this.assertEqualElements(new Object[]{Ex}, this.fProvider.getChildren((Object)excl));
        this.assertEqualElements(new Object[]{X, xhidden}, this.fProvider.getChildren((Object)xPackage));
        ContentProviderTests5.assertEquals((Object)xPackage, (Object)this.fProvider.getParent((Object)X));
        ContentProviderTests5.assertEquals((Object)xPackage, (Object)this.fProvider.getParent((Object)xhidden));
        this.assertEqualElements(new Object[]{Z}, this.fProvider.getChildren((Object)zPackage));
        this.assertEqualElements(new Object[]{description}, this.fProvider.getChildren((Object)ab));
        this.assertEqualElements(new Object[]{Ex}, this.fProvider.getChildren((Object)excl));
        this.assertEqualElements(new Object[]{yX, yhidden}, this.fProvider.getChildren((Object)y));
    }

    public void REM_testNestedSource1() throws Exception {
        IPath[] inclusionFilters = new IPath[]{};
        IPath[] exclusionFilters = new IPath[]{new Path("a-b/a/b/")};
        IProjectFragment src = ScriptProjectHelper.addSourceContainer(this.fJProject, "src", inclusionFilters, exclusionFilters);
        IProjectFragment srcabab = ScriptProjectHelper.addSourceContainer(this.fJProject, "src/a-b/a/b", new IPath[0], new IPath[0]);
        IScriptFolder defaultSrc = src.createScriptFolder("", true, null);
        IScriptFolder p = src.createScriptFolder("p", true, null);
        IFile file = ((IFolder)p.getCorrespondingResource()).getFile("file.txt");
        file.create((InputStream)this.asInputStream("f"), true, null);
        IFolder ab = ((IFolder)src.getUnderlyingResource()).getFolder("a-b");
        CoreUtility.createFolder((IFolder)ab, (boolean)true, (boolean)true, null);
        IFolder aba = ab.getFolder("a");
        CoreUtility.createFolder((IFolder)aba, (boolean)true, (boolean)true, null);
        IFile abaTxt = aba.getFile("aba.txt");
        abaTxt.create((InputStream)this.asInputStream("x"), true, null);
        IScriptFolder defaultAbab = srcabab.createScriptFolder("", true, null);
        ISourceModule b = defaultAbab.createSourceModule("B.txt", "public class B {}", true, null);
        this.assertEqualElements(new Object[]{src, srcabab, this.fDotBuildpath, this.fDotProject}, this.fProvider.getChildren((Object)this.fJProject));
        this.assertEqualElements(new Object[]{defaultSrc, p, ab}, this.fProvider.getChildren((Object)src));
        this.assertEqualElements(new Object[0], this.fProvider.getChildren((Object)defaultSrc));
        this.assertEqualElements(new Object[]{file}, this.fProvider.getChildren((Object)p));
        this.assertEqualElements(new Object[]{aba}, this.fProvider.getChildren((Object)ab));
        this.assertEqualElements(new Object[]{abaTxt}, this.fProvider.getChildren((Object)aba));
        this.assertEqualElements(new Object[]{defaultAbab}, this.fProvider.getChildren((Object)srcabab));
        this.assertEqualElements(new Object[]{b}, this.fProvider.getChildren((Object)defaultAbab));
    }

    public void testInclExcl1() throws Exception {
        IPath[] inclusionFilters = new IPath[]{new Path("a/b/c/")};
        IPath[] exclusionFilters = new IPath[]{new Path("a/b/c/d/")};
        IProjectFragment src = ScriptProjectHelper.addSourceContainer(this.fJProject, "src", inclusionFilters, exclusionFilters);
        IScriptFolder abc = src.createScriptFolder("a/b/c", true, null);
        ISourceModule x = abc.createSourceModule("X.txt", "", true, null);
        IFolder d = ((IFolder)abc.getUnderlyingResource()).getFolder("d");
        CoreUtility.createFolder((IFolder)d, (boolean)false, (boolean)true, null);
        IFile dTxt = d.getFile("d.txt");
        dTxt.create((InputStream)this.asInputStream(""), true, null);
        IContainer b = d.getParent().getParent();
        IContainer a = b.getParent();
        this.assertEqualElements(new Object[]{src, this.fDotBuildpath, this.fDotProject}, this.fProvider.getChildren((Object)this.fJProject));
        this.assertEqualElements(new Object[]{abc, a}, this.fProvider.getChildren((Object)src));
        this.assertEqualElements(new Object[]{x, d}, this.fProvider.getChildren((Object)abc));
        this.assertEqualElements(new Object[]{dTxt}, this.fProvider.getChildren((Object)d));
        this.assertEqualElements(new Object[]{b}, this.fProvider.getChildren((Object)a));
    }

    private void assertEqualElements(Object[] expected, Object[] actual) {
        ContentProviderTests5.assertEquals((String)"array length", (int)expected.length, (int)actual.length);
        int i = 0;
        while (i < expected.length) {
            block3: {
                Object e = expected[i];
                int j = 0;
                while (j < actual.length) {
                    Object a = actual[j];
                    if (!e.equals(a)) {
                        ++j;
                        continue;
                    }
                    break block3;
                }
                ContentProviderTests5.fail((String)("expected[" + i + "] not found in actual:" + Arrays.asList(actual).toString()));
            }
            ++i;
        }
    }
}

