/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.tests.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.core.tests.model.SuiteOfTestCases;
import org.eclipse.dltk.ui.tests.text.TestScriptCommentScanner;
import org.eclipse.dltk.ui.tests.text.TokenPos;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class TodoHighlightingTest
extends SuiteOfTestCases {
    private static final String COMMENT_KEY = "SingleLineCommentIdentifier";
    private static final String TODO_KEY = "TodoTagIdentifier";
    private static final String TODO = "TODO";
    private static final String FIXME = "FIXME";
    static /* synthetic */ Class class$0;

    public static SuiteOfTestCases.Suite suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.ui.tests.text.TodoHighlightingTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new SuiteOfTestCases.Suite((Class)clazz);
    }

    public TodoHighlightingTest(String name) {
        super(name);
    }

    private TestScriptCommentScanner createScanner(String[] tags, boolean caseSensitive) {
        return new TestScriptCommentScanner(tags, COMMENT_KEY, TODO_KEY, caseSensitive);
    }

    private IToken evaluateTodoRule(TestScriptCommentScanner scanner) {
        int oldOffset = scanner.getTokenOffset();
        IToken token = scanner.createTodoRule().evaluate((ICharacterScanner)scanner);
        TodoHighlightingTest.assertEquals((int)oldOffset, (int)scanner.getTokenOffset());
        return token;
    }

    protected List findTodoTokens(String data, String[] tags) {
        IToken t;
        TestScriptCommentScanner scanner = this.createScanner(tags, true);
        scanner.setText(data);
        Token todoToken = scanner.getToken(TODO_KEY);
        ArrayList<TokenPos> result = new ArrayList<TokenPos>();
        while (!(t = scanner.nextToken()).isEOF()) {
            if (!t.equals(todoToken)) continue;
            result.add(new TokenPos(scanner.getTokenOffset(), scanner.getTokenLength()));
        }
        return result;
    }

    protected List findTodoTokens(String data, String tag) {
        return this.findTodoTokens(data, new String[]{tag});
    }

    private TokenPos newTokenPos(String data, String tag) {
        return new TokenPos(data.indexOf(tag), tag.length());
    }

    public void testTodoRuleMiss1() {
        TestScriptCommentScanner scanner = this.createScanner(new String[]{TODO, FIXME}, true);
        scanner.setText("x");
        IToken token = this.evaluateTodoRule(scanner);
        TodoHighlightingTest.assertTrue((boolean)token.isUndefined());
        TodoHighlightingTest.assertEquals((int)0, (int)scanner.getTokenLength());
    }

    public void testTodoRuleMiss2() {
        TestScriptCommentScanner scanner = this.createScanner(new String[]{TODO, FIXME}, true);
        scanner.setText("xTODO");
        IToken token = this.evaluateTodoRule(scanner);
        TodoHighlightingTest.assertTrue((boolean)token.isUndefined());
        TodoHighlightingTest.assertEquals((int)0, (int)scanner.getTokenLength());
    }

    public void testTodoRuleMiss3() {
        TestScriptCommentScanner scanner = this.createScanner(new String[]{TODO, FIXME}, true);
        scanner.setText("TODOx");
        IToken token = this.evaluateTodoRule(scanner);
        TodoHighlightingTest.assertTrue((boolean)token.isUndefined());
        TodoHighlightingTest.assertEquals((int)0, (int)scanner.getTokenLength());
    }

    public void testTodoRuleMiss4() {
        TestScriptCommentScanner scanner = this.createScanner(new String[]{TODO, FIXME}, true);
        scanner.setText("FIXMEx");
        IToken token = this.evaluateTodoRule(scanner);
        TodoHighlightingTest.assertTrue((boolean)token.isUndefined());
        TodoHighlightingTest.assertEquals((int)0, (int)scanner.getTokenLength());
    }

    public void testTodoRuleMiss5() {
        TestScriptCommentScanner scanner = this.createScanner(new String[]{TODO, FIXME}, true);
        scanner.setText("xFIXME");
        IToken token = this.evaluateTodoRule(scanner);
        TodoHighlightingTest.assertTrue((boolean)token.isUndefined());
        TodoHighlightingTest.assertEquals((int)0, (int)scanner.getTokenLength());
    }

    public void testTodoRuleMatch1() {
        TestScriptCommentScanner scanner = this.createScanner(new String[]{TODO, FIXME}, true);
        scanner.setText(TODO);
        IToken token = this.evaluateTodoRule(scanner);
        TodoHighlightingTest.assertTrue((boolean)token.isOther());
        TodoHighlightingTest.assertEquals((int)TODO.length(), (int)scanner.getTokenLength());
    }

    public void testTodoRuleMatch2() {
        TestScriptCommentScanner scanner = this.createScanner(new String[]{TODO, FIXME}, true);
        scanner.setText(FIXME);
        IToken token = this.evaluateTodoRule(scanner);
        TodoHighlightingTest.assertTrue((boolean)token.isOther());
        TodoHighlightingTest.assertEquals((int)FIXME.length(), (int)scanner.getTokenLength());
    }

    public void testTodoRuleMatch3() {
        TestScriptCommentScanner scanner = this.createScanner(new String[]{TODO, FIXME}, true);
        scanner.setText("TODO ");
        IToken token = this.evaluateTodoRule(scanner);
        TodoHighlightingTest.assertTrue((boolean)token.isOther());
        TodoHighlightingTest.assertEquals((int)TODO.length(), (int)scanner.getTokenLength());
    }

    public void testTodoRuleMatch4() {
        TestScriptCommentScanner scanner = this.createScanner(new String[]{TODO, FIXME}, true);
        scanner.setText("FIXME ");
        IToken token = this.evaluateTodoRule(scanner);
        TodoHighlightingTest.assertTrue((boolean)token.isOther());
        TodoHighlightingTest.assertEquals((int)FIXME.length(), (int)scanner.getTokenLength());
    }

    public void testBare() {
        List tokens = this.findTodoTokens("#TODO", TODO);
        TodoHighlightingTest.assertEquals((int)1, (int)tokens.size());
        TodoHighlightingTest.assertEquals((Object)this.newTokenPos("#TODO", TODO), tokens.get(0));
    }

    public void testBare1() {
        List tokens = this.findTodoTokens("#TODO", new String[]{TODO, FIXME});
        TodoHighlightingTest.assertEquals((int)1, (int)tokens.size());
        TodoHighlightingTest.assertEquals((Object)this.newTokenPos("#TODO", TODO), tokens.get(0));
    }

    public void testBare2() {
        List tokens = this.findTodoTokens("#FIXME", new String[]{TODO, FIXME});
        TodoHighlightingTest.assertEquals((int)1, (int)tokens.size());
        TodoHighlightingTest.assertEquals((Object)this.newTokenPos("#FIXME", FIXME), tokens.get(0));
    }

    public void testNormal() {
        List tokens = this.findTodoTokens("#TODO comment", TODO);
        TodoHighlightingTest.assertEquals((int)1, (int)tokens.size());
        TodoHighlightingTest.assertEquals((Object)this.newTokenPos("#TODO comment", TODO), tokens.get(0));
    }

    public void testSpaced() {
        List tokens = this.findTodoTokens("#   TODO comment", TODO);
        TodoHighlightingTest.assertEquals((int)1, (int)tokens.size());
        TodoHighlightingTest.assertEquals((Object)this.newTokenPos("#   TODO comment", TODO), tokens.get(0));
    }

    public void testPrefixed() {
        List tokens = this.findTodoTokens("# aTODO comment", TODO);
        TodoHighlightingTest.assertEquals((int)0, (int)tokens.size());
    }

    public void testNoTodo() {
        List tokens = this.findTodoTokens("#hello", TODO);
        TodoHighlightingTest.assertEquals((int)0, (int)tokens.size());
    }

    public void testSuffixed() {
        List tokens = this.findTodoTokens("# TODOa comment", TODO);
        TodoHighlightingTest.assertEquals((int)0, (int)tokens.size());
    }

    public void testLegallySuffixed() {
        List tokens = this.findTodoTokens("# TODO: comment", TODO);
        TodoHighlightingTest.assertEquals((int)1, (int)tokens.size());
        TodoHighlightingTest.assertEquals((Object)this.newTokenPos("# TODO: comment", TODO), tokens.get(0));
    }

    public void testDoubleTagOccurence() throws Exception {
        String data = "# TODO add TODO tag support";
        List tokens = this.findTodoTokens(data, TODO);
        TodoHighlightingTest.assertEquals((int)1, (int)tokens.size());
        TodoHighlightingTest.assertEquals((Object)this.newTokenPos(data, TODO), tokens.get(0));
    }

    public void testDifferentTags() {
        String data = "#FIXME tag support";
        List tokens = this.findTodoTokens(data, new String[]{TODO, FIXME});
        TodoHighlightingTest.assertEquals((int)1, (int)tokens.size());
        TodoHighlightingTest.assertEquals((Object)this.newTokenPos(data, FIXME), tokens.get(0));
    }
}

