/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.tests.launching;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.tests.model.AbstractModelTests;
import org.eclipse.dltk.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.internal.debug.core.model.ScriptDebugTarget;
import org.eclipse.dltk.internal.debug.core.model.ScriptLineBreakpoint;
import org.eclipse.dltk.internal.debug.core.model.ScriptThread;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.launching.InterpreterSearcher;

public abstract class ScriptLaunchingTests
extends AbstractModelTests {
    protected IScriptProject scriptProject;
    protected IInterpreterInstall[] interpreterInstalls;
    public static final int SKIP_STDOUT_TEST = 1;

    public ScriptLaunchingTests(String testProjectName, String name) {
        super(testProjectName, name);
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.scriptProject = this.setUpScriptProject(this.getProjectName());
        IProject project = this.scriptProject.getProject();
        IProjectDescription description = project.getDescription();
        description.setNatureIds(new String[]{this.getNatureId()});
        project.setDescription(description, null);
        this.interpreterInstalls = !this.hasPredefinedInterpreters() ? this.searchInstalls(this.getNatureId()) : this.getPredefinedInterpreterInstalls();
    }

    protected IInterpreterInstall[] getPredefinedInterpreterInstalls() {
        return new IInterpreterInstall[0];
    }

    public void tearDownSuite() throws Exception {
        this.deleteProject(this.getProjectName());
        super.tearDownSuite();
    }

    protected ILaunchConfiguration createTestLaunchConfiguration(final String natureId, final String projectName, final String script, final String arguments) {
        return new ILaunchConfiguration(){

            public boolean contentsEqual(ILaunchConfiguration configuration) {
                return false;
            }

            public ILaunchConfigurationWorkingCopy copy(String name) throws CoreException {
                return null;
            }

            public void delete() throws CoreException {
            }

            public boolean exists() {
                return false;
            }

            public boolean getAttribute(String attributeName, boolean defaultValue) throws CoreException {
                if (attributeName.equals("defaultBuildpath")) {
                    return true;
                }
                if (attributeName.equals(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES)) {
                    return true;
                }
                return defaultValue;
            }

            public int getAttribute(String attributeName, int defaultValue) throws CoreException {
                if (attributeName.equals("dbpg_waiting_timeout")) {
                    return 10000;
                }
                return defaultValue;
            }

            public List getAttribute(String attributeName, List defaultValue) throws CoreException {
                return defaultValue;
            }

            public Set getAttribute(String attributeName, Set defaultValue) throws CoreException {
                return defaultValue;
            }

            public Map getAttribute(String attributeName, Map defaultValue) throws CoreException {
                if (attributeName.equals(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES)) {
                    HashMap env = new HashMap();
                    ScriptLaunchingTests.this.configureEnvironment(env);
                    return env;
                }
                return defaultValue;
            }

            public String getAttribute(String attributeName, String defaultValue) throws CoreException {
                if (attributeName.equals("mainScript")) {
                    return script;
                }
                if (attributeName.equals("project")) {
                    return projectName;
                }
                if (attributeName.equals("workingDir")) {
                    return null;
                }
                if (attributeName.equals("scriptArguments")) {
                    return arguments;
                }
                if (attributeName.equals("interpreterArguments")) {
                    return "";
                }
                if (attributeName.equals("nature")) {
                    return natureId;
                }
                return defaultValue;
            }

            public Map getAttributes() throws CoreException {
                return null;
            }

            public String getCategory() throws CoreException {
                return null;
            }

            public IFile getFile() {
                return ScriptLaunchingTests.this.getFile(String.valueOf(projectName) + '/' + script);
            }

            public IPath getLocation() {
                return null;
            }

            public IResource[] getMappedResources() throws CoreException {
                return null;
            }

            public String getMemento() throws CoreException {
                return null;
            }

            public Set getModes() throws CoreException {
                return null;
            }

            public String getName() {
                return null;
            }

            public ILaunchDelegate getPreferredDelegate(Set modes) throws CoreException {
                return null;
            }

            public ILaunchConfigurationType getType() throws CoreException {
                return null;
            }

            public ILaunchConfigurationWorkingCopy getWorkingCopy() throws CoreException {
                return null;
            }

            public boolean isLocal() {
                return false;
            }

            public boolean isMigrationCandidate() throws CoreException {
                return false;
            }

            public boolean isReadOnly() {
                return false;
            }

            public boolean isWorkingCopy() {
                return false;
            }

            public ILaunch launch(String mode, IProgressMonitor monitor) throws CoreException {
                return null;
            }

            public ILaunch launch(String mode, IProgressMonitor monitor, boolean build) throws CoreException {
                return null;
            }

            public ILaunch launch(String mode, IProgressMonitor monitor, boolean build, boolean register) throws CoreException {
                return null;
            }

            public void migrate() throws CoreException {
            }

            public boolean supportsMode(String mode) throws CoreException {
                return false;
            }

            public Object getAdapter(Class adapter) {
                return null;
            }

            public boolean hasAttribute(String attributeName) throws CoreException {
                return false;
            }
        };
    }

    protected void configureEnvironment(Map env) {
    }

    public IInterpreterInstall[] searchInstalls(String natureId) {
        ArrayList<IInterpreterInstall> installs = new ArrayList<IInterpreterInstall>();
        InterpreterSearcher searcher = new InterpreterSearcher();
        searcher.search(EnvironmentManager.getLocalEnvironment(), natureId, null, 1, null);
        if (searcher.hasResults()) {
            IFileHandle[] files = searcher.getFoundFiles();
            IInterpreterInstallType[] types = searcher.getFoundInstallTypes();
            int i = 0;
            while (i < files.length) {
                IFileHandle file = files[i];
                IInterpreterInstallType type = types[i];
                String installId = String.valueOf(this.getNatureId()) + "_" + Integer.toString(i);
                IInterpreterInstall install = type.findInterpreterInstall(installId);
                if (install == null) {
                    install = type.createInterpreterInstall(installId);
                }
                install.setName(file.toString());
                install.setInstallLocation(file);
                install.setLibraryLocations(null);
                install.setEnvironmentVariables(null);
                installs.add(install);
                ++i;
            }
        }
        return installs.toArray(new IInterpreterInstall[installs.size()]);
    }

    public void internalTestRequiredInterpreterAvailable(String name) {
        ScriptLaunchingTests.assertTrue((String)("Interpreter " + name + " not available"), (boolean)this.isInterpreterAvailable(name));
    }

    private boolean isInterpreterAvailable(String interpreterName) {
        int i = 0;
        while (i < this.interpreterInstalls.length) {
            IFileHandle installLocation = this.interpreterInstalls[i].getInstallLocation();
            if (this.isRequiredInstall(interpreterName, installLocation)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isRequiredInstall(String interpreterName, IFileHandle installLocation) {
        String executableName = installLocation.getName();
        return executableName.startsWith(interpreterName);
    }

    protected void internalTestRun(String name) throws Exception {
        this.internalTestRun(name, 0);
    }

    protected void internalTestRun(String name, int flags) throws Exception {
        if (this.interpreterInstalls.length == 0) {
            ScriptLaunchingTests.fail((String)("No interperters found for nature " + this.getNatureId()));
        }
        int i = 0;
        while (i < this.interpreterInstalls.length) {
            IInterpreterInstall install = this.interpreterInstalls[i];
            if (this.isRequiredInstall(name, install.getInstallLocation())) {
                long time = System.currentTimeMillis();
                String stdoutTest = String.valueOf(Long.toString(time)) + "_stdout";
                String stderrTest = String.valueOf(Long.toString(time)) + "_stderr";
                ILaunchConfiguration configuration = this.createLaunchConfiguration(String.valueOf(stdoutTest) + " " + stderrTest);
                Launch launch = new Launch(configuration, "run", null);
                this.startLaunch((ILaunch)launch, install);
                IProcess[] processes = launch.getProcesses();
                ScriptLaunchingTests.assertEquals((int)1, (int)processes.length);
                IProcess process = processes[0];
                IStreamsProxy proxy = process.getStreamsProxy();
                ScriptLaunchingTests.assertNotNull((Object)proxy);
                IStreamMonitor outputMonitor = proxy.getOutputStreamMonitor();
                ScriptLaunchingTests.assertNotNull((Object)outputMonitor);
                IStreamMonitor errorMonitor = proxy.getErrorStreamMonitor();
                ScriptLaunchingTests.assertNotNull((Object)errorMonitor);
                while (!process.isTerminated()) {
                    Thread.sleep(20L);
                }
                ScriptLaunchingTests.assertTrue((boolean)process.isTerminated());
                int exitValue = process.getExitValue();
                ScriptLaunchingTests.assertEquals((int)0, (int)exitValue);
                if ((flags & 1) == 0) {
                    String output = outputMonitor.getContents();
                    ScriptLaunchingTests.assertEquals((String)stdoutTest, (String)output);
                }
                String error = errorMonitor.getContents();
                ScriptLaunchingTests.assertEquals((String)stderrTest, (String)error);
                return;
            }
            ++i;
        }
        ScriptLaunchingTests.assertTrue((String)("Requied interpreter are't found" + name), (boolean)false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DebugEventStats internalTestDebug(String name) throws Exception {
        IInterpreterInstall install;
        if (this.interpreterInstalls.length == 0) {
            ScriptLaunchingTests.fail((String)("No interperters found for nature " + this.getNatureId()));
        }
        int i = 0;
        while (true) {
            if (i >= this.interpreterInstalls.length) {
                ScriptLaunchingTests.fail((String)("Requied interpreter \"" + name + "\" is not found"));
                return null;
            }
            install = this.interpreterInstalls[i];
            if (this.isRequiredInstall(name, install.getInstallLocation())) break;
            ++i;
        }
        DebugEventStats stats = new DebugEventStats();
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)stats);
        stats.reset();
        Launch launch = new Launch(this.createLaunchConfiguration(""), "debug", null);
        IFile file = launch.getLaunchConfiguration().getFile();
        ScriptLineBreakpoint b = new ScriptLineBreakpoint(this.getDebugModelId(), (IResource)file, file.getLocation(), 1, -1, -1, true);
        try {
            this.startLaunch((ILaunch)launch, install);
            IProcess[] processes = launch.getProcesses();
            ScriptLaunchingTests.assertEquals((int)1, (int)processes.length);
            IProcess process = processes[0];
            while (true) {
                block7: {
                    if (!process.isTerminated()) break block7;
                    ScriptLaunchingTests.assertTrue((boolean)process.isTerminated());
                    int exitValue = process.getExitValue();
                    ScriptLaunchingTests.assertEquals((int)0, (int)exitValue);
                    break;
                }
                Thread.sleep(200L);
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            b.delete();
            throw throwable;
        }
        {
            Object var11_13 = null;
        }
        b.delete();
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)stats);
        return stats;
    }

    protected abstract String getProjectName();

    protected abstract String getNatureId();

    protected abstract String getDebugModelId();

    protected abstract void startLaunch(ILaunch var1, IInterpreterInstall var2) throws CoreException;

    protected abstract ILaunchConfiguration createLaunchConfiguration(String var1);

    protected boolean hasPredefinedInterpreters() {
        return false;
    }

    protected IInterpreterInstall createInstall(String path, String id, IInterpreterInstallType type) {
        IFileHandle file = EnvironmentManager.getLocalEnvironment().getFile((IPath)new Path(path));
        if (!file.exists()) {
            return null;
        }
        IInterpreterInstall install = type.findInterpreterInstall(id);
        if (install == null) {
            install = type.createInterpreterInstall(id);
        }
        install.setName("");
        install.setInstallLocation(file);
        install.setLibraryLocations(null);
        install.setEnvironmentVariables(null);
        return install;
    }

    protected void createAddInstall(List installs, String path, String id, IInterpreterInstallType type) {
        IInterpreterInstall install = this.createInstall(path, id, type);
        if (install != null) {
            installs.add(install);
        }
    }

    public static class DebugEventStats
    implements IDebugEventSetListener {
        private int suspendCount = 0;
        private int resumeCount = 0;
        private int beforeSuspendCount;
        private int beforeResumeCount;
        private int beforeCodeLoaded;
        private int beforeVmStarted;

        public void handleDebugEvents(DebugEvent[] events) {
            int i = 0;
            while (i < events.length) {
                DebugEvent event = events[i];
                int kind = event.getKind();
                switch (kind) {
                    case 1: {
                        ++this.resumeCount;
                        break;
                    }
                    case 2: {
                        ++this.suspendCount;
                        try {
                            Object source = event.getSource();
                            if (source instanceof IScriptStackFrame) {
                                ((IScriptStackFrame)source).resume();
                                break;
                            }
                            if (!(source instanceof IScriptThread)) break;
                            ((IScriptThread)source).resume();
                        }
                        catch (DebugException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 8: {
                        break;
                    }
                    case 16: {
                        break;
                    }
                    case 32: {
                        this.handleExtendedEvent(event);
                    }
                }
                ++i;
            }
        }

        private void handleExtendedEvent(DebugEvent event) {
            int extendedType = event.getDetail();
            switch (extendedType) {
                case 1: {
                    this.handleBeforeVmStarted((InterpreterConfig)event.getSource());
                    break;
                }
                case 2: {
                    this.handleBeforeCodeLoaded((ScriptDebugTarget)event.getSource());
                    break;
                }
                case 4: {
                    this.handleBeforeResume((ScriptThread)event.getSource());
                    break;
                }
                case 3: {
                    this.handleBeforeSuspend((ScriptThread)event.getSource());
                }
            }
        }

        private void handleBeforeSuspend(ScriptThread source) {
            ++this.beforeSuspendCount;
        }

        private void handleBeforeResume(ScriptThread source) {
            ++this.beforeResumeCount;
        }

        private void handleBeforeCodeLoaded(ScriptDebugTarget source) {
            ++this.beforeCodeLoaded;
        }

        private void handleBeforeVmStarted(InterpreterConfig source) {
            ++this.beforeVmStarted;
        }

        public void reset() {
            this.suspendCount = 0;
            this.resumeCount = 0;
            this.beforeSuspendCount = 0;
            this.beforeResumeCount = 0;
            this.beforeCodeLoaded = 0;
            this.beforeVmStarted = 0;
        }

        public int getSuspendCount() {
            return this.suspendCount;
        }

        public int getResumeCount() {
            return this.resumeCount;
        }

        public int getBeforeSuspendCount() {
            return this.beforeSuspendCount;
        }

        public int getBeforeResumeCount() {
            return this.beforeResumeCount;
        }

        public int getBeforeCodeLoaded() {
            return this.beforeCodeLoaded;
        }

        public int getBeforeVmStarted() {
            return this.beforeVmStarted;
        }
    }
}

