/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.tests.utils;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.dltk.utils.TextUtils;

public class TextUtilsTest
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.core.tests.utils.TextUtilsTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public TextUtilsTest(String name) {
        super(name);
    }

    public void testNull() {
        TextUtilsTest.assertNull((Object)TextUtils.splitLines(null));
    }

    public void testEmpty() {
        TextUtilsTest.assertEquals((int)0, (int)TextUtils.splitLines((CharSequence)"").length);
    }

    public void testSingleLine() {
        String[] lines = TextUtils.splitLines((CharSequence)"1");
        TextUtilsTest.assertEquals((int)1, (int)lines.length);
        TextUtilsTest.assertEquals((String)"1", (String)lines[0]);
    }

    public void testMultipleLines() {
        String[] lines = TextUtils.splitLines((CharSequence)"1\n2\n3");
        TextUtilsTest.assertEquals((int)3, (int)lines.length);
        TextUtilsTest.assertEquals((String)"1", (String)lines[0]);
        TextUtilsTest.assertEquals((String)"2", (String)lines[1]);
        TextUtilsTest.assertEquals((String)"3", (String)lines[2]);
        lines = TextUtils.splitLines((CharSequence)"1\n2\n3\n");
        TextUtilsTest.assertEquals((int)3, (int)lines.length);
        TextUtilsTest.assertEquals((String)"1", (String)lines[0]);
        TextUtilsTest.assertEquals((String)"2", (String)lines[1]);
        TextUtilsTest.assertEquals((String)"3", (String)lines[2]);
    }

    public void testWindowsEOL() {
        String[] lines = TextUtils.splitLines((CharSequence)"1\r\n2\r\n3");
        TextUtilsTest.assertEquals((int)3, (int)lines.length);
        TextUtilsTest.assertEquals((String)"1", (String)lines[0]);
        TextUtilsTest.assertEquals((String)"2", (String)lines[1]);
        TextUtilsTest.assertEquals((String)"3", (String)lines[2]);
        lines = TextUtils.splitLines((CharSequence)"1\r\n2\r\n3\r\n");
        TextUtilsTest.assertEquals((int)3, (int)lines.length);
        TextUtilsTest.assertEquals((String)"1", (String)lines[0]);
        TextUtilsTest.assertEquals((String)"2", (String)lines[1]);
        TextUtilsTest.assertEquals((String)"3", (String)lines[2]);
    }

    public void testMacEOL() {
        String[] lines = TextUtils.splitLines((CharSequence)"1\r2\r3");
        TextUtilsTest.assertEquals((int)3, (int)lines.length);
        TextUtilsTest.assertEquals((String)"1", (String)lines[0]);
        TextUtilsTest.assertEquals((String)"2", (String)lines[1]);
        TextUtilsTest.assertEquals((String)"3", (String)lines[2]);
        lines = TextUtils.splitLines((CharSequence)"1\r2\r3\r");
        TextUtilsTest.assertEquals((int)3, (int)lines.length);
        TextUtilsTest.assertEquals((String)"1", (String)lines[0]);
        TextUtilsTest.assertEquals((String)"2", (String)lines[1]);
        TextUtilsTest.assertEquals((String)"3", (String)lines[2]);
    }

    public void testSelectHeadLines1() {
        TextUtilsTest.assertEquals((Object)"123", (Object)TextUtils.selectHeadLines((CharSequence)"123", (int)1));
        TextUtilsTest.assertEquals((Object)"123\n", (Object)TextUtils.selectHeadLines((CharSequence)"123\n", (int)1));
        TextUtilsTest.assertEquals((Object)"123\n", (Object)TextUtils.selectHeadLines((CharSequence)"123\n456", (int)1));
        TextUtilsTest.assertEquals((Object)"123\n", (Object)TextUtils.selectHeadLines((CharSequence)"123\n456\n", (int)1));
    }

    public void testSelectHeadLines2() {
        TextUtilsTest.assertEquals((Object)"123\n456\n", (Object)TextUtils.selectHeadLines((CharSequence)"123\n456\n789", (int)2));
        TextUtilsTest.assertEquals((Object)"123\n456\n789", (Object)TextUtils.selectHeadLines((CharSequence)"123\n456\n789", (int)10));
    }

    public void testSplit1() {
        String[] parts = TextUtils.split((String)"123456", (char)':');
        TextUtilsTest.assertEquals((int)1, (int)parts.length);
        TextUtilsTest.assertEquals((String)"123456", (String)parts[0]);
    }

    public void testSplit2() {
        String[] parts = TextUtils.split((String)"123:456", (char)':');
        TextUtilsTest.assertEquals((int)2, (int)parts.length);
        TextUtilsTest.assertEquals((String)"123", (String)parts[0]);
        TextUtilsTest.assertEquals((String)"456", (String)parts[1]);
    }

    public void testSplitAtBounds() {
        String[] parts = TextUtils.split((String)":123456:", (char)':');
        TextUtilsTest.assertEquals((int)1, (int)parts.length);
        TextUtilsTest.assertEquals((String)"123456", (String)parts[0]);
    }
}

