/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.packages;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IAccessRule;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IInterpreterContainerExtension;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.InterpreterContainerHelper;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.tcl.core.TclCorePreferences;
import org.eclipse.dltk.tcl.core.TclPackagesManager;
import org.eclipse.dltk.tcl.core.packages.TclPackageInfo;
import org.eclipse.emf.common.util.EList;

public class TclPackagesInterpreterContainerExtension
implements IInterpreterContainerExtension {
    private static final IAccessRule[] EMPTY_RULES = new IAccessRule[0];

    public void processEntres(IScriptProject project, List buildpathEntries) {
        IInterpreterInstall install;
        IPath[] locations;
        block15: {
            if (TclCorePreferences.USE_PACKAGE_CONCEPT) {
                return;
            }
            locations = null;
            install = null;
            try {
                install = ScriptRuntime.getInterpreterInstall((IScriptProject)project);
                ArrayList<IPath> locs = new ArrayList<IPath>();
                for (IBuildpathEntry entry : buildpathEntries) {
                    if (entry.getEntryKind() == 1 && entry.isExternal()) {
                        locs.add(entry.getPath());
                    }
                    locations = locs.toArray(new IPath[locs.size()]);
                }
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block15;
                e.printStackTrace();
            }
        }
        if (install != null) {
            HashSet<String> set = new HashSet<String>();
            InterpreterContainerHelper.getInterpreterContainerDependencies((IScriptProject)project, set, set);
            List<TclPackageInfo> infos = TclPackagesManager.getPackageInfos(install, set, true);
            if (infos.size() == 0) {
                return;
            }
            IEnvironment env = EnvironmentManager.getEnvironment((IModelElement)project);
            if (env == null) {
                return;
            }
            HashSet<IPath> allPaths = new HashSet<IPath>();
            for (TclPackageInfo info : infos) {
                EList<String> sources = info.getSources();
                for (String path : sources) {
                    IPath rpath = new Path(path).removeLastSegments(1);
                    IPath fullPath = EnvironmentPathUtils.getFullPath((IEnvironment)env, (IPath)rpath);
                    allPaths.add(fullPath);
                }
            }
            HashSet<IPath> rawEntries = new HashSet<IPath>(allPaths.size());
            for (IPath entryPath : allPaths) {
                if (entryPath.isEmpty() || rawEntries.contains(entryPath)) continue;
                IBuildpathAttribute[] attributes = new IBuildpathAttribute[]{};
                ArrayList<IPath> excluded = new ArrayList<IPath>();
                for (IPath otherPath : allPaths) {
                    IPath pattern;
                    if (otherPath.isEmpty() || !entryPath.isPrefixOf(otherPath) || otherPath.equals((Object)entryPath) || excluded.contains(pattern = otherPath.removeFirstSegments(entryPath.segmentCount()).append("*"))) continue;
                    excluded.add(pattern);
                }
                boolean inInterpreter = false;
                if (locations != null) {
                    int i = 0;
                    while (i < locations.length) {
                        IPath path = locations[i];
                        if (path.isPrefixOf(entryPath)) {
                            inInterpreter = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (inInterpreter) continue;
                buildpathEntries.add(DLTKCore.newLibraryEntry((IPath)entryPath, (IAccessRule[])EMPTY_RULES, (IBuildpathAttribute[])attributes, (IPath[])BuildpathEntry.INCLUDE_ALL, (IPath[])excluded.toArray(new IPath[excluded.size()]), (boolean)false, (boolean)true));
                rawEntries.add(entryPath);
            }
        }
    }
}

