/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.preferences;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.internal.ui.editor.ScriptSourceViewer;
import org.eclipse.dltk.javascript.internal.ui.editor.JavaScriptDocumentSetupParticipant;
import org.eclipse.dltk.javascript.internal.ui.text.JavascriptCodeScanner;
import org.eclipse.dltk.javascript.internal.ui.text.SimpleJavascriptSourceViewerConfiguration;
import org.eclipse.dltk.javascript.ui.scriptcolor.provider.IColorProviderCategoryItem;
import org.eclipse.dltk.javascript.ui.scriptcolor.provider.IScriptColorPreferenceProvider;
import org.eclipse.dltk.javascript.ui.scriptcolor.provider.IScriptColorProvider;
import org.eclipse.dltk.ui.preferences.AbstractScriptEditorColoringConfigurationBlock;
import org.eclipse.dltk.ui.preferences.IPreferenceConfigurationBlock;
import org.eclipse.dltk.ui.preferences.OverlayPreferenceStore;
import org.eclipse.dltk.ui.preferences.PreferencesMessages;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.texteditor.ITextEditor;

public class JavascriptEditorColoringConfigurationBlock
extends AbstractScriptEditorColoringConfigurationBlock
implements IPreferenceConfigurationBlock {
    private static IScriptColorPreferenceProvider[] customColorProvider;
    private static final String PREVIEW_FILE_NAME = "PreviewFile.txt";
    private static final String[][] fSyntaxColorListModel;

    static {
        ArrayList<IScriptColorProvider> providersList = new ArrayList<IScriptColorProvider>();
        IScriptColorProvider[] scriptColorProviders = JavascriptCodeScanner.getScriptColorProviders();
        int i = 0;
        while (i < scriptColorProviders.length) {
            if (scriptColorProviders[i] instanceof IScriptColorPreferenceProvider) {
                IScriptColorProvider colorProvider = scriptColorProviders[i];
                providersList.add(colorProvider);
            }
            ++i;
        }
        customColorProvider = providersList.toArray(new IScriptColorPreferenceProvider[providersList.size()]);
        fSyntaxColorListModel = new String[][]{{PreferencesMessages.DLTKEditorPreferencePage_singleLineComment, "DLTK_single_line_comment", sCommentsCategory}, {PreferencesMessages.DLTKEditorPreferencePage_CommentTaskTags, "DLTK_comment_task_tag", sCommentsCategory}, {"JS Doc", "JS_DOC", sCommentsCategory}, {PreferencesMessages.DLTKEditorPreferencePage_keywords, "DLTK_keyword", sCoreCategory}, {PreferencesMessages.DLTKEditorPreferencePage_strings, "DLTK_string", sCoreCategory}, {PreferencesMessages.DLTKEditorPreferencePage_numbers, "DLTK_number", sCoreCategory}, {PreferencesMessages.DLTKEditorPreferencePage_function_colors, "DLTK_function_definition", sCoreCategory}, {"XML Tag Name", "XML_TAG_NAME", "XML"}, {"XML Attribute Name", "XML_ATTR_NAME", "XML"}, {"XML Comment", "XML_COMMENT_NAME", "XML"}};
    }

    public JavascriptEditorColoringConfigurationBlock(OverlayPreferenceStore store) {
        super((OverlayPreferenceStore)new MultiplyOverlayPreferenceStore(store, customColorProvider));
    }

    protected IContentProvider getColorListContentProvider() {
        return new CustomJSColorListContentProvider();
    }

    private List getCustomCategories() {
        ArrayList<Object> allCategories = new ArrayList<Object>();
        allCategories.add(sCoreCategory);
        allCategories.add(sDocumentationCategory);
        allCategories.add(sCommentsCategory);
        allCategories.add("XML");
        int i = 0;
        while (i < customColorProvider.length) {
            IColorProviderCategoryItem[] categories = customColorProvider[i].getCategories();
            int j = 0;
            while (j < categories.length) {
                IColorProviderCategoryItem category = categories[j];
                allCategories.add(category);
                ++j;
            }
            ++i;
        }
        return allCategories;
    }

    public Object[] getElementsForCategory(String entry) {
        ArrayList<AbstractScriptEditorColoringConfigurationBlock.HighlightingColorListItem> elements = new ArrayList<AbstractScriptEditorColoringConfigurationBlock.HighlightingColorListItem>();
        IColorProviderCategoryItem categoryParent = null;
        categoryParent = this.getIsCategoryParent(entry, this.getCustomCategories());
        if (categoryParent != null) {
            List subChildsList = categoryParent.getCategoryItems();
            ArrayList<String> returnList = new ArrayList<String>();
            int c = 0;
            while (c < subChildsList.size()) {
                Object obj = subChildsList.get(c);
                if (obj instanceof IColorProviderCategoryItem) {
                    IColorProviderCategoryItem hobj = (IColorProviderCategoryItem)obj;
                    if (hobj.getCategoryItems() != null && hobj.getCategoryItems().size() > 0) {
                        returnList.add(hobj.getName());
                    }
                } else if (obj instanceof String) {
                    returnList.add((String)obj);
                } else if (obj instanceof List) {
                    returnList.addAll((List)obj);
                }
                ++c;
            }
            Iterator i = this.fListModel.iterator();
            while (i.hasNext()) {
                AbstractScriptEditorColoringConfigurationBlock.HighlightingColorListItem item = (AbstractScriptEditorColoringConfigurationBlock.HighlightingColorListItem)i.next();
                if (!item.getCategory().equals(entry)) continue;
                returnList.add((String)item);
            }
            return returnList.toArray();
        }
        Iterator i = this.fListModel.iterator();
        while (i.hasNext()) {
            AbstractScriptEditorColoringConfigurationBlock.HighlightingColorListItem item = (AbstractScriptEditorColoringConfigurationBlock.HighlightingColorListItem)i.next();
            if (!item.getCategory().equals(entry)) continue;
            elements.add(item);
        }
        return elements.toArray();
    }

    private IColorProviderCategoryItem getIsCategoryParent(String entry, List categoriesList) {
        if (categoriesList != null && categoriesList.size() > 0) {
            int i = 0;
            while (i < categoriesList.size()) {
                Object obj = categoriesList.get(i);
                if (obj instanceof IColorProviderCategoryItem) {
                    IColorProviderCategoryItem categoryParent = (IColorProviderCategoryItem)obj;
                    if (entry.equals(categoryParent.getName())) {
                        return categoryParent;
                    }
                    if (categoryParent.getCategoryItems() != null && categoryParent.getCategoryItems().size() > 0) {
                        Iterator it = categoryParent.getCategoryItems().iterator();
                        IColorProviderCategoryItem result = null;
                        while (it.hasNext()) {
                            IColorProviderCategoryItem subItem = (IColorProviderCategoryItem)it.next();
                            result = this.getIsCategoryParent(entry, subItem.getCategoryItems());
                            if (result == null) continue;
                            return result;
                        }
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public void performOk() {
        super.performOk();
        this.getPreferenceStore().propagate();
        int i = 0;
        while (i < customColorProvider.length) {
            customColorProvider[i].save();
            ++i;
        }
    }

    public void performDefaults() {
        this.getPreferenceStore().loadDefaults();
        super.performDefaults();
    }

    protected String[][] getSyntaxColorListModel() {
        if (customColorProvider.length > 0) {
            ArrayList<String[]> list = new ArrayList<String[]>();
            int i = 0;
            while (i < fSyntaxColorListModel.length) {
                list.add(fSyntaxColorListModel[i]);
                ++i;
            }
            int k = 0;
            while (k < customColorProvider.length) {
                IColorProviderCategoryItem[] categories = customColorProvider[k].getCategories();
                int p = 0;
                while (p < categories.length) {
                    IColorProviderCategoryItem category = categories[p];
                    this.checkForColorItems(list, category, category.getCategoryItems());
                    ++p;
                }
                ++k;
            }
            String[][] allColors = new String[list.size()][];
            return (String[][])list.toArray((T[])allColors);
        }
        return fSyntaxColorListModel;
    }

    protected void checkForColorItems(List list, IColorProviderCategoryItem category, List categoryItems) {
        if (categoryItems != null && categoryItems.size() > 0) {
            int i = 0;
            while (i < categoryItems.size()) {
                IColorProviderCategoryItem item = (IColorProviderCategoryItem)categoryItems.get(i);
                if (item.getName() != null && item.getColorKey() != null) {
                    list.add(new String[]{item.getName(), item.getColorKey(), category.getName()});
                } else {
                    this.checkForColorItems(list, item, item.getCategoryItems());
                }
                ++i;
            }
        }
    }

    protected ProjectionViewer createPreviewViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles, IPreferenceStore store) {
        return new ScriptSourceViewer(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles, store);
    }

    protected ScriptSourceViewerConfiguration createSimpleSourceViewerConfiguration(IColorManager colorManager, IPreferenceStore preferenceStore, ITextEditor editor, boolean configureFormatter) {
        return new SimpleJavascriptSourceViewerConfiguration(colorManager, preferenceStore, editor, "__javascript_partitioning", configureFormatter);
    }

    protected void setDocumentPartitioning(IDocument document) {
        JavaScriptDocumentSetupParticipant participant = new JavaScriptDocumentSetupParticipant();
        participant.setup(document);
    }

    protected InputStream getPreviewContentReader() {
        return ((Object)((Object)this)).getClass().getResourceAsStream(PREVIEW_FILE_NAME);
    }

    protected class CustomJSColorListContentProvider
    extends AbstractScriptEditorColoringConfigurationBlock.ColorListContentProvider {
        protected CustomJSColorListContentProvider() {
            super((AbstractScriptEditorColoringConfigurationBlock)JavascriptEditorColoringConfigurationBlock.this);
        }

        public Object[] getElements(Object inputElement) {
            ArrayList categories = new ArrayList();
            List cats = JavascriptEditorColoringConfigurationBlock.this.getCustomCategories();
            int a = 0;
            while (a < cats.size()) {
                Object aCat = cats.get(a);
                if (aCat instanceof String) {
                    if (JavascriptEditorColoringConfigurationBlock.this.getElementsForCategory((String)aCat).length > 0) {
                        categories.add(cats.get(a));
                    }
                } else if (aCat instanceof IColorProviderCategoryItem) {
                    IColorProviderCategoryItem hmap = (IColorProviderCategoryItem)aCat;
                    categories.add(hmap.getName());
                }
                ++a;
            }
            return categories.toArray();
        }
    }

    private static class MultiplyOverlayPreferenceStore
    extends OverlayPreferenceStore {
        private final OverlayPreferenceStore defaultStore;
        private final Map customStores;

        public MultiplyOverlayPreferenceStore(OverlayPreferenceStore store, IScriptColorPreferenceProvider[] providers) {
            super(null, null);
            this.defaultStore = store;
            this.customStores = new HashMap();
            int i = 0;
            while (i < providers.length) {
                this.customStores.put(providers[i].getPreferenceKeyPrefix(), new OverlayPreferenceStore(providers[i].getPreferenceStore(), new OverlayPreferenceStore.OverlayKey[0]));
                ++i;
            }
        }

        public void addKeys(OverlayPreferenceStore.OverlayKey[] keys) {
            HashMap map = new HashMap();
            map.put(null, new ArrayList());
            String[] prefixes = this.customStores.keySet().toArray(new String[this.customStores.size()]);
            int j = 0;
            while (j < prefixes.length) {
                map.put(prefixes[j], new ArrayList());
                ++j;
            }
            int i = 0;
            while (i < keys.length) {
                block5: {
                    OverlayPreferenceStore.OverlayKey key = keys[i];
                    int j2 = 0;
                    while (j2 < prefixes.length) {
                        if (key.getKey().startsWith(prefixes[j2])) {
                            ((List)map.get(prefixes[j2])).add(key);
                            break block5;
                        }
                        ++j2;
                    }
                    ((List)map.get(null)).add(key);
                }
                ++i;
            }
            this.defaultStore.addKeys(((List)map.get(null)).toArray(new OverlayPreferenceStore.OverlayKey[0]));
            j = 0;
            while (j < prefixes.length) {
                OverlayPreferenceStore store = (OverlayPreferenceStore)this.customStores.get(prefixes[j]);
                store.addKeys(((List)map.get(prefixes[j])).toArray(new OverlayPreferenceStore.OverlayKey[0]));
                store.load();
                store.start();
                ++j;
            }
        }

        public void addPropertyChangeListener(IPropertyChangeListener listener) {
            this.defaultStore.addPropertyChangeListener(listener);
            Iterator it = this.customStores.values().iterator();
            while (it.hasNext()) {
                ((OverlayPreferenceStore)it.next()).addPropertyChangeListener(listener);
            }
        }

        public boolean contains(String name) {
            IPreferenceStore store = this.getStore(name);
            return store.contains(name);
        }

        public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
            this.defaultStore.firePropertyChangeEvent(name, oldValue, newValue);
            Iterator it = this.customStores.values().iterator();
            while (it.hasNext()) {
                ((OverlayPreferenceStore)it.next()).firePropertyChangeEvent(name, oldValue, newValue);
            }
        }

        public boolean getBoolean(String name) {
            IPreferenceStore store = this.getStore(name);
            return store.getBoolean(name);
        }

        private IPreferenceStore getStore(String name) {
            Iterator it = this.customStores.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!name.startsWith((String)entry.getKey())) continue;
                return (IPreferenceStore)entry.getValue();
            }
            return this.defaultStore;
        }

        public boolean getDefaultBoolean(String name) {
            IPreferenceStore store = this.getStore(name);
            return store.getDefaultBoolean(name);
        }

        public double getDefaultDouble(String name) {
            IPreferenceStore store = this.getStore(name);
            return store.getDefaultDouble(name);
        }

        public float getDefaultFloat(String name) {
            IPreferenceStore store = this.getStore(name);
            return store.getDefaultFloat(name);
        }

        public int getDefaultInt(String name) {
            IPreferenceStore store = this.getStore(name);
            return store.getDefaultInt(name);
        }

        public long getDefaultLong(String name) {
            IPreferenceStore store = this.getStore(name);
            return store.getDefaultLong(name);
        }

        public String getDefaultString(String name) {
            IPreferenceStore store = this.getStore(name);
            return store.getDefaultString(name);
        }

        public double getDouble(String name) {
            IPreferenceStore store = this.getStore(name);
            return store.getDouble(name);
        }

        public float getFloat(String name) {
            IPreferenceStore store = this.getStore(name);
            return store.getFloat(name);
        }

        public int getInt(String name) {
            IPreferenceStore store = this.getStore(name);
            return store.getInt(name);
        }

        public long getLong(String name) {
            IPreferenceStore store = this.getStore(name);
            return store.getLong(name);
        }

        public String getString(String name) {
            IPreferenceStore store = this.getStore(name);
            return store.getString(name);
        }

        public boolean isDefault(String name) {
            IPreferenceStore store = this.getStore(name);
            return store.isDefault(name);
        }

        public void load() {
            this.defaultStore.load();
            Iterator it = this.customStores.values().iterator();
            while (it.hasNext()) {
                ((OverlayPreferenceStore)it.next()).load();
            }
        }

        public void loadDefaults() {
            this.defaultStore.loadDefaults();
            Iterator it = this.customStores.values().iterator();
            while (it.hasNext()) {
                OverlayPreferenceStore overlayPreferenceStore = (OverlayPreferenceStore)it.next();
                overlayPreferenceStore.loadDefaults();
            }
        }

        public boolean needsSaving() {
            boolean b = this.defaultStore.needsSaving();
            if (!b) {
                Iterator it = this.customStores.values().iterator();
                while (it.hasNext()) {
                    b = ((OverlayPreferenceStore)it.next()).needsSaving();
                    if (!b) continue;
                    return b;
                }
            }
            return b;
        }

        public void propagate() {
            this.defaultStore.propagate();
            Iterator it = this.customStores.values().iterator();
            while (it.hasNext()) {
                ((OverlayPreferenceStore)it.next()).propagate();
            }
        }

        public void putValue(String name, String value) {
            IPreferenceStore store = this.getStore(name);
            store.putValue(name, value);
        }

        public void removePropertyChangeListener(IPropertyChangeListener listener) {
            this.defaultStore.removePropertyChangeListener(listener);
            Iterator it = this.customStores.values().iterator();
            while (it.hasNext()) {
                ((OverlayPreferenceStore)it.next()).removePropertyChangeListener(listener);
            }
        }

        public void setDefault(String name, boolean value) {
            IPreferenceStore store = this.getStore(name);
            store.setDefault(name, value);
        }

        public void setDefault(String name, double value) {
            IPreferenceStore store = this.getStore(name);
            store.setDefault(name, value);
        }

        public void setDefault(String name, float value) {
            IPreferenceStore store = this.getStore(name);
            store.setDefault(name, value);
        }

        public void setDefault(String name, int value) {
            IPreferenceStore store = this.getStore(name);
            store.setDefault(name, value);
        }

        public void setDefault(String name, long value) {
            IPreferenceStore store = this.getStore(name);
            store.setDefault(name, value);
        }

        public void setDefault(String name, String value) {
            IPreferenceStore store = this.getStore(name);
            store.setDefault(name, value);
        }

        public void setToDefault(String name) {
            IPreferenceStore store = this.getStore(name);
            store.setToDefault(name);
        }

        public void setValue(String name, boolean value) {
            IPreferenceStore store = this.getStore(name);
            store.setValue(name, value);
        }

        public void setValue(String name, double value) {
            IPreferenceStore store = this.getStore(name);
            store.setValue(name, value);
        }

        public void setValue(String name, float value) {
            IPreferenceStore store = this.getStore(name);
            store.setValue(name, value);
        }

        public void setValue(String name, int value) {
            IPreferenceStore store = this.getStore(name);
            store.setValue(name, value);
        }

        public void setValue(String name, long value) {
            IPreferenceStore store = this.getStore(name);
            store.setValue(name, value);
        }

        public void setValue(String name, String value) {
            IPreferenceStore store = this.getStore(name);
            store.setValue(name, value);
        }

        public void start() {
            this.defaultStore.start();
            Iterator it = this.customStores.values().iterator();
            while (it.hasNext()) {
                ((OverlayPreferenceStore)it.next()).start();
            }
        }

        public void stop() {
            this.defaultStore.stop();
            Iterator it = this.customStores.values().iterator();
            while (it.hasNext()) {
                ((OverlayPreferenceStore)it.next()).stop();
            }
        }

        public String toString() {
            return this.defaultStore.toString();
        }
    }
}

