/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.console.ui;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.dltk.console.ConsoleRequest;
import org.eclipse.dltk.console.IScriptInterpreter;
import org.eclipse.dltk.console.ScriptConsoleServer;
import org.eclipse.dltk.console.ScriptInterpreterManager;
import org.eclipse.dltk.console.ui.IScriptConsoleFactory;
import org.eclipse.dltk.console.ui.ScriptConsole;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.launching.process.IScriptProcess;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;

public class ScriptConsoleManager
implements ILaunchListener {
    private static ScriptConsoleManager instance;
    private IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();

    public static ScriptConsoleManager getInstance() {
        if (instance == null) {
            instance = new ScriptConsoleManager();
        }
        return instance;
    }

    protected ScriptConsoleManager() {
    }

    public ScriptConsole[] getScriptConsoles(String consoleType) {
        ArrayList<IConsole> consoles = new ArrayList<IConsole>();
        IConsole[] consoles2 = this.manager.getConsoles();
        int i = 0;
        while (i < consoles2.length) {
            if (consoles2[i] instanceof ScriptConsole && consoles2[i].getType().equals(consoleType)) {
                consoles.add(consoles2[i]);
            }
            ++i;
        }
        return consoles.toArray(new ScriptConsole[consoles.size()]);
    }

    public ScriptConsole getActiveScriptConsole(String consoleType) {
        IConsoleView view;
        IConsole console;
        IViewPart part;
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (part = page.findView("org.eclipse.ui.console.ConsoleView")) != null && part instanceof IConsoleView && (console = (view = (IConsoleView)part).getConsole()) instanceof ScriptConsole && console.getType().equals(consoleType)) {
            return (ScriptConsole)console;
        }
        return null;
    }

    public void close(ScriptConsole console) {
        console.terminate();
        this.remove(console);
    }

    public void closeAll() {
        IConsole[] consoles = this.manager.getConsoles();
        int i = 0;
        while (i < consoles.length) {
            IConsole console = consoles[i];
            if (console instanceof ScriptConsole) {
                this.close((ScriptConsole)console);
            }
            ++i;
        }
    }

    public void showConsole(ScriptConsole console) {
        this.manager.showConsoleView((IConsole)console);
    }

    public void add(ScriptConsole console) {
        this.manager.addConsoles(new IConsole[]{console});
    }

    public void remove(ScriptConsole console) {
        this.manager.removeConsoles(new IConsole[]{console});
    }

    protected IScriptConsoleFactory findScriptConsoleFactory(String natureId) throws CoreException {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint ep = reg.getExtensionPoint("org.eclipse.dltk.console.ui.scriptConsole");
        IExtension[] extensions = ep.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension ext = extensions[i];
            IConfigurationElement[] ce = ext.getConfigurationElements();
            int j = 0;
            while (j < ce.length) {
                if (natureId.equals(ce[j].getAttribute("natureID"))) {
                    Object obj = ce[j].createExecutableExtension("class");
                    if (obj instanceof IScriptConsoleFactory) {
                        return (IScriptConsoleFactory)obj;
                    }
                    return null;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public void launchAdded(ILaunch launch) {
        this.launchChanged(launch);
    }

    public void launchChanged(final ILaunch launch) {
        block9: {
            try {
                final ILaunchConfiguration configuration = launch.getLaunchConfiguration();
                if (configuration == null) {
                    return;
                }
                boolean useDltk = configuration.getAttribute("use_dltk_interactive_console", false);
                if (!useDltk) {
                    return;
                }
                ScriptConsole console = this.getConsole(launch);
                if (console != null) {
                    IProcess[] processes = launch.getProcesses();
                    int i = 0;
                    while (i < processes.length) {
                        IProcess process = processes[i];
                        if (process instanceof IScriptProcess) {
                            console.connect((IScriptProcess)process);
                        }
                        ++i;
                    }
                    return;
                }
                final String natureId = configuration.getAttribute("nature", null);
                if (natureId == null) {
                    return;
                }
                final String consoleId = configuration.getAttribute("console_id", null);
                final IScriptConsoleFactory factory = this.findScriptConsoleFactory(natureId);
                if (factory == null) {
                    return;
                }
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                    }

                    public void run() throws Exception {
                        IScriptInterpreter interpreter = ScriptInterpreterManager.getInstance().createInterpreter(natureId);
                        ScriptConsoleServer.getInstance().register(consoleId, (ConsoleRequest)interpreter);
                        factory.openConsole(interpreter, configuration.getName(), launch);
                    }
                });
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block9;
                e.printStackTrace();
            }
        }
    }

    private ScriptConsole getConsole(ILaunch launch) {
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] consoles = manager.getConsoles();
        int i = 0;
        while (i < consoles.length) {
            ScriptConsole sc;
            ILaunch consoleLaunch;
            IConsole console = consoles[i];
            if (console instanceof ScriptConsole && (consoleLaunch = (sc = (ScriptConsole)console).getLaunch()) != null && consoleLaunch.equals(launch)) {
                return sc;
            }
            ++i;
        }
        return null;
    }

    public void launchRemoved(ILaunch launch) {
        ScriptConsole console = this.getConsole(launch);
        if (console != null) {
            IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
            manager.removeConsoles(new IConsole[]{console});
        }
    }
}

