/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.parser.printer;

import java.util.List;
import org.eclipse.dltk.tcl.ast.ComplexString;
import org.eclipse.dltk.tcl.ast.Script;
import org.eclipse.dltk.tcl.ast.StringArgument;
import org.eclipse.dltk.tcl.ast.Substitution;
import org.eclipse.dltk.tcl.ast.TclArgument;
import org.eclipse.dltk.tcl.ast.TclArgumentList;
import org.eclipse.dltk.tcl.ast.TclCommand;
import org.eclipse.dltk.tcl.ast.VariableReference;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCodePrinter {
    public static String getArgumentString(TclArgument arg, int pos) {
        StringBuffer buff = new StringBuffer();
        int start = arg.getStart();
        if (start > pos) {
            int i = 0;
            while (i < start - pos) {
                buff.append(" ");
                ++i;
            }
        }
        if (arg instanceof StringArgument) {
            StringArgument argument = (StringArgument)arg;
            String value = argument.getValue();
            buff.append(value);
            return buff.toString();
        }
        if (arg instanceof ComplexString) {
            int npos;
            ComplexString carg = (ComplexString)arg;
            EList<TclArgument> eList = carg.getArguments();
            if (carg.getKind() == 1) {
                buff.append("{");
            } else if (carg.getKind() == 2) {
                buff.append("\"");
            }
            for (TclArgument tclArgument : eList) {
                buff.append(SimpleCodePrinter.getArgumentString(tclArgument, pos + buff.length()));
            }
            int end = arg.getEnd() - 1;
            if (carg.getKind() == 0) {
                ++end;
            }
            if (end > (npos = pos + buff.length())) {
                int i = 0;
                while (i < end - npos) {
                    buff.append(" ");
                    ++i;
                }
            }
            if (carg.getKind() == 1) {
                buff.append("}");
            } else if (carg.getKind() == 2) {
                buff.append("\"");
            }
            return buff.toString();
        }
        if (arg instanceof Script) {
            int npos;
            Script st = (Script)arg;
            EList<TclCommand> eList = st.getCommands();
            buff.append("{");
            boolean added = false;
            for (TclCommand tclArgument : eList) {
                if (!added) {
                    added = true;
                } else {
                    buff.append("\n    ");
                }
                buff.append(SimpleCodePrinter.getCommandString(tclArgument, pos + buff.length()));
            }
            int end = arg.getEnd();
            if (end - 1 > (npos = pos + buff.length())) {
                int i = 0;
                while (i < end - 1 - npos) {
                    buff.append(" ");
                    ++i;
                }
            }
            buff.append("}");
            return buff.toString();
        }
        if (arg instanceof VariableReference) {
            VariableReference variableReference = (VariableReference)arg;
            buff.append("$").append(variableReference.getName());
            if (variableReference.getIndex() != null) {
                buff.append("(").append(SimpleCodePrinter.getArgumentString(variableReference.getIndex(), pos + buff.length())).append(")");
            }
            return buff.toString();
        }
        if (arg instanceof Substitution) {
            int npos;
            Substitution st = (Substitution)arg;
            EList<TclCommand> eList = st.getCommands();
            buff.append("[");
            boolean added = false;
            for (TclCommand tclArgument : eList) {
                if (!added) {
                    added = true;
                } else {
                    buff.append("\n    ");
                }
                buff.append(SimpleCodePrinter.getCommandString(tclArgument, pos + buff.length()));
            }
            int end = arg.getEnd() - 1;
            if (end > (npos = pos + buff.length())) {
                int i = 0;
                while (i < end - npos) {
                    buff.append(" ");
                    ++i;
                }
            }
            buff.append("]");
            return buff.toString();
        }
        if (arg instanceof TclArgumentList) {
            int npos;
            TclArgumentList st = (TclArgumentList)arg;
            EList<TclArgument> eList = st.getArguments();
            if (st.getKind() == 1) {
                buff.append("{");
            } else if (st.getKind() == 2) {
                buff.append("\"");
            }
            for (TclArgument tclArgument : eList) {
                buff.append(SimpleCodePrinter.getArgumentString(tclArgument, pos + buff.length()));
            }
            int end = arg.getEnd() - 1;
            if (st.getKind() == 0) {
                ++end;
            }
            if (end > (npos = pos + buff.length())) {
                int i = 0;
                while (i < end - npos) {
                    buff.append(" ");
                    ++i;
                }
            }
            if (st.getKind() == 1) {
                buff.append("}");
            } else if (st.getKind() == 2) {
                buff.append("\"");
            }
            return buff.toString();
        }
        return "";
    }

    public static String getCommandString(TclCommand command, int pos) {
        StringBuffer buff = new StringBuffer();
        int start = command.getStart();
        if (start > pos) {
            int i = 0;
            while (i < start - pos) {
                buff.append(" ");
                ++i;
            }
        }
        EList<TclArgument> eList = command.getArguments();
        buff.append(SimpleCodePrinter.getArgumentString(command.getName(), start));
        for (TclArgument tclArgument : eList) {
            buff.append(SimpleCodePrinter.getArgumentString(tclArgument, pos + buff.length()));
        }
        return buff.toString();
    }

    public static String getCommandsString(List<TclCommand> commands) {
        StringBuffer buff = new StringBuffer();
        boolean first = false;
        int pos = 0;
        for (TclCommand tclArgument : commands) {
            if (!first) {
                first = true;
            } else {
                buff.append("\n");
            }
            String text = SimpleCodePrinter.getCommandString(tclArgument, pos);
            buff.append(text);
            pos += text.length();
        }
        return buff.toString();
    }
}

