/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.parser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.ast.parser.AbstractSourceParser;
import org.eclipse.dltk.ast.parser.ISourceParser;
import org.eclipse.dltk.ast.parser.ISourceParserExtension;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.RuntimePerformanceMonitor;
import org.eclipse.dltk.core.builder.ISourceLineTracker;
import org.eclipse.dltk.tcl.ast.ComplexString;
import org.eclipse.dltk.tcl.ast.Script;
import org.eclipse.dltk.tcl.ast.StringArgument;
import org.eclipse.dltk.tcl.ast.Substitution;
import org.eclipse.dltk.tcl.ast.TclArgument;
import org.eclipse.dltk.tcl.ast.TclArgumentList;
import org.eclipse.dltk.tcl.ast.TclCodeModel;
import org.eclipse.dltk.tcl.ast.TclCommand;
import org.eclipse.dltk.tcl.ast.TclModule;
import org.eclipse.dltk.tcl.ast.TclModuleDeclaration;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.ast.VariableReference;
import org.eclipse.dltk.tcl.ast.expressions.TclBlockExpression;
import org.eclipse.dltk.tcl.ast.expressions.TclExecuteExpression;
import org.eclipse.dltk.tcl.core.ITclCommandDetector;
import org.eclipse.dltk.tcl.core.ITclCommandDetectorExtension;
import org.eclipse.dltk.tcl.core.ITclCommandProcessor;
import org.eclipse.dltk.tcl.core.ITclParser;
import org.eclipse.dltk.tcl.core.ITclSourceParser;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.core.TclPlugin;
import org.eclipse.dltk.tcl.core.ast.TclAdvancedExecuteExpression;
import org.eclipse.dltk.tcl.internal.parser.ext.CommandManager;
import org.eclipse.dltk.tcl.parser.ITclErrorReporter;
import org.eclipse.dltk.tcl.parser.TclErrorCollector;
import org.eclipse.dltk.tcl.parser.TclParser;
import org.eclipse.dltk.tcl.parser.definitions.DefinitionManager;
import org.eclipse.dltk.tcl.parser.definitions.IScopeProcessor;
import org.eclipse.dltk.tcl.parser.definitions.NamespaceScopeProcessor;
import org.eclipse.dltk.tcl.parser.printer.SimpleCodePrinter;
import org.eclipse.dltk.utils.TextUtils;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewTclSourceParser
extends AbstractSourceParser
implements ITclParser,
ISourceParser,
ISourceParserExtension,
ITclSourceParser {
    private IProblemReporter problemReporter;
    private char[] fileName;
    boolean useProcessors = true;
    private boolean useDetectors = true;
    private TclModuleDeclaration moduleDeclaration;
    private TclModule tclModule;
    private ISourceLineTracker tracker;
    private Set<ASTNode> processedForContentNodes = new HashSet<ASTNode>();
    private NamespaceScopeProcessor coreProcessor = DefinitionManager.getInstance().getCoreProcessor();
    private ITclCommandProcessor localProcessor = new ITclCommandProcessor(){

        public ASTNode process(TclStatement st, ITclParser parser, ASTNode parent) {
            if (parent != null) {
                TclParseUtil.addToDeclaration(parent, (ASTNode)st);
            }
            return st;
        }

        public void setCurrentASTTree(ModuleDeclaration module) {
        }

        public void setDetectedParameter(Object parameter) {
        }
    };
    private ITclCommandDetector[] detectors;
    private int globalOffset;

    public ModuleDeclaration parse(char[] fileName, TclModule tclModule, IProblemReporter reporter) {
        this.processedForContentNodes.clear();
        this.initDetectors();
        this.tclModule = tclModule;
        this.tclModule.getCodeModel();
        this.tracker = NewTclSourceParser.createLineTracker(tclModule);
        this.problemReporter = reporter;
        this.fileName = fileName;
        this.moduleDeclaration = new TclModuleDeclaration(tclModule.getSize());
        this.moduleDeclaration.setTclModule(tclModule);
        this.parse(tclModule, (ASTNode)this.moduleDeclaration);
        return this.moduleDeclaration;
    }

    public static ISourceLineTracker createLineTracker(TclModule tclModule) {
        TclCodeModel model = tclModule.getCodeModel();
        EList list = model.getLineOffsets();
        int[] offsets = new int[list.size()];
        int i = 0;
        while (i < list.size()) {
            offsets[i] = (Integer)list.get(i);
            ++i;
        }
        EList delimeters = model.getDelimeters();
        String[] delimetersAsArray = (String[])delimeters.toArray((Object[])new String[delimeters.size()]);
        return new TextUtils.DefaultSourceLineTracker(tclModule.getSize(), offsets, delimetersAsArray);
    }

    private void initDetectors() {
        if (this.detectors == null) {
            this.detectors = CommandManager.getInstance().getDetectors();
        }
    }

    protected void parse(TclModule module, ASTNode decl) {
        this.processedForContentNodes.clear();
        this.initDetectors();
        EList commands = module.getStatements();
        this.processStatements(decl, (List<TclCommand>)commands);
    }

    private void processStatements(ASTNode decl, List<TclCommand> commands) {
        for (TclCommand command : commands) {
            TclStatement st = this.convertToAST(command);
            if (st == null) continue;
            this.runStatementProcessor(decl, st);
        }
    }

    private void runStatementProcessor(ASTNode decl, TclStatement st) {
        ITclCommandProcessor processor = this.locateProcessor(st, decl);
        if (processor != null) {
            try {
                ASTNode nde = processor.process(st, this, decl);
                if (nde == null) {
                    nde = this.localProcessor.process(st, this, decl);
                }
                if (nde != null && this.useDetectors) {
                    int i = 0;
                    while (i < this.detectors.length) {
                        if (this.detectors[i] != null) {
                            this.detectors[i].processASTNode(nde);
                        }
                        ++i;
                    }
                }
                if (nde != null) {
                    int globalOffset = this.globalOffset;
                    boolean userProcessor = this.useProcessors;
                    boolean useDetectors = this.useDetectors;
                    nde.traverse(new ASTVisitor(){

                        public boolean visit(TypeDeclaration s) throws Exception {
                            if (NewTclSourceParser.this.processedForContentNodes.add(s)) {
                                List stats = s.getStatements();
                                this.processStatements((ASTNode)s, stats);
                            }
                            return true;
                        }

                        private void processStatements(ASTNode s, List stats) {
                            ArrayList statements = new ArrayList(stats);
                            stats.clear();
                            for (ASTNode node : statements) {
                                if (node instanceof TclStatement) {
                                    NewTclSourceParser.this.runStatementProcessor(s, (TclStatement)node);
                                    continue;
                                }
                                stats.add(node);
                            }
                        }

                        public boolean visit(MethodDeclaration s) throws Exception {
                            if (NewTclSourceParser.this.processedForContentNodes.add(s)) {
                                List stats = s.getStatements();
                                this.processStatements((ASTNode)s, stats);
                            }
                            return true;
                        }

                        public boolean visit(Expression s) throws Exception {
                            if (s instanceof Block) {
                                if (NewTclSourceParser.this.processedForContentNodes.add(s)) {
                                    Block bl = (Block)s;
                                    List stats = bl.getStatements();
                                    this.processStatements((ASTNode)bl, stats);
                                }
                                return true;
                            }
                            if (s instanceof TclAdvancedExecuteExpression) {
                                if (NewTclSourceParser.this.processedForContentNodes.add(s)) {
                                    TclAdvancedExecuteExpression ex = (TclAdvancedExecuteExpression)s;
                                    List stats = ex.getStatements();
                                    this.processStatements((ASTNode)ex, stats);
                                }
                            } else {
                                boolean cfr_ignored_0 = s instanceof TclExecuteExpression;
                            }
                            return true;
                        }
                    });
                    this.useDetectors = useDetectors;
                    this.useProcessors = userProcessor;
                    this.globalOffset = globalOffset;
                }
            }
            catch (Exception e) {
                TclPlugin.error(e);
            }
        }
    }

    private TclStatement convertToAST(TclCommand command) {
        ArrayList<ASTNode> expressions = new ArrayList<ASTNode>();
        expressions.add(this.convertToAST(command.getName()));
        for (TclArgument arg : command.getArguments()) {
            expressions.add(this.convertToAST(arg));
        }
        return new TclStatement(expressions);
    }

    private ASTNode convertToAST(TclArgument arg) {
        if (arg instanceof StringArgument) {
            StringArgument argument = (StringArgument)arg;
            String value = argument.getValue();
            return this.stringToAST((TclArgument)argument, value);
        }
        if (arg instanceof ComplexString) {
            ComplexString carg = (ComplexString)arg;
            return this.stringToAST((TclArgument)carg, SimpleCodePrinter.getArgumentString((TclArgument)carg, (int)carg.getStart()));
        }
        if (arg instanceof Script) {
            Script st = (Script)arg;
            EList eList = st.getCommands();
            Block block = new Block(st.getStart(), st.getEnd());
            for (TclCommand tclArgument : eList) {
                TclStatement stat = this.convertToAST(tclArgument);
                block.addStatement((ASTNode)stat);
            }
            return block;
        }
        if (arg instanceof VariableReference) {
            VariableReference variableReference = (VariableReference)arg;
            String content = SimpleCodePrinter.getArgumentString((TclArgument)variableReference, (int)variableReference.getStart());
            return new SimpleReference(arg.getStart(), arg.getEnd(), content);
        }
        if (arg instanceof Substitution) {
            Substitution st = (Substitution)arg;
            EList eList = st.getCommands();
            TclAdvancedExecuteExpression block = new TclAdvancedExecuteExpression(st.getStart(), st.getEnd());
            for (TclCommand cmd : eList) {
                TclStatement stat = this.convertToAST(cmd);
                block.addStatement((ASTNode)stat);
            }
            return block;
        }
        if (arg instanceof TclArgumentList) {
            TclArgumentList st = (TclArgumentList)arg;
            String str = SimpleCodePrinter.getArgumentString((TclArgument)st, (int)st.getStart());
            return this.stringToAST((TclArgument)st, str);
        }
        throw new RuntimeException("TODO: Not all cases are matched in TCL Parser AST converter");
    }

    private ASTNode stringToAST(TclArgument argument, String value) {
        int slen = value.length();
        int end = argument.getEnd();
        int start = argument.getStart();
        if (slen >= 2 && value.charAt(0) == '{' && (value.charAt(slen - 1) == '}' || this.moduleDeclaration != null && end == this.moduleDeclaration.sourceEnd())) {
            TclBlockExpression bl = new TclBlockExpression(start, end, value);
            bl.setProcessedArgument(argument);
            return bl;
        }
        if (slen >= 2 && value.charAt(0) == '\"' && (value.charAt(slen - 1) == '\"' || end == this.moduleDeclaration.sourceEnd())) {
            return new StringLiteral(start, end, value);
        }
        int len = end - start;
        if (value.length() > len) {
            value = value.substring(0, len);
        }
        return new SimpleReference(start, end, value);
    }

    private ITclCommandProcessor locateProcessor(TclStatement command, ASTNode decl) {
        if (!this.useProcessors) {
            return this.localProcessor;
        }
        if (command != null && command.getCount() > 0) {
            ITclCommandProcessor processor;
            Expression expr = command.getAt(0);
            if (!(expr instanceof SimpleReference)) {
                return this.localProcessor;
            }
            String name = ((SimpleReference)expr).getName();
            if (name.startsWith("::")) {
                name = name.substring(2);
            }
            if ((processor = CommandManager.getInstance().getProcessor(name)) == null && this.useDetectors) {
                int i = 0;
                while (i < this.detectors.length) {
                    if (this.detectors[i] != null) {
                        ITclCommandDetector.CommandInfo commandName;
                        if (this.detectors[i] instanceof ITclCommandDetectorExtension) {
                            ((ITclCommandDetectorExtension)((Object)this.detectors[i])).setBuildRuntimeModelFlag(false);
                        }
                        if ((commandName = this.detectors[i].detectCommand(command, this.moduleDeclaration, decl)) != null) {
                            processor = CommandManager.getInstance().getProcessor(commandName.commandName);
                            if (processor == null) break;
                            processor.setDetectedParameter(commandName.parameter);
                            break;
                        }
                    }
                    ++i;
                }
            }
            if (processor != null) {
                processor.setCurrentASTTree(this.moduleDeclaration);
                return processor;
            }
        }
        return this.localProcessor;
    }

    @Override
    public IProblemReporter getProblemReporter() {
        return this.problemReporter;
    }

    @Override
    public char[] getFileName() {
        return this.fileName;
    }

    @Override
    public int getStartPos() {
        return 0;
    }

    @Override
    public void setProcessorsState(boolean state) {
        this.useProcessors = state;
    }

    public void setUseDetectors(boolean b) {
        this.useDetectors = false;
    }

    @Override
    public ISourceLineTracker getCodeModel() {
        return this.tracker;
    }

    @Override
    public void parse(String content, int offset, ASTNode parent) {
        RuntimePerformanceMonitor.PerformanceNode p = RuntimePerformanceMonitor.begin();
        this.initDetectors();
        this.processedForContentNodes.clear();
        TclParser newParser = new TclParser();
        TclErrorCollector collector = null;
        if (this.problemReporter != null) {
            collector = new TclErrorCollector();
        }
        newParser.setGlobalOffset(offset);
        List module = newParser.parse(new String(content), (ITclErrorReporter)collector, (IScopeProcessor)this.coreProcessor);
        if (this.problemReporter != null) {
            collector.reportAll(this.problemReporter, this.tracker);
        }
        this.processStatements(parent, module);
        p.done("org.eclipse.dltk.tcl.core.nature", "New tcl parser: Parse of code", (long)content.length());
    }

    public ModuleDeclaration parse(char[] fileName, char[] source, IProblemReporter reporter) {
        RuntimePerformanceMonitor.PerformanceNode node = RuntimePerformanceMonitor.begin();
        this.processedForContentNodes.clear();
        this.problemReporter = reporter;
        TclParser newParser = new TclParser();
        TclErrorCollector collector = null;
        if (reporter != null) {
            collector = new TclErrorCollector();
        }
        newParser.setGlobalOffset(this.globalOffset);
        TclModule module = newParser.parseModule(new String(source), (ITclErrorReporter)collector, (IScopeProcessor)this.coreProcessor);
        ModuleDeclaration result = this.parse(fileName, module, reporter);
        if (collector != null) {
            collector.reportAll(reporter, this.tracker);
        }
        node.done("org.eclipse.dltk.tcl.core.nature", "new tcl source parser:time", (long)source.length);
        return result;
    }

    public void setFlags(int flags) {
    }

    @Override
    public void setOffset(int offset) {
        this.globalOffset = offset;
    }

    public void parse(Script script, Block bll) {
        RuntimePerformanceMonitor.PerformanceNode p = RuntimePerformanceMonitor.begin();
        this.processedForContentNodes.clear();
        this.processStatements((ASTNode)bll, (List<TclCommand>)script.getCommands());
        p.done("org.eclipse.dltk.tcl.core.nature", "New tcl parser: Parse of block", 0L);
    }
}

