/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.formatter.profile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.formatter.profile.CustomProfile;
import org.eclipse.dltk.ui.formatter.IProfile;
import org.eclipse.dltk.ui.formatter.IProfileManager;
import org.eclipse.dltk.ui.formatter.ProfileKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileManager
implements IProfileManager {
    private final Map<String, IProfile> fProfiles = new HashMap<String, IProfile>();
    private final List<IProfile> fProfilesByName = new ArrayList<IProfile>();
    private IProfile fSelected;
    private boolean fDirty = false;

    public ProfileManager(List<IProfile> profiles) {
        for (IProfile profile : profiles) {
            this.fProfiles.put(profile.getID(), profile);
            this.fProfilesByName.add(profile);
        }
        Collections.sort(this.fProfilesByName);
        if (!this.fProfilesByName.isEmpty()) {
            this.fSelected = this.fProfilesByName.get(0);
        }
    }

    public List<IProfile> getSortedProfiles() {
        return Collections.unmodifiableList(this.fProfilesByName);
    }

    public String[] getSortedDisplayNames() {
        String[] sortedNames = new String[this.fProfilesByName.size()];
        int i = 0;
        for (IProfile curr : this.fProfilesByName) {
            sortedNames[i++] = curr.getName();
        }
        return sortedNames;
    }

    public IProfile getProfile(String ID) {
        return this.fProfiles.get(ID);
    }

    public IProfile getSelected() {
        return this.fSelected;
    }

    public void setSelected(IProfile profile) {
        IProfile newSelected = this.fProfiles.get(profile.getID());
        if (newSelected != null && !newSelected.equals(this.fSelected)) {
            this.fSelected = newSelected;
        }
    }

    public boolean containsName(String name) {
        for (IProfile curr : this.fProfilesByName) {
            if (!name.equals(curr.getName())) continue;
            return true;
        }
        return false;
    }

    public IProfile findProfile(String profileId) {
        return this.fProfiles.get(profileId);
    }

    public void addProfile(IProfile profile) {
        if (profile instanceof CustomProfile) {
            CustomProfile newProfile = (CustomProfile)profile;
            CustomProfile oldProfile = (CustomProfile)this.fProfiles.get(profile.getID());
            if (oldProfile != null) {
                this.fProfiles.remove(oldProfile.getID());
                this.fProfilesByName.remove(oldProfile);
            }
            this.fProfiles.put(profile.getID(), profile);
            this.fProfilesByName.add(profile);
            Collections.sort(this.fProfilesByName);
            this.fSelected = newProfile;
            this.fDirty = true;
        }
    }

    public boolean deleteProfile(IProfile profile) {
        if (profile instanceof CustomProfile) {
            CustomProfile oldProfile = (CustomProfile)profile;
            int index = this.fProfilesByName.indexOf(profile);
            this.fProfiles.remove(oldProfile.getID());
            this.fProfilesByName.remove(oldProfile);
            if (index >= this.fProfilesByName.size()) {
                --index;
            }
            this.fSelected = this.fProfilesByName.get(index);
            this.fDirty = true;
            return true;
        }
        return false;
    }

    public IProfile rename(IProfile profile, String newName) {
        String trimmed = newName.trim();
        if (trimmed.equals(profile.getName())) {
            return profile;
        }
        if (profile.isBuiltInProfile()) {
            CustomProfile newProfile = new CustomProfile(trimmed, profile.getSettings(), profile.getFormatterId(), profile.getVersion());
            this.addProfile(newProfile);
            this.fDirty = true;
            return newProfile;
        }
        CustomProfile cProfile = (CustomProfile)profile;
        String oldID = profile.getID();
        cProfile.fName = trimmed;
        this.fProfiles.remove(oldID);
        this.fProfiles.put(profile.getID(), profile);
        Collections.sort(this.fProfilesByName);
        this.fDirty = true;
        return cProfile;
    }

    public void profileReplaced(CustomProfile oldProfile, CustomProfile newProfile) {
        this.fProfiles.remove(oldProfile.getID());
        this.fProfiles.put(newProfile.getID(), newProfile);
        this.fProfilesByName.remove(oldProfile);
        this.fProfilesByName.add(newProfile);
        Collections.sort(this.fProfilesByName);
        this.setSelected(newProfile);
    }

    public IProfile create(ProfileKind kind, String profileName, Map<String, String> settings, String formatterId, int version) {
        CustomProfile profile = new CustomProfile(profileName, settings, formatterId, version);
        if (kind != ProfileKind.TEMPORARY) {
            this.addProfile(profile);
        }
        return profile;
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    public void markDirty() {
        this.fDirty = true;
    }

    public void clearDirty() {
        this.fDirty = false;
    }
}

