/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.compiler.task;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.Literal;
import org.eclipse.dltk.compiler.task.ITodoTaskPreferences;
import org.eclipse.dltk.compiler.task.TodoTaskRangeParser;
import org.eclipse.dltk.core.DLTKCore;

public class TodoTaskAstParser
extends TodoTaskRangeParser {
    public TodoTaskAstParser(ITodoTaskPreferences preferences) {
        super(preferences);
    }

    public void initialize(ModuleDeclaration ast) {
        this.reset();
        if (ast != null) {
            this.setCheckRanges(true);
            ASTVisitor visitor = new ASTVisitor(){

                public boolean visitGeneral(ASTNode node) throws Exception {
                    if (TodoTaskAstParser.this.isSimpleNode(node)) {
                        TodoTaskAstParser.this.excludeRange(node.sourceStart(), node.sourceEnd());
                    }
                    return true;
                }
            };
            try {
                ast.traverse(visitor);
            }
            catch (Exception e) {
                DLTKCore.error("Unexpected error", e);
            }
        } else {
            this.setCheckRanges(false);
        }
    }

    protected boolean isSimpleNode(ASTNode node) {
        return node instanceof Literal;
    }
}

