/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring.changes;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.refactoring.AbstractModelElementRenameChange;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.internal.corext.refactoring.util.ModelElementUtil;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class RenameScriptFolderChange
extends AbstractModelElementRenameChange {
    private Map fSourceModuleStamps;
    private final boolean fRenameSubpackages;

    public RenameScriptFolderChange(RefactoringDescriptor descriptor, IScriptFolder pack, String newName, String comment, boolean renameSubpackages) {
        this(descriptor, pack.getPath(), pack.getElementName(), newName, comment, -1L, null, renameSubpackages);
        Assert.isTrue((!pack.isReadOnly() ? 1 : 0) != 0, (String)"package must not be read only");
    }

    private RenameScriptFolderChange(RefactoringDescriptor descriptor, IPath resourcePath, String oldName, String newName, String comment, long stampToRestore, Map compilationUnitStamps, boolean renameSubpackages) {
        super(descriptor, resourcePath, oldName, newName, comment, stampToRestore);
        this.fSourceModuleStamps = compilationUnitStamps;
        this.fRenameSubpackages = renameSubpackages;
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        IModelElement element = (IModelElement)this.getModifiedElement();
        result.merge(this.isValid(2));
        if (result.hasFatalError()) {
            return result;
        }
        if (element != null && element.exists() && element instanceof IScriptFolder) {
            IScriptFolder pack = (IScriptFolder)element;
            if (this.fRenameSubpackages) {
                IScriptFolder[] allPackages = ModelElementUtil.getPackageAndSubpackages(pack);
                pm.beginTask("", allPackages.length);
                int i = 0;
                while (i < allPackages.length) {
                    RenameScriptFolderChange.checkIfModifiable(result, allPackages[i], 2);
                    if (result.hasFatalError()) {
                        return result;
                    }
                    this.isValid(result, allPackages[i], (IProgressMonitor)new SubProgressMonitor(pm, 1));
                    ++i;
                }
                pm.done();
            } else {
                this.isValid(result, pack, pm);
            }
        }
        return result;
    }

    private void isValid(RefactoringStatus result, IScriptFolder pack, IProgressMonitor pm) throws ModelException {
        ISourceModule[] units = pack.getSourceModules();
        pm.beginTask("", units.length);
        int i = 0;
        while (i < units.length) {
            pm.subTask(Messages.format(RefactoringCoreMessages.RenamePackageChange_checking_change, pack.getElementName()));
            RenameScriptFolderChange.checkIfModifiable(result, units[i], 3);
            pm.worked(1);
            ++i;
        }
        pm.done();
    }

    protected IPath createNewPath() {
        IScriptFolder oldPackage = this.getPackage();
        IPath oldPackageName = RenameScriptFolderChange.createPath(oldPackage.getElementName());
        IPath newPackageName = RenameScriptFolderChange.createPath(this.getNewName());
        return this.getResourcePath().removeLastSegments(oldPackageName.segmentCount()).append(newPackageName);
    }

    private static IPath createPath(String packageName) {
        return new Path(packageName.replace('.', '/'));
    }

    protected IPath createNewPath(IScriptFolder oldPackage) {
        IPath oldPackagePath = RenameScriptFolderChange.createPath(oldPackage.getElementName());
        IPath newPackagePath = RenameScriptFolderChange.createPath(this.getNewName(oldPackage));
        return oldPackage.getPath().removeLastSegments(oldPackagePath.segmentCount()).append(newPackagePath);
    }

    private String getNewName(IScriptFolder subpackage) {
        return String.valueOf(this.getNewName()) + subpackage.getElementName().substring(this.getOldName().length());
    }

    public String getName() {
        String msg = this.fRenameSubpackages ? RefactoringCoreMessages.RenamePackageChange_name_with_subpackages : RefactoringCoreMessages.RenamePackageChange_name;
        return Messages.format(msg, new String[]{this.getOldName(), this.getNewName()});
    }

    protected Change createUndoChange(long stampToRestore) throws CoreException {
        IScriptFolder pack = this.getPackage();
        if (pack == null) {
            return new NullChange();
        }
        HashMap stamps = new HashMap();
        if (!this.fRenameSubpackages) {
            this.addStamps(stamps, pack.getSourceModules());
        } else {
            IScriptFolder[] allPackages = ModelElementUtil.getPackageAndSubpackages(pack);
            int i = 0;
            while (i < allPackages.length) {
                IScriptFolder currentPackage = allPackages[i];
                this.addStamps(stamps, currentPackage.getSourceModules());
                ++i;
            }
        }
        return new RenameScriptFolderChange(null, this.createNewPath(), this.getNewName(), this.getOldName(), this.getComment(), stampToRestore, stamps, this.fRenameSubpackages);
    }

    private void addStamps(Map stamps, ISourceModule[] units) {
        int i = 0;
        while (i < units.length) {
            IResource resource = units[i].getResource();
            long stamp = -1L;
            if (resource != null && (stamp = resource.getModificationStamp()) != -1L) {
                stamps.put(resource, new Long(stamp));
            }
            ++i;
        }
    }

    protected void doRename(IProgressMonitor pm) throws CoreException {
        IScriptFolder pack = this.getPackage();
        if (pack == null) {
            return;
        }
        if (!this.fRenameSubpackages) {
            this.renamePackage(pack, pm, this.createNewPath(), this.getNewName());
        } else {
            IScriptFolder[] allPackages = ModelElementUtil.getPackageAndSubpackages(pack);
            pm.beginTask("", allPackages.length);
            try {
                int i = 0;
                while (i < allPackages.length) {
                    IScriptFolder currentPackage = allPackages[i];
                    this.renamePackage(currentPackage, (IProgressMonitor)new SubProgressMonitor(pm, 1), this.createNewPath(currentPackage), this.getNewName(currentPackage));
                    ++i;
                }
            }
            finally {
                pm.done();
            }
        }
    }

    private void renamePackage(IScriptFolder pack, IProgressMonitor pm, IPath newPath, String newName) throws ModelException, CoreException {
        IScriptFolder newPack;
        pack.rename(newName, false, pm);
        if (this.fSourceModuleStamps != null && (newPack = (IScriptFolder)DLTKCore.create((IResource)ResourcesPlugin.getWorkspace().getRoot().getFolder(newPath))).exists()) {
            ISourceModule[] units = newPack.getSourceModules();
            int i = 0;
            while (i < units.length) {
                Long stamp;
                IResource resource = units[i].getResource();
                if (resource != null && (stamp = (Long)this.fSourceModuleStamps.get(resource)) != null) {
                    resource.revertModificationStamp(stamp.longValue());
                }
                ++i;
            }
        }
    }

    private IScriptFolder getPackage() {
        return (IScriptFolder)this.getModifiedElement();
    }
}

