/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text.completion;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.javascript.reference.resolvers.SelfCompletingReference;
import org.eclipse.dltk.internal.javascript.typeinference.IReference;
import org.eclipse.dltk.javascript.internal.ui.text.completion.JavaScriptCompletionProposal;
import org.eclipse.dltk.javascript.internal.ui.text.completion.JavaScriptCompletionProposalLabelProvider;
import org.eclipse.dltk.javascript.internal.ui.text.completion.JavaScriptOverrideCompletionProposal;
import org.eclipse.dltk.javascript.scriptdoc.ScriptDocumentationProvider;
import org.eclipse.dltk.ui.text.completion.AbstractScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.CompletionProposalLabelProvider;
import org.eclipse.dltk.ui.text.completion.IScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.ProposalInfo;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProposalCollector;
import org.eclipse.dltk.ui.text.completion.ScriptContentAssistInvocationContext;
import org.eclipse.swt.graphics.Image;

public class JavaScriptCompletionProposalCollector
extends ScriptCompletionProposalCollector {
    protected static final char[] VAR_TRIGGER = new char[]{'\t', ' ', '=', ';', '.'};
    private final HashSet doubleFilter = new HashSet();

    protected char[] getVarTrigger() {
        return VAR_TRIGGER;
    }

    public JavaScriptCompletionProposalCollector(ISourceModule module) {
        super(module);
    }

    protected CompletionProposalLabelProvider createLabelProvider() {
        return new JavaScriptCompletionProposalLabelProvider();
    }

    protected ScriptContentAssistInvocationContext createScriptContentAssistInvocationContext(ISourceModule sourceModule) {
        return new ScriptContentAssistInvocationContext(sourceModule){

            protected CompletionProposalLabelProvider createLabelProvider() {
                return new JavaScriptCompletionProposalLabelProvider();
            }
        };
    }

    public void beginReporting() {
        super.beginReporting();
        this.doubleFilter.clear();
    }

    protected boolean isFiltered(CompletionProposal proposal) {
        if (!this.doubleFilter.add(new String(proposal.getName()))) {
            return true;
        }
        return super.isFiltered(proposal);
    }

    protected IScriptCompletionProposal createScriptCompletionProposal(CompletionProposal proposal) {
        IScriptCompletionProposal createScriptCompletionProposal2 = super.createScriptCompletionProposal(proposal);
        AbstractScriptCompletionProposal createScriptCompletionProposal = (AbstractScriptCompletionProposal)createScriptCompletionProposal2;
        final Object ref = proposal.extraInfo;
        ProposalInfo proposalInfo = new ProposalInfo(null){

            public String getInfo(IProgressMonitor monitor) {
                if (ref instanceof SelfCompletingReference && ((SelfCompletingReference)ref).getProposalInfo() != null) {
                    return ((SelfCompletingReference)ref).getProposalInfo();
                }
                if (ref instanceof IReference) {
                    Reader contentReader;
                    ArrayList ms = new ArrayList();
                    ((IReference)ref).addModelElements(ms);
                    if (ms.size() > 0 && (contentReader = new ScriptDocumentationProvider().getInfo((IMember)ms.get(0), true, true)) != null) {
                        String string = this.getString(contentReader);
                        return string;
                    }
                } else if (ref instanceof IMember) {
                    Reader contentReader = new ScriptDocumentationProvider().getInfo((IMember)ref, true, true);
                    if (contentReader != null) {
                        String string = this.getString(contentReader);
                        return string;
                    }
                } else if (ref instanceof String) {
                    return (String)ref;
                }
                return "Documentation not resolved";
            }

            private String getString(Reader reader) {
                StringBuffer buf = new StringBuffer();
                char[] buffer = new char[1024];
                try {
                    int count;
                    while ((count = reader.read(buffer)) != -1) {
                        buf.append(buffer, 0, count);
                    }
                }
                catch (IOException iOException) {
                    return null;
                }
                return buf.toString();
            }
        };
        createScriptCompletionProposal.setProposalInfo(proposalInfo);
        return createScriptCompletionProposal;
    }

    protected ScriptCompletionProposal createScriptCompletionProposal(String completion, int replaceStart, int length, Image image, String displayString, int i) {
        JavaScriptCompletionProposal javaScriptCompletionProposal = new JavaScriptCompletionProposal(completion, replaceStart, length, image, displayString, i);
        return javaScriptCompletionProposal;
    }

    protected ScriptCompletionProposal createScriptCompletionProposal(String completion, int replaceStart, int length, Image image, String displayString, int i, boolean isInDoc) {
        JavaScriptCompletionProposal javaScriptCompletionProposal = new JavaScriptCompletionProposal(completion, replaceStart, length, image, displayString, i, isInDoc);
        return javaScriptCompletionProposal;
    }

    protected ScriptCompletionProposal createOverrideCompletionProposal(IScriptProject scriptProject, ISourceModule compilationUnit, String name, String[] paramTypes, int start, int length, String displayName, String completionProposal) {
        return new JavaScriptOverrideCompletionProposal(scriptProject, compilationUnit, name, paramTypes, start, length, displayName, completionProposal);
    }

    protected IScriptCompletionProposal createKeywordProposal(CompletionProposal proposal) {
        String completion = String.valueOf(proposal.getCompletion());
        int start = proposal.getReplaceStart();
        int length = this.getLength(proposal);
        String label = this.getLabelProvider().createSimpleLabel(proposal);
        Image img = this.getImage(this.getLabelProvider().createMethodImageDescriptor(proposal));
        int relevance = this.computeRelevance(proposal);
        return this.createScriptCompletionProposal(completion, start, length, img, label, relevance);
    }
}

