/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.launching;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.console.ScriptConsoleServer;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.environment.IDeployment;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.internal.launching.execution.DeploymentManager;
import org.eclipse.dltk.launching.AbstractInterpreterRunner;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.tcl.launching.TclLaunchingPlugin;

public class TclInterpreterRunner
extends AbstractInterpreterRunner {
    public TclInterpreterRunner(IInterpreterInstall install) {
        super(install);
    }

    protected String getProcessType() {
        return "tclInterpreter";
    }

    protected void alterConfig(ILaunch launch, InterpreterConfig config) {
        block11: {
            super.alterConfig(launch, config);
            ILaunchConfiguration configuration = launch.getLaunchConfiguration();
            if (configuration != null) {
                boolean useTclConsole;
                block10: {
                    useTclConsole = false;
                    try {
                        useTclConsole = configuration.getAttribute("use_dltk_interactive_console", false);
                    }
                    catch (CoreException e) {
                        if (!DLTKCore.DEBUG) break block10;
                        e.printStackTrace();
                    }
                }
                if (useTclConsole) {
                    ScriptConsoleServer server = ScriptConsoleServer.getInstance();
                    String port = Integer.toString(server.getPort());
                    try {
                        IExecutionEnvironment executionEnvironment = config.getExecutionEnvironment();
                        IDeployment deployment = executionEnvironment.createDeployment();
                        DeploymentManager.getInstance().addDeployment(launch, deployment);
                        IPath path = deployment.add(TclLaunchingPlugin.getDefault().getBundle(), TclLaunchingPlugin.getDefault().getConsoleProxy());
                        IFileHandle scriptFile = deployment.getFile(path);
                        String id = configuration.getAttribute("console_id", null);
                        config.addInterpreterArg(scriptFile.toOSString());
                        config.addInterpreterArg(DLTKDebugPlugin.getDefault().getBindAddress());
                        IPath scriptFilePath = config.getScriptFilePath();
                        if (scriptFilePath == null) {
                            config.setScriptFile((IPath)new Path("--noscript"));
                            config.setNoFile(true);
                        }
                        config.addInterpreterArg(port);
                        if (id == null) {
                            throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.tcl.launching", "Error to obtain console ID. Please update launch configuratin."));
                        }
                        config.addInterpreterArg(id);
                    }
                    catch (IOException e) {
                        if (DLTKCore.DEBUG) {
                            e.printStackTrace();
                        }
                    }
                    catch (CoreException e) {
                        if (!DLTKCore.DEBUG) break block11;
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

