/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.mixin;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.mixin.IMixinRequestor;

public class MixinSourceElementRequestor
implements ISourceElementRequestor {
    private List<String> path = new ArrayList<String>();
    private IMixinRequestor requestor;
    private boolean signature = false;
    private ISourceModule module;

    public MixinSourceElementRequestor(IMixinRequestor requestor, boolean signature, ISourceModule module) {
        this.requestor = requestor;
        this.signature = signature;
        this.module = module;
    }

    protected void enterElement(String path) {
        this.path.add(path);
    }

    private IModelElement getElement(IModelElement parent, int index) {
        if (this.path.size() == index) {
            return parent;
        }
        if (parent instanceof IParent) {
            IParent par = (IParent)((Object)parent);
            IModelElement[] children = null;
            try {
                children = par.getChildren();
            }
            catch (ModelException e) {
                e.printStackTrace();
                throw new RuntimeException((Throwable)((Object)e));
            }
            int i = 0;
            while (i < children.length) {
                IModelElement el;
                if (children[i].getElementName().equals(this.path.get(index)) && (el = this.getElement(children[i], index + 1)) != null) {
                    return el;
                }
                ++i;
            }
        }
        return null;
    }

    protected IModelElement getModelElement() {
        if (!this.signature) {
            return null;
        }
        if (this.path.size() == 0) {
            return this.module;
        }
        return this.getElement(this.module, 0);
    }

    protected void exitElement() {
        if (this.path.size() > 0) {
            this.path.remove(this.path.size() - 1);
        }
    }

    protected String getKey() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.path.size()) {
            buffer.append(this.path.get(i));
            if (i != this.path.size() - 1) {
                buffer.append(IMixinRequestor.MIXIN_NAME_SEPARATOR);
            }
            ++i;
        }
        return buffer.toString();
    }

    public void acceptFieldReference(char[] fieldName, int sourcePosition) {
    }

    public void acceptMethodReference(char[] methodName, int argCount, int sourcePosition, int sourceEndPosition) {
    }

    public void acceptPackage(int declarationStart, int declarationEnd, char[] name) {
    }

    public void acceptTypeReference(char[][] typeName, int sourceStart, int sourceEnd) {
    }

    public void acceptTypeReference(char[] typeName, int sourcePosition) {
    }

    public boolean enterFieldCheckDuplicates(ISourceElementRequestor.FieldInfo info) {
        return false;
    }

    public boolean enterFieldWithParentType(ISourceElementRequestor.FieldInfo info, String parentName, String delimiter) {
        return false;
    }

    public void enterMethodRemoveSame(ISourceElementRequestor.MethodInfo info) {
    }

    public boolean enterMethodWithParentType(ISourceElementRequestor.MethodInfo info, String parentName, String delimiter) {
        return false;
    }

    public void enterModule() {
    }

    public void enterModuleRoot() {
    }

    public boolean enterTypeAppend(String fullName, String delimiter) {
        return false;
    }

    public void exitModule(int declarationEnd) {
    }

    public void exitModuleRoot() {
    }

    public void exitField(int declarationEnd) {
        this.exitElement();
    }

    public void exitMethod(int declarationEnd) {
        this.exitElement();
    }

    public void exitType(int declarationEnd) {
        this.exitElement();
    }

    public void enterField(ISourceElementRequestor.FieldInfo info) {
        this.enterElement(info.name);
        IMixinRequestor.ElementInfo elInfo = new IMixinRequestor.ElementInfo();
        elInfo.key = this.getKey();
        if (this.signature) {
            elInfo.object = this.getModelElement();
        }
        this.requestor.reportElement(elInfo);
    }

    public void enterMethod(ISourceElementRequestor.MethodInfo info) {
        this.enterElement(info.name);
        IMixinRequestor.ElementInfo elInfo = new IMixinRequestor.ElementInfo();
        elInfo.key = this.getKey();
        if (this.signature) {
            elInfo.object = this.getModelElement();
        }
        this.requestor.reportElement(elInfo);
    }

    public void enterType(ISourceElementRequestor.TypeInfo info) {
        this.enterElement(info.name);
        IMixinRequestor.ElementInfo elInfo = new IMixinRequestor.ElementInfo();
        elInfo.key = this.getKey();
        if (this.signature) {
            elInfo.object = this.getModelElement();
        }
        this.requestor.reportElement(elInfo);
    }
}

