/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.launching;

import com.ibm.icu.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.core.environment.IExecutionLogger;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.debug.core.DLTKDebugLaunchConstants;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.dltk.internal.launching.InterpreterMessages;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterRunner;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.launching.LaunchLogger;
import org.eclipse.dltk.launching.LaunchingMessages;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractInterpreterRunner
implements IInterpreterRunner {
    private IInterpreterInstall interpreterInstall;

    protected IInterpreterInstall getInstall() {
        return this.interpreterInstall;
    }

    private static String renderProcessLabel(String[] commandLine) {
        String format = LaunchingMessages.StandardInterpreterRunner;
        String timestamp = DateFormat.getDateTimeInstance((int)2, (int)2).format(new Date(System.currentTimeMillis()));
        return NLS.bind((String)format, (Object)commandLine[0], (Object)timestamp);
    }

    private static String renderCommandLineLabel(String[] commandLine) {
        if (commandLine.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < commandLine.length) {
            if (i != 0) {
                buf.append(' ');
            }
            char[] characters = commandLine[i].toCharArray();
            StringBuffer command = new StringBuffer();
            boolean containsSpace = false;
            int j = 0;
            while (j < characters.length) {
                char character = characters[j];
                if (character == '\"') {
                    command.append('\\');
                } else if (character == ' ') {
                    containsSpace = true;
                }
                command.append(character);
                ++j;
            }
            if (containsSpace) {
                buf.append('\"');
                buf.append(command.toString());
                buf.append('\"');
            } else {
                buf.append(command.toString());
            }
            ++i;
        }
        return buf.toString();
    }

    protected String renderCommandLineLabel(InterpreterConfig config) {
        String[] cmdLine = this.renderCommandLine(config);
        return AbstractInterpreterRunner.renderCommandLineLabel(cmdLine);
    }

    protected void abort(String message, Throwable exception) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.launching", 100, message, exception));
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.launching", code, message, exception));
    }

    protected Map getDefaultProcessMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(IProcess.ATTR_PROCESS_TYPE, this.getProcessType());
        return map;
    }

    protected String getProcessType() {
        return "script";
    }

    protected AbstractInterpreterRunner(IInterpreterInstall install) {
        this.interpreterInstall = install;
    }

    protected void checkConfig(InterpreterConfig config, IEnvironment environment) throws CoreException {
        IFileHandle script;
        IPath workingDirectoryPath = config.getWorkingDirectoryPath();
        IFileHandle dir = environment.getFile(workingDirectoryPath);
        if (!dir.exists()) {
            this.abort(NLS.bind((String)InterpreterMessages.errDebuggingEngineWorkingDirectoryDoesntExist, (Object)dir.toString()), null);
        }
        if (config.getScriptFilePath() == null) {
            return;
        }
        if (!config.isNoFile() && !(script = environment.getFile(config.getScriptFilePath())).exists()) {
            this.abort(NLS.bind((String)InterpreterMessages.errDebuggingEngineScriptFileDoesntExist, (Object)script.toString()), null);
        }
    }

    private IProcess newProcess(ILaunch launch, Process p, String label, Map attributes) throws CoreException {
        IProcess process = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)label, (Map)attributes);
        if (process == null) {
            p.destroy();
            this.abort(LaunchingMessages.AbstractInterpreterRunner_0, null);
        }
        return process;
    }

    protected String[] renderCommandLine(InterpreterConfig config) {
        return config.renderCommandLine(this.interpreterInstall);
    }

    protected IProcess rawRun(ILaunch launch, InterpreterConfig config) throws CoreException {
        LaunchLogger logger;
        IExecutionEnvironment exeEnv;
        Process p;
        this.checkConfig(config, this.getInstall().getEnvironment());
        String[] cmdLine = this.renderCommandLine(config);
        IPath workingDirectory = config.getWorkingDirectoryPath();
        String[] environment = config.getEnvironmentAsStringsIncluding(this.interpreterInstall.getEnvironmentVariables());
        String cmdLineLabel = AbstractInterpreterRunner.renderCommandLineLabel(cmdLine);
        String processLabel = AbstractInterpreterRunner.renderProcessLabel(cmdLine);
        if (DLTKLaunchingPlugin.TRACE_EXECUTION) {
            this.traceExecution(processLabel, cmdLineLabel, workingDirectory, environment);
        }
        if ((p = (exeEnv = this.interpreterInstall.getExecEnvironment()).exec(cmdLine, workingDirectory, environment, (IExecutionLogger)(logger = DLTKDebugPlugin.getDefault().getPluginPreferences().getBoolean("org.eclipse.dltk.debug.catchOutput") ? new LaunchLogger() : null))) == null) {
            this.abort(LaunchingMessages.AbstractInterpreterRunner_executionWasCancelled, null);
        }
        launch.setAttribute("org.eclipse.dltk.launching.LAUNCH_COMMAND_LINE", cmdLineLabel);
        IProcess process = this.newProcess(launch, p, processLabel, this.getDefaultProcessMap());
        process.setAttribute(IProcess.ATTR_CMDLINE, cmdLineLabel);
        return process;
    }

    private void traceExecution(String processLabel, String cmdLineLabel, IPath workingDirectory, String[] environment) {
        StringBuffer sb = new StringBuffer();
        sb.append("-----------------------------------------------\n");
        sb.append("Running ").append(processLabel).append('\n');
        sb.append("Command line: ").append(cmdLineLabel).append('\n');
        sb.append("Working directory: ").append(workingDirectory).append('\n');
        sb.append("Environment:\n");
        int i = 0;
        while (i < environment.length) {
            sb.append('\t').append(environment[i]).append('\n');
            ++i;
        }
        sb.append("-----------------------------------------------\n");
        System.out.println(sb);
    }

    public void run(InterpreterConfig config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(LaunchingMessages.AbstractInterpreterRunner_launching, 5);
            if (monitor.isCanceled()) {
                return;
            }
            this.alterConfig(launch, config);
            monitor.worked(1);
            monitor.subTask(LaunchingMessages.AbstractInterpreterRunner_running);
            IProcess process = this.rawRun(launch, config);
            if (!DLTKDebugLaunchConstants.isDebugConsole((ILaunch)launch)) {
                launch.addProcess(process);
            }
            monitor.worked(4);
        }
        finally {
            monitor.done();
        }
    }

    protected void alterConfig(ILaunch launch, InterpreterConfig config) {
    }
}

