/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.tests.builder;

import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.IBuildParticipant;
import org.eclipse.dltk.core.builder.IBuildParticipantFactory;
import org.eclipse.dltk.internal.core.builder.BuildParticipantManager;
import org.eclipse.dltk.utils.TextUtils;

public class BuildParticipantManagerTests
extends TestCase {
    private BuildParticipantManager.BuildParticipantDescriptor createDescriptor(String id, String requirements) {
        BuildParticipantManager.BuildParticipantDescriptor descriptor = new BuildParticipantManager.BuildParticipantDescriptor((IBuildParticipantFactory)new TestBuildParticipantFactory(id), id, id);
        String[] ids = TextUtils.split((String)requirements, (char)',');
        if (ids != null && ids.length != 0) {
            int i = 0;
            while (i < ids.length) {
                descriptor.requirements.add(ids[i]);
                ++i;
            }
        }
        return descriptor;
    }

    public void testSimple() {
        BuildParticipantManager.BuildParticipantDescriptor[] descriptors = new BuildParticipantManager.BuildParticipantDescriptor[]{this.createDescriptor("A", null), this.createDescriptor("B", null), this.createDescriptor("C", null)};
        IBuildParticipant[] participants = BuildParticipantManager.createParticipants(null, (BuildParticipantManager.BuildParticipantDescriptor[])descriptors);
        BuildParticipantManagerTests.assertEquals((int)3, (int)participants.length);
        BuildParticipantManagerTests.assertEquals((String)"A", (String)((TestBuildParticipant)participants[0]).key);
        BuildParticipantManagerTests.assertEquals((String)"B", (String)((TestBuildParticipant)participants[1]).key);
        BuildParticipantManagerTests.assertEquals((String)"C", (String)((TestBuildParticipant)participants[2]).key);
    }

    public void testDependency() {
        BuildParticipantManager.BuildParticipantDescriptor[] descriptors = new BuildParticipantManager.BuildParticipantDescriptor[]{this.createDescriptor("A", "B,C"), this.createDescriptor("B", "C"), this.createDescriptor("C", null)};
        IBuildParticipant[] participants = BuildParticipantManager.createParticipants(null, (BuildParticipantManager.BuildParticipantDescriptor[])descriptors);
        BuildParticipantManagerTests.assertEquals((int)3, (int)participants.length);
        BuildParticipantManagerTests.assertEquals((String)"C", (String)((TestBuildParticipant)participants[0]).key);
        BuildParticipantManagerTests.assertEquals((String)"B", (String)((TestBuildParticipant)participants[1]).key);
        BuildParticipantManagerTests.assertEquals((String)"A", (String)((TestBuildParticipant)participants[2]).key);
    }

    public void testMissingDependency() {
        BuildParticipantManager.BuildParticipantDescriptor[] descriptors = new BuildParticipantManager.BuildParticipantDescriptor[]{this.createDescriptor("A", "D"), this.createDescriptor("B", "C"), this.createDescriptor("C", null)};
        IBuildParticipant[] participants = BuildParticipantManager.createParticipants(null, (BuildParticipantManager.BuildParticipantDescriptor[])descriptors);
        BuildParticipantManagerTests.assertEquals((int)2, (int)participants.length);
        BuildParticipantManagerTests.assertEquals((String)"C", (String)((TestBuildParticipant)participants[0]).key);
        BuildParticipantManagerTests.assertEquals((String)"B", (String)((TestBuildParticipant)participants[1]).key);
    }

    private static class TestBuildParticipant
    implements IBuildParticipant {
        final String key;

        public TestBuildParticipant(String key) {
            this.key = key;
        }

        public void build(IBuildContext context) throws CoreException {
        }
    }

    private static class TestBuildParticipantFactory
    implements IBuildParticipantFactory {
        final String key;

        public TestBuildParticipantFactory(String key) {
            this.key = key;
        }

        public IBuildParticipant createBuildParticipant(IScriptProject project) throws CoreException {
            return new TestBuildParticipant(this.key);
        }
    }
}

