/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.launching.AbstractScriptLaunchConfigurationDelegate;
import org.eclipse.dltk.launching.InterpreterConfig;

public class TclLaunchConfigurationDelegate
extends AbstractScriptLaunchConfigurationDelegate {
    private static final String TCLLIBPATH_ENV_VAR = "TCLLIBPATH";

    public String getLanguageId() {
        return "org.eclipse.dltk.tcl.core.nature";
    }

    protected InterpreterConfig createInterpreterConfig(ILaunchConfiguration configuration, ILaunch launch) throws CoreException {
        InterpreterConfig config = super.createInterpreterConfig(configuration, launch);
        if (config != null) {
            this.addLibpathEnvVar(config, configuration);
            this.checkEnvVars(config, configuration);
        }
        return config;
    }

    protected void addLibpathEnvVar(InterpreterConfig config, ILaunchConfiguration configuration) throws CoreException {
        config.removeEnvVar(TCLLIBPATH_ENV_VAR);
        IPath[] paths = this.createBuildPath(configuration, config.getEnvironment());
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < paths.length) {
            IFileHandle file = config.getEnvironment().getFile(paths[i]);
            if (file != null) {
                if (sb.length() != 0) {
                    sb.append(' ');
                }
                sb.append('{');
                sb.append(file.toOSString());
                sb.append('}');
            }
            ++i;
        }
        if (sb.length() != 0) {
            config.addEnvVar(TCLLIBPATH_ENV_VAR, sb.toString());
        }
    }

    protected void checkEnvVars(InterpreterConfig config, ILaunchConfiguration configuration) {
    }
}

