/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.templates;

import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ui.templates.ScriptTemplateContext;
import org.eclipse.dltk.ui.templates.ScriptTemplateVariables;
import org.eclipse.dltk.ui.templates.TemplateMessages;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.GlobalTemplateVariables;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;

public abstract class ScriptTemplateContextType
extends TemplateContextType {
    public ScriptTemplateContextType() {
        this.setupResolvers();
    }

    public ScriptTemplateContextType(String id) {
        super(id);
        this.setupResolvers();
    }

    public ScriptTemplateContextType(String id, String name) {
        super(id, name);
        this.setupResolvers();
    }

    public abstract ScriptTemplateContext createContext(IDocument var1, int var2, int var3, ISourceModule var4);

    protected void validateVariables(TemplateVariable[] variables) throws TemplateException {
        int i = 0;
        while (i < variables.length) {
            TemplateVariable var = variables[i];
            if (var.getType().equals("cursor") && var.getOffsets().length > 1) {
                throw new TemplateException(TemplateMessages.Validation_SeveralCursorPositions);
            }
            ++i;
        }
    }

    protected void addGlobalResolvers() {
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Cursor());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.WordSelection());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.LineSelection());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Dollar());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Date());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Year());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Time());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.User());
    }

    protected void addScriptResolvers() {
        this.addResolver(new ScriptTemplateVariables.File());
        this.addResolver(new ScriptTemplateVariables.Language());
        this.addResolver(new ScriptTemplateVariables.Interpreter());
    }

    private void setupResolvers() {
        this.addGlobalResolvers();
        this.addScriptResolvers();
    }
}

