/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.Arrays;
import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;

public class ListNode
extends Node {
    private static final long serialVersionUID = 1L;
    private Node[] list;

    public ListNode(ISourcePosition position, int id, Node firstNode) {
        this(position, id);
        this.list = new Node[]{firstNode};
    }

    public ListNode(ISourcePosition position, int id) {
        super(position, id);
    }

    public ListNode(ISourcePosition position) {
        super(position, 51);
    }

    public ListNode add(Node node) {
        if (node == null) {
            return this;
        }
        if (this.list == null) {
            this.list = new Node[1];
        } else {
            Node[] newList = new Node[this.list.length + 1];
            System.arraycopy(this.list, 0, newList, 0, this.list.length);
            this.list = newList;
        }
        this.list[this.list.length - 1] = node;
        if (this.getPosition() == null) {
            this.setPosition(node.getPosition());
        } else {
            this.setPosition(this.getPosition().union(node.getPosition()));
        }
        return this;
    }

    public ListNode prepend(Node node) {
        if (node == null) {
            return this;
        }
        if (this.list == null) {
            this.list = new Node[1];
        } else {
            Node[] newList = new Node[this.list.length + 1];
            System.arraycopy(this.list, 0, newList, 1, this.list.length);
            this.list = newList;
        }
        this.list[0] = node;
        this.setPosition(this.getPosition().union(node.getPosition()));
        return this;
    }

    public int size() {
        return this.list == null ? 0 : this.list.length;
    }

    public ListNode addAll(ListNode other) {
        if (other != null && other.size() > 0) {
            if (this.list == null) {
                this.list = new Node[other.size()];
                System.arraycopy(other.list, 0, this.list, 0, other.list.length);
            } else {
                Node[] newList = new Node[this.list.length + other.size()];
                System.arraycopy(this.list, 0, newList, 0, this.list.length);
                System.arraycopy(other.list, 0, newList, this.list.length, other.list.length);
                this.list = newList;
            }
            this.setPosition(this.getPosition().union(this.getLast().getPosition()));
        }
        return this;
    }

    public ListNode addAll(Node other) {
        return this.add(other);
    }

    public Node getLast() {
        return this.list == null ? null : this.list[this.list.length - 1];
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(this.getNodeName());
        if (this.list == null) {
            b.append("(null)");
        } else {
            b.append("[");
            int i = 0;
            while (i < this.list.length) {
                b.append(this.list[i]);
                if (i + 1 < this.list.length) {
                    b.append(", ");
                }
                ++i;
            }
            b.append("]");
        }
        return b.toString();
    }

    public List childNodes() {
        return this.list == null ? EMPTY_LIST : Arrays.asList(this.list);
    }

    public Instruction accept(NodeVisitor visitor) {
        throw new RuntimeException("Base class ListNode should never be evaluated");
    }

    public Node get(int idx) {
        return this.list[idx];
    }
}

