/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core;

import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.compiler.SourceElementRequestVisitor;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceElementParser;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.SourceParserUtil;

public abstract class AbstractSourceElementParser
implements ISourceElementParser {
    private ISourceElementRequestor sourceElementRequestor = null;
    private IProblemReporter problemReporter;

    public void parseSourceModule(IModuleSource module) {
        block3: {
            ModuleDeclaration moduleDeclaration = this.parse(module);
            if (moduleDeclaration != null) {
                SourceElementRequestVisitor requestor = this.createVisitor();
                try {
                    moduleDeclaration.traverse(requestor);
                }
                catch (Exception e) {
                    if (!DLTKCore.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    protected ModuleDeclaration parse(IModuleSource module) {
        if (module instanceof ISourceModule) {
            return SourceParserUtil.getModuleDeclaration((ISourceModule)((Object)module), this.problemReporter);
        }
        return SourceParserUtil.getModuleDeclaration(module, this.getNatureId(), this.problemReporter);
    }

    public void setReporter(IProblemReporter reporter) {
        this.problemReporter = reporter;
    }

    public void setRequestor(ISourceElementRequestor requestor) {
        this.sourceElementRequestor = requestor;
    }

    protected ISourceElementRequestor getRequestor() {
        return this.sourceElementRequestor;
    }

    protected IProblemReporter getProblemReporter() {
        return this.problemReporter;
    }

    protected abstract String getNatureId();

    protected SourceElementRequestVisitor createVisitor() {
        return new SourceElementRequestVisitor(this.getRequestor());
    }
}

