/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.indexing;

import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.search.indexing.IIndexConstants;
import org.eclipse.dltk.core.search.indexing.IndexDocument;
import org.eclipse.dltk.internal.core.search.matching.FieldPattern;
import org.eclipse.dltk.internal.core.search.matching.MethodDeclarationPattern;
import org.eclipse.dltk.internal.core.search.matching.MethodPattern;
import org.eclipse.dltk.internal.core.search.matching.SuperTypeReferencePattern;
import org.eclipse.dltk.internal.core.search.matching.TypeDeclarationPattern;

public abstract class AbstractIndexer
implements IIndexConstants {
    protected final IndexDocument document;

    public AbstractIndexer(IndexDocument document) {
        this.document = document;
    }

    public void addTypeDeclaration(int modifiers, String[] namespace, String name, String[] enclosingTypeNames, String[] superclasss) {
        char[] indexKey = TypeDeclarationPattern.createIndexKey(modifiers, name, namespace, enclosingTypeNames, CharOperation.stringArrayToCharCharArray(superclasss));
        this.addIndexEntry(TYPE_DECL, indexKey);
        if (superclasss != null) {
            int i = 0;
            int max = superclasss.length;
            while (i < max) {
                String superClass = this.erasure(superclasss[i]);
                this.addTypeReference(superClass);
                this.addIndexEntry(SUPER_REF, SuperTypeReferencePattern.createIndexKey(modifiers, namespace, name, enclosingTypeNames, null, 'C', superClass.toCharArray(), 'C'));
                ++i;
            }
        }
    }

    private String erasure(String typeName) {
        return typeName;
    }

    public void addConstructorDeclaration(String typeName, String[] parameterTypes, String[] exceptionTypes) {
    }

    public void addConstructorReference(char[] typeName, int argCount) {
    }

    public void addFieldDeclaration(String fieldName, String typeName) {
        this.addIndexEntry(FIELD_DECL, FieldPattern.createIndexKey(fieldName));
        if (typeName != null) {
            this.addTypeReference(typeName);
        }
    }

    public void addFieldReference(String fieldName) {
        this.addNameReference(fieldName);
    }

    protected void addIndexEntry(char[] category, char[] key) {
        this.document.addIndexEntry(category, key);
    }

    public void addMethodDeclaration(int modifiers, String[] namespace, String[] enclosingTypeNames, String methodName, String[] parameterNames, String[] exceptionTypes) {
        this.addIndexEntry(METHOD_DECL, MethodDeclarationPattern.createIndexKey(modifiers, methodName, parameterNames, namespace, enclosingTypeNames));
    }

    public void addMethodReference(String methodName, int argCount) {
        this.addIndexEntry(METHOD_REF, MethodPattern.createIndexKey(methodName.toCharArray(), argCount));
    }

    public void addNameReference(String name) {
        this.addIndexEntry(REF, name.toCharArray());
    }

    public void addTypeReference(String typeName) {
        this.addNameReference(typeName);
    }

    public abstract void indexDocument();
}

