/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.javascript.ast.Argument;
import org.eclipse.dltk.javascript.ast.ArrayInitializer;
import org.eclipse.dltk.javascript.ast.AsteriskExpression;
import org.eclipse.dltk.javascript.ast.BinaryOperation;
import org.eclipse.dltk.javascript.ast.BooleanLiteral;
import org.eclipse.dltk.javascript.ast.BreakStatement;
import org.eclipse.dltk.javascript.ast.CallExpression;
import org.eclipse.dltk.javascript.ast.CaseClause;
import org.eclipse.dltk.javascript.ast.CatchClause;
import org.eclipse.dltk.javascript.ast.CommaExpression;
import org.eclipse.dltk.javascript.ast.ConditionalOperator;
import org.eclipse.dltk.javascript.ast.ConstStatement;
import org.eclipse.dltk.javascript.ast.ContinueStatement;
import org.eclipse.dltk.javascript.ast.DecimalLiteral;
import org.eclipse.dltk.javascript.ast.DefaultClause;
import org.eclipse.dltk.javascript.ast.DefaultXmlNamespaceStatement;
import org.eclipse.dltk.javascript.ast.DeleteStatement;
import org.eclipse.dltk.javascript.ast.DoWhileStatement;
import org.eclipse.dltk.javascript.ast.EmptyExpression;
import org.eclipse.dltk.javascript.ast.EmptyStatement;
import org.eclipse.dltk.javascript.ast.ErrorExpression;
import org.eclipse.dltk.javascript.ast.FinallyClause;
import org.eclipse.dltk.javascript.ast.ForEachInStatement;
import org.eclipse.dltk.javascript.ast.ForInStatement;
import org.eclipse.dltk.javascript.ast.ForStatement;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.GetAllChildrenExpression;
import org.eclipse.dltk.javascript.ast.GetArrayItemExpression;
import org.eclipse.dltk.javascript.ast.GetLocalNameExpression;
import org.eclipse.dltk.javascript.ast.GetMethod;
import org.eclipse.dltk.javascript.ast.INodeVisitor;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.IfStatement;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.JSUserNode;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.LabelledStatement;
import org.eclipse.dltk.javascript.ast.NewExpression;
import org.eclipse.dltk.javascript.ast.NullExpression;
import org.eclipse.dltk.javascript.ast.ObjectInitializer;
import org.eclipse.dltk.javascript.ast.ParenthesizedExpression;
import org.eclipse.dltk.javascript.ast.PropertyExpression;
import org.eclipse.dltk.javascript.ast.PropertyInitializer;
import org.eclipse.dltk.javascript.ast.RegExpLiteral;
import org.eclipse.dltk.javascript.ast.ReturnStatement;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.ast.SetMethod;
import org.eclipse.dltk.javascript.ast.StatementBlock;
import org.eclipse.dltk.javascript.ast.StringLiteral;
import org.eclipse.dltk.javascript.ast.SwitchStatement;
import org.eclipse.dltk.javascript.ast.ThisExpression;
import org.eclipse.dltk.javascript.ast.ThrowStatement;
import org.eclipse.dltk.javascript.ast.TryStatement;
import org.eclipse.dltk.javascript.ast.TypeOfExpression;
import org.eclipse.dltk.javascript.ast.UnaryOperation;
import org.eclipse.dltk.javascript.ast.VariableDeclaration;
import org.eclipse.dltk.javascript.ast.VariableStatement;
import org.eclipse.dltk.javascript.ast.VoidExpression;
import org.eclipse.dltk.javascript.ast.VoidOperator;
import org.eclipse.dltk.javascript.ast.WhileStatement;
import org.eclipse.dltk.javascript.ast.WithStatement;
import org.eclipse.dltk.javascript.ast.XmlAttributeIdentifier;
import org.eclipse.dltk.javascript.ast.XmlLiteral;
import org.eclipse.dltk.javascript.ast.YieldOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ASTVisitor<E>
implements INodeVisitor<E> {
    private static final Map<Class<? extends ASTNode>, Handler> HANDLERS = new HashMap<Class<? extends ASTNode>, Handler>();

    static {
        HANDLERS.put(ArrayInitializer.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitArrayInitializer((ArrayInitializer)node);
            }
        });
        HANDLERS.put(BinaryOperation.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitBinaryOperation((BinaryOperation)node);
            }
        });
        HANDLERS.put(BooleanLiteral.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitBooleanLiteral((BooleanLiteral)node);
            }
        });
        HANDLERS.put(BreakStatement.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitBreakStatement((BreakStatement)node);
            }
        });
        HANDLERS.put(CallExpression.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitCallExpression((CallExpression)node);
            }
        });
        HANDLERS.put(CommaExpression.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitCommaExpression((CommaExpression)node);
            }
        });
        HANDLERS.put(ConditionalOperator.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitConditionalOperator((ConditionalOperator)node);
            }
        });
        HANDLERS.put(ConstStatement.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitConstDeclaration((ConstStatement)node);
            }
        });
        HANDLERS.put(ContinueStatement.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitContinueStatement((ContinueStatement)node);
            }
        });
        HANDLERS.put(DecimalLiteral.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitDecimalLiteral((DecimalLiteral)node);
            }
        });
        HANDLERS.put(DeleteStatement.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitDeleteStatement((DeleteStatement)node);
            }
        });
        HANDLERS.put(DoWhileStatement.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitDoWhileStatement((DoWhileStatement)node);
            }
        });
        HANDLERS.put(EmptyExpression.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitEmptyExpression((EmptyExpression)node);
            }
        });
        HANDLERS.put(ForStatement.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitForStatement((ForStatement)node);
            }
        });
        HANDLERS.put(Script.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitScript((Script)node);
            }
        });
        HANDLERS.put(ForInStatement.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitForInStatement((ForInStatement)node);
            }
        });
        HANDLERS.put(ForEachInStatement.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitForEachInStatement((ForEachInStatement)node);
            }
        });
        HANDLERS.put(FunctionStatement.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitFunctionStatement((FunctionStatement)node);
            }
        });
        HANDLERS.put(Identifier.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitIdentifier((Identifier)node);
            }
        });
        HANDLERS.put(IfStatement.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitIfStatement((IfStatement)node);
            }
        });
        HANDLERS.put(NewExpression.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitNewExpression((NewExpression)node);
            }
        });
        HANDLERS.put(NullExpression.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitNullExpression((NullExpression)node);
            }
        });
        HANDLERS.put(ObjectInitializer.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitObjectInitializer((ObjectInitializer)node);
            }
        });
        HANDLERS.put(ParenthesizedExpression.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitParenthesizedExpression((ParenthesizedExpression)node);
            }
        });
        HANDLERS.put(RegExpLiteral.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitRegExpLiteral((RegExpLiteral)node);
            }
        });
        HANDLERS.put(ReturnStatement.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitReturnStatement((ReturnStatement)node);
            }
        });
        HANDLERS.put(StringLiteral.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitStringLiteral((StringLiteral)node);
            }
        });
        HANDLERS.put(SwitchStatement.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitSwitchStatement((SwitchStatement)node);
            }
        });
        HANDLERS.put(ThrowStatement.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitThrowStatement((ThrowStatement)node);
            }
        });
        HANDLERS.put(GetArrayItemExpression.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitGetArrayItemExpression((GetArrayItemExpression)node);
            }
        });
        HANDLERS.put(LabelledStatement.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitLabelledStatement((LabelledStatement)node);
            }
        });
        HANDLERS.put(PropertyExpression.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitPropertyExpression((PropertyExpression)node);
            }
        });
        HANDLERS.put(StatementBlock.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitStatementBlock((StatementBlock)node);
            }
        });
        HANDLERS.put(ThisExpression.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitThisExpression((ThisExpression)node);
            }
        });
        HANDLERS.put(TryStatement.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitTryStatement((TryStatement)node);
            }
        });
        HANDLERS.put(TypeOfExpression.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitTypeOfExpression((TypeOfExpression)node);
            }
        });
        HANDLERS.put(UnaryOperation.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitUnaryOperation((UnaryOperation)node);
            }
        });
        HANDLERS.put(VariableStatement.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitVariableStatement((VariableStatement)node);
            }
        });
        HANDLERS.put(VoidExpression.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitVoidExpression((VoidExpression)node);
            }
        });
        HANDLERS.put(WhileStatement.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitWhileStatement((WhileStatement)node);
            }
        });
        HANDLERS.put(WithStatement.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitWithStatement((WithStatement)node);
            }
        });
        HANDLERS.put(VoidOperator.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitVoidOperator((VoidOperator)node);
            }
        });
        HANDLERS.put(XmlLiteral.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitXmlLiteral((XmlLiteral)node);
            }
        });
        HANDLERS.put(DefaultXmlNamespaceStatement.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitDefaultXmlNamespace((DefaultXmlNamespaceStatement)node);
            }
        });
        HANDLERS.put(XmlAttributeIdentifier.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitXmlPropertyIdentifier((XmlAttributeIdentifier)node);
            }
        });
        HANDLERS.put(AsteriskExpression.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitAsteriskExpression((AsteriskExpression)node);
            }
        });
        HANDLERS.put(GetAllChildrenExpression.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitGetAllChildrenExpression((GetAllChildrenExpression)node);
            }
        });
        HANDLERS.put(GetLocalNameExpression.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitGetLocalNameExpression((GetLocalNameExpression)node);
            }
        });
        HANDLERS.put(YieldOperator.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitYieldOperator((YieldOperator)node);
            }
        });
        HANDLERS.put(ErrorExpression.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitErrorExpression((ErrorExpression)node);
            }
        });
        HANDLERS.put(EmptyStatement.class, new Handler(){

            @Override
            public <E> E handle(ASTVisitor<E> visitor, ASTNode node) {
                return visitor.visitEmptyStatement((EmptyStatement)node);
            }
        });
    }

    public E visit(Collection<? extends ASTNode> nodes) {
        E result = null;
        for (ASTNode aSTNode : nodes) {
            result = this.visit(aSTNode);
        }
        return result;
    }

    @Override
    public E visit(ASTNode node) {
        JSNode original;
        Handler handler = HANDLERS.get(node.getClass());
        if (handler != null) {
            return handler.handle(this, node);
        }
        if (node instanceof JSUserNode && (original = ((JSUserNode)node).getOriginal()) != null && (handler = HANDLERS.get(((Object)((Object)original)).getClass())) != null) {
            return handler.handle(this, original);
        }
        return this.visitUnknownNode(node);
    }

    public abstract E visitArrayInitializer(ArrayInitializer var1);

    public abstract E visitBinaryOperation(BinaryOperation var1);

    public abstract E visitBooleanLiteral(BooleanLiteral var1);

    public abstract E visitBreakStatement(BreakStatement var1);

    public abstract E visitCallExpression(CallExpression var1);

    @Deprecated
    public final E visitCaseClause(CaseClause node) {
        return null;
    }

    @Deprecated
    public final E visitCatchClause(CatchClause node) {
        return null;
    }

    public abstract E visitCommaExpression(CommaExpression var1);

    public abstract E visitConditionalOperator(ConditionalOperator var1);

    public abstract E visitConstDeclaration(ConstStatement var1);

    public abstract E visitContinueStatement(ContinueStatement var1);

    public abstract E visitDecimalLiteral(DecimalLiteral var1);

    @Deprecated
    public final E visitDefaultClause(DefaultClause node) {
        return null;
    }

    public abstract E visitDeleteStatement(DeleteStatement var1);

    public abstract E visitDoWhileStatement(DoWhileStatement var1);

    public abstract E visitEmptyExpression(EmptyExpression var1);

    @Deprecated
    public final E visitFinallyClause(FinallyClause node) {
        return null;
    }

    public abstract E visitForStatement(ForStatement var1);

    public abstract E visitForInStatement(ForInStatement var1);

    public abstract E visitForEachInStatement(ForEachInStatement var1);

    public abstract E visitFunctionStatement(FunctionStatement var1);

    @Deprecated
    public final E visitArgument(Argument argument) {
        return null;
    }

    public abstract E visitGetArrayItemExpression(GetArrayItemExpression var1);

    @Deprecated
    public final E visitGetMethod(GetMethod node) {
        return null;
    }

    public abstract E visitIdentifier(Identifier var1);

    public abstract E visitIfStatement(IfStatement var1);

    @Deprecated
    public final E visitKeyword(Keyword node) {
        return null;
    }

    public abstract E visitLabelledStatement(LabelledStatement var1);

    public abstract E visitNewExpression(NewExpression var1);

    public abstract E visitNullExpression(NullExpression var1);

    public abstract E visitObjectInitializer(ObjectInitializer var1);

    public abstract E visitParenthesizedExpression(ParenthesizedExpression var1);

    public abstract E visitPropertyExpression(PropertyExpression var1);

    @Deprecated
    public final E visitPropertyInitializer(PropertyInitializer node) {
        return null;
    }

    public abstract E visitRegExpLiteral(RegExpLiteral var1);

    public abstract E visitReturnStatement(ReturnStatement var1);

    public abstract E visitScript(Script var1);

    @Deprecated
    public final E visitSetMethod(SetMethod node) {
        return null;
    }

    public abstract E visitStatementBlock(StatementBlock var1);

    public abstract E visitStringLiteral(StringLiteral var1);

    public abstract E visitSwitchStatement(SwitchStatement var1);

    public abstract E visitThisExpression(ThisExpression var1);

    public abstract E visitThrowStatement(ThrowStatement var1);

    public abstract E visitTryStatement(TryStatement var1);

    public abstract E visitTypeOfExpression(TypeOfExpression var1);

    public abstract E visitUnaryOperation(UnaryOperation var1);

    public abstract E visitVariableStatement(VariableStatement var1);

    @Deprecated
    public final E visitVariableDeclaration(VariableDeclaration node) {
        return null;
    }

    public abstract E visitVoidExpression(VoidExpression var1);

    public abstract E visitVoidOperator(VoidOperator var1);

    public abstract E visitYieldOperator(YieldOperator var1);

    public abstract E visitWhileStatement(WhileStatement var1);

    public abstract E visitWithStatement(WithStatement var1);

    public abstract E visitXmlLiteral(XmlLiteral var1);

    public abstract E visitDefaultXmlNamespace(DefaultXmlNamespaceStatement var1);

    public abstract E visitXmlPropertyIdentifier(XmlAttributeIdentifier var1);

    public abstract E visitAsteriskExpression(AsteriskExpression var1);

    public abstract E visitGetAllChildrenExpression(GetAllChildrenExpression var1);

    public abstract E visitGetLocalNameExpression(GetLocalNameExpression var1);

    public E visitErrorExpression(ErrorExpression node) {
        return null;
    }

    public abstract E visitEmptyStatement(EmptyStatement var1);

    public E visitUnknownNode(ASTNode node) {
        throw new UnsupportedOperationException("Unknown node type: " + node.getClass().getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Handler {
        public <E> E handle(ASTVisitor<E> var1, ASTNode var2);
    }
}

