/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.core.dom;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum UnaryOperator implements Enumerator
{
    POSTFIX_INC(1, "postfixInc", "postfixInc"),
    POSTFIX_DEC(2, "postfixDec", "postfixDec"),
    DELETE(3, "delete", "delete"),
    VOID(4, "void", "void"),
    TYPEOF(5, "typeof", "typeof"),
    PREFIX_INC(6, "prefixInc", "++"),
    PREFIX_DEC(7, "prefixDec", "--"),
    UNARY_PLUS(8, "unaryPlus", "+"),
    NUM_NEG(9, "numNeg", "-"),
    BW_NOT(10, "bwNot", "~"),
    NOT(11, "not", "!"),
    YIELD(12, "yield", "yield");

    public static final int POSTFIX_INC_VALUE = 1;
    public static final int POSTFIX_DEC_VALUE = 2;
    public static final int DELETE_VALUE = 3;
    public static final int VOID_VALUE = 4;
    public static final int TYPEOF_VALUE = 5;
    public static final int PREFIX_INC_VALUE = 6;
    public static final int PREFIX_DEC_VALUE = 7;
    public static final int UNARY_PLUS_VALUE = 8;
    public static final int NUM_NEG_VALUE = 9;
    public static final int BW_NOT_VALUE = 10;
    public static final int NOT_VALUE = 11;
    public static final int YIELD_VALUE = 12;
    private static final UnaryOperator[] VALUES_ARRAY;
    public static final List<UnaryOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new UnaryOperator[]{POSTFIX_INC, POSTFIX_DEC, DELETE, VOID, TYPEOF, PREFIX_INC, PREFIX_DEC, UNARY_PLUS, NUM_NEG, BW_NOT, NOT, YIELD};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static UnaryOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            UnaryOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static UnaryOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            UnaryOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static UnaryOperator get(int value) {
        switch (value) {
            case 1: {
                return POSTFIX_INC;
            }
            case 2: {
                return POSTFIX_DEC;
            }
            case 3: {
                return DELETE;
            }
            case 4: {
                return VOID;
            }
            case 5: {
                return TYPEOF;
            }
            case 6: {
                return PREFIX_INC;
            }
            case 7: {
                return PREFIX_DEC;
            }
            case 8: {
                return UNARY_PLUS;
            }
            case 9: {
                return NUM_NEG;
            }
            case 10: {
                return BW_NOT;
            }
            case 11: {
                return NOT;
            }
            case 12: {
                return YIELD;
            }
        }
        return null;
    }

    private UnaryOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

