/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.dltk.ast.parser.IModuleDeclaration;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.parser.JavaScriptParser;
import org.eclipse.dltk.javascript.parser.Reporter;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinfo.JSTypeSet;
import org.eclipse.dltk.javascript.typeinfo.model.ClassType;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.Method;
import org.eclipse.dltk.javascript.typeinfo.model.Parameter;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptValidations {
    public static Script parse(IBuildContext context) {
        IModuleDeclaration declaration;
        IModuleDeclaration savedAST = (IModuleDeclaration)context.get(IBuildContext.ATTR_MODULE_DECLARATION);
        if (savedAST instanceof Script) {
            return (Script)savedAST;
        }
        ISourceModule module = context.getSourceModule();
        if (module != null && (declaration = SourceParserUtil.parse((ISourceModule)module, (IProblemReporter)context.getProblemReporter())) instanceof Script) {
            context.set(IBuildContext.ATTR_MODULE_DECLARATION, (Object)declaration);
            return (Script)declaration;
        }
        JavaScriptParser parser = new JavaScriptParser();
        Script script = parser.parse((IModuleSource)context, context.getProblemReporter());
        context.set(IBuildContext.ATTR_MODULE_DECLARATION, (Object)script);
        return script;
    }

    public static JSType typeOf(IValueReference reference) {
        if (reference != null) {
            if (reference.getDeclaredType() != null) {
                return reference.getDeclaredType();
            }
            JSTypeSet declaredTypes = reference.getDeclaredTypes();
            if (declaredTypes.size() == 1) {
                return declaredTypes.getFirst();
            }
            JSTypeSet types = reference.getTypes();
            if (types.size() == 1) {
                return types.getFirst();
            }
        }
        return null;
    }

    protected static Reporter createReporter(IBuildContext context) {
        return new Reporter(context.getLineTracker(), context.getProblemReporter());
    }

    private static <E extends Member> boolean canConvert(Object value, Class<E> elementType) {
        return elementType.isInstance(value) || elementType == Method.class && value instanceof Type && ((Type)value).getConstructor() != null;
    }

    private static <E extends Member> E convert(Object value, Class<E> elementType) {
        if (elementType.isInstance(value)) {
            return (E)((Member)value);
        }
        return (E)((Type)value).getConstructor();
    }

    public static <E extends Member> List<E> extractElements(IValueReference reference, Class<E> elementType) {
        Object value = reference.getAttribute("ELEMENT");
        if (JavaScriptValidations.canConvert(value, elementType)) {
            return Collections.singletonList(JavaScriptValidations.convert(value, elementType));
        }
        if (value instanceof Object[]) {
            Object[] elements = (Object[])value;
            ArrayList<E> result = null;
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (JavaScriptValidations.canConvert(element, elementType)) {
                    if (result == null) {
                        result = new ArrayList<E>(elements.length);
                    }
                    result.add(JavaScriptValidations.convert(element, elementType));
                }
                ++n2;
            }
            return result;
        }
        return null;
    }

    public static Method selectMethod(List<Method> methods, IValueReference[] arguments) {
        if (methods.size() == 1) {
            return methods.get(0);
        }
        Method argCountMatches = null;
        for (Method method : methods) {
            if (method.getParameters().size() != arguments.length) continue;
            boolean match = true;
            EList<Parameter> parameters = method.getParameters();
            int i = 0;
            while (i < parameters.size()) {
                JSType argumentType;
                JSType parameterType = ((Parameter)parameters.get(i)).getType();
                if (parameterType != null && (argumentType = JavaScriptValidations.typeOf(arguments[i])) != null && !(match = JSTypeSet.normalize(parameterType).isAssignableFrom(JSTypeSet.normalize(argumentType)))) break;
                ++i;
            }
            if (!match) continue;
            argCountMatches = method;
            break;
        }
        if (argCountMatches != null) {
            return argCountMatches;
        }
        return methods.get(0);
    }

    @Deprecated
    public static boolean isStatic(IValueReference valueRef) {
        if (valueRef == null) {
            return false;
        }
        for (JSType type : valueRef.getDeclaredTypes()) {
            if (type == null || !(type instanceof ClassType)) continue;
            return true;
        }
        for (JSType type : valueRef.getTypes()) {
            if (type == null || !(type instanceof ClassType)) continue;
            return true;
        }
        return false;
    }
}

