/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.core.codeassist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.codeassist.ScriptSelectionEngine;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.core.model.LocalVariable;
import org.eclipse.dltk.core.model.UnresolvedElement;
import org.eclipse.dltk.internal.javascript.ti.PositionReachedException;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencer2;
import org.eclipse.dltk.internal.javascript.validation.JavaScriptValidations;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.internal.core.codeassist.NodeFinder;
import org.eclipse.dltk.javascript.internal.core.codeassist.SelectionVisitor;
import org.eclipse.dltk.javascript.parser.JavaScriptParserUtil;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinference.ReferenceKind;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinfo.IElementConverter;
import org.eclipse.dltk.javascript.typeinfo.JSTypeSet;
import org.eclipse.dltk.javascript.typeinfo.TypeInfoManager;
import org.eclipse.dltk.javascript.typeinfo.model.Element;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.Method;
import org.eclipse.dltk.javascript.typeinfo.model.Property;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptSelectionEngine2
extends ScriptSelectionEngine {
    private static final boolean DEBUG = false;

    public IModelElement[] select(IModuleSource module, int position, int i) {
        if (!(module.getModelElement() instanceof ISourceModule) || i == -1) {
            return null;
        }
        String content = module.getSourceContents();
        if (position < 0 || position > content.length()) {
            return null;
        }
        Script script = JavaScriptParserUtil.parse((IModuleSource)module, null);
        NodeFinder finder = new NodeFinder(content, position, i + 1);
        finder.locate(script);
        ASTNode node = finder.getNode();
        if (node != null && node instanceof Identifier) {
            ReferenceLocation location;
            TypeInferencer2 inferencer2 = new TypeInferencer2();
            SelectionVisitor visitor = new SelectionVisitor(inferencer2, node);
            inferencer2.setVisitor(visitor);
            inferencer2.setModelElement(module.getModelElement());
            try {
                inferencer2.doInferencing(script);
            }
            catch (PositionReachedException positionReachedException) {}
            IValueReference value = visitor.getValue();
            if (value == null) {
                return null;
            }
            ReferenceKind kind = value.getKind();
            ISourceModule m = (ISourceModule)module.getModelElement();
            if (kind == ReferenceKind.ARGUMENT || kind == ReferenceKind.LOCAL) {
                ReferenceLocation location2 = value.getLocation();
                if (location2 == ReferenceLocation.UNKNOWN) {
                    return null;
                }
                IModelElement result = this.locateModelElement(location2);
                if (result != null && (result.getElementType() == 8 || result.getElementType() == 9)) {
                    return new IModelElement[]{result};
                }
                JSType type = JavaScriptValidations.typeOf(value);
                return new IModelElement[]{new LocalVariable((IModelElement)m, value.getName(), location2.getDeclarationStart(), location2.getDeclarationEnd(), location2.getNameStart(), location2.getNameEnd() - 1, type == null ? null : type.getName())};
            }
            if (kind == ReferenceKind.FUNCTION || kind == ReferenceKind.GLOBAL || kind == ReferenceKind.FIELD) {
                location = value.getLocation();
                if (location == ReferenceLocation.UNKNOWN) {
                    return null;
                }
                IModelElement result = this.locateModelElement(location);
                if (result != null) {
                    return new IModelElement[]{result};
                }
            } else if (kind == ReferenceKind.PROPERTY) {
                Collection properties = JavaScriptValidations.extractElements(value, Property.class);
                if (properties != null) {
                    return this.convert(m, properties);
                }
            } else if (kind == ReferenceKind.METHOD) {
                List<Method> methods = JavaScriptValidations.extractElements(value, Method.class);
                if (methods != null) {
                    IValueReference[] arguments = visitor.getArguments();
                    if (arguments == null) {
                        arguments = new IValueReference[]{};
                    }
                    Method method = JavaScriptValidations.selectMethod(methods, arguments);
                    return this.convert(m, (Collection<? extends Element>)Collections.singletonList(method));
                }
            } else if (kind == ReferenceKind.TYPE) {
                LinkedHashSet t = new LinkedHashSet();
                JSTypeSet types = value.getDeclaredTypes();
                if (types != null) {
                    Collections.addAll(t, types.toArray());
                }
                if ((types = value.getTypes()) != null) {
                    Collections.addAll(t, types.toArray());
                }
                if (!t.isEmpty()) {
                    return this.convert(m, t);
                }
            }
            if ((location = value.getLocation()) != ReferenceLocation.UNKNOWN && location.getSourceModule() != null) {
                return new IModelElement[]{new UnresolvedElement((IModelElement)location.getSourceModule(), value.getName(), location.getNameStart(), location.getNameEnd() - 1)};
            }
        }
        return null;
    }

    private IModelElement[] convert(ISourceModule module, Collection<? extends Element> elements) {
        ArrayList<IModelElement> result = new ArrayList<IModelElement>();
        for (Element element : elements) {
            try {
                IModelElement me = this.convert(module, element);
                if (me != null) {
                    result.add(me);
                    continue;
                }
                this.reportForeignElement(element);
            }
            catch (ModelException modelException) {}
        }
        return result.toArray(new IModelElement[result.size()]);
    }

    private IModelElement convert(ISourceModule module, Element element) throws ModelException {
        Type type = element instanceof Type ? (Type)element : ((Member)element).getDeclaringType();
        if (type != null && type.getKind() == TypeKind.PREDEFINED) {
            ArrayList<String> path = new ArrayList<String>();
            path.add(type.getName());
            if (element != type) {
                path.add(element.getName());
            }
            return this.resolveBuiltin(module.getScriptProject(), path);
        }
        if (type != null && type.getKind() == TypeKind.JAVASCRIPT) {
            ReferenceLocation location = (ReferenceLocation)element.getAttribute("LOCATION");
            if (location != null && location != ReferenceLocation.UNKNOWN) {
                if (element instanceof Property) {
                    return new LocalVariable((IModelElement)module, element.getName(), location.getDeclarationStart(), location.getDeclarationEnd(), location.getNameStart(), location.getNameEnd() - 1, null);
                }
                IModelElement result = this.locateModelElement(location);
                if (result != null) {
                    return result;
                }
            } else {
                IModelElement[] children;
                IModelElement[] iModelElementArray = children = module.getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IModelElement modelElement = iModelElementArray[n2];
                    if (modelElement.getElementType() == 9 && modelElement.getElementName().equals(type.getName())) {
                        IModelElement[] children2;
                        IModelElement[] iModelElementArray2 = children2 = ((IParent)modelElement).getChildren();
                        int n3 = children2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IModelElement child = iModelElementArray2[n4];
                            if (child.getElementName().equals(element.getName())) {
                                return child;
                            }
                            ++n4;
                        }
                        return modelElement;
                    }
                    ++n2;
                }
            }
        }
        IElementConverter[] iElementConverterArray = TypeInfoManager.getElementConverters();
        int n = iElementConverterArray.length;
        int n5 = 0;
        while (n5 < n) {
            IElementConverter converter = iElementConverterArray[n5];
            IModelElement result = converter.convert(module, element);
            if (result != null) {
                return result;
            }
            ++n5;
        }
        return null;
    }

    private IModelElement locateModelElement(ReferenceLocation location) {
        ISourceModule module = location.getSourceModule();
        if (module != null) {
            try {
                ScriptModelUtil.reconcile((ISourceModule)module);
                module.accept((IModelElementVisitor)new Visitor(location.getNameStart(), location.getNameEnd()));
            }
            catch (ModelException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (ModelElementFound e) {
                return e.element;
            }
        }
        return null;
    }

    private IModelElement resolveBuiltin(IScriptProject project, List<String> segments) throws ModelException {
        IProjectFragment[] iProjectFragmentArray = project.getProjectFragments();
        int n = iProjectFragmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProjectFragment fragment = iProjectFragmentArray[n2];
            if (fragment.isBuiltin()) {
                ISourceModule m = fragment.getScriptFolder((IPath)Path.EMPTY).getSourceModule("builtins.js");
                if (!m.exists()) {
                    return null;
                }
                ISourceModule me = m;
                block1: for (String segment : segments) {
                    if (me instanceof IParent) {
                        IModelElement[] children;
                        IModelElement[] iModelElementArray = children = ((IParent)me).getChildren();
                        int n3 = children.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IModelElement child = iModelElementArray[n4];
                            if (segment.equals(child.getElementName())) {
                                me = child;
                                continue block1;
                            }
                            ++n4;
                        }
                    }
                    return null;
                }
                return me;
            }
            ++n2;
        }
        return null;
    }

    private static class ModelElementFound
    extends RuntimeException {
        final IModelElement element;

        public ModelElementFound(IModelElement element) {
            this.element = element;
        }
    }

    private static class Visitor
    implements IModelElementVisitor {
        private final int nameStart;
        private final int nameEnd;

        public Visitor(int nameStart, int nameEnd) {
            this.nameStart = nameStart;
            this.nameEnd = nameEnd;
        }

        public boolean visit(IModelElement element) {
            if (element instanceof IMember) {
                IMember member = (IMember)element;
                try {
                    ISourceRange range = member.getNameRange();
                    if (range.getOffset() == this.nameStart && range.getLength() == this.nameEnd - this.nameStart) {
                        throw new ModelElementFound(element);
                    }
                }
                catch (ModelException modelException) {}
            }
            return true;
        }
    }
}

