/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import org.eclipse.dltk.javascript.typeinfo.ITypeInfoContext;
import org.eclipse.dltk.javascript.typeinfo.TypeInfoResourceSet;
import org.eclipse.dltk.javascript.typeinfo.model.AnyType;
import org.eclipse.dltk.javascript.typeinfo.model.ArrayType;
import org.eclipse.dltk.javascript.typeinfo.model.ClassType;
import org.eclipse.dltk.javascript.typeinfo.model.GenericType;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.MapType;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.RecordType;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelFactory;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelLoader;
import org.eclipse.dltk.javascript.typeinfo.model.TypeRef;
import org.eclipse.dltk.javascript.typeinfo.model.UndefinedType;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class TypeUtil {
    private static final String PROXY_SCHEME = "proxy";
    private static final String PROXY_OPAQUE_PART = "dltk/javascript/typeinfo/type";

    public static TypeRef ref(Type type) {
        if (type != null) {
            TypeRef ref = TypeInfoModelFactory.eINSTANCE.createTypeRef();
            ref.setTarget(type);
            return ref;
        }
        return null;
    }

    public static ClassType classType(Type type) {
        if (type != null) {
            ClassType ref = TypeInfoModelFactory.eINSTANCE.createClassType();
            ref.setTarget(type);
            return ref;
        }
        return null;
    }

    public static JSType ref(String typeName) {
        return TypeUtil.ref(TypeUtil.type(typeName));
    }

    public static Type type(String typeName) {
        Type type = TypeInfoModelLoader.getInstance().getType(typeName);
        if (type != null) {
            return type;
        }
        return TypeUtil.createProxy(typeName);
    }

    public static ArrayType arrayOf(String itemType) {
        return TypeUtil.arrayOf(TypeUtil.ref(itemType));
    }

    public static ArrayType arrayOf(JSType itemType) {
        ArrayType arrayType = TypeInfoModelFactory.eINSTANCE.createArrayType();
        arrayType.setItemType(itemType != null ? itemType : TypeUtil.ref(TypeInfoModelLoader.getInstance().getType("Object")));
        return arrayType;
    }

    public static MapType mapOf(String keyType, String valueType) {
        return TypeUtil.mapOf(keyType != null ? TypeUtil.ref(keyType) : null, TypeUtil.ref(valueType));
    }

    public static MapType mapOf(JSType keyType, JSType valueType) {
        MapType mapType = TypeInfoModelFactory.eINSTANCE.createMapType();
        mapType.setKeyType(keyType != null ? keyType : TypeUtil.ref(TypeInfoModelLoader.getInstance().getType("String")));
        mapType.setValueType(valueType != null ? valueType : TypeUtil.ref(TypeInfoModelLoader.getInstance().getType("Object")));
        return mapType;
    }

    public static GenericType genericType(String baseType, JSType ... typeParameters) {
        GenericType genericType = TypeInfoModelFactory.eINSTANCE.createGenericType();
        genericType.setTarget(TypeUtil.type(baseType));
        JSType[] jSTypeArray = typeParameters;
        int n = typeParameters.length;
        int n2 = 0;
        while (n2 < n) {
            JSType typeParameter = jSTypeArray[n2];
            genericType.getTypeParameters().add((Object)typeParameter);
            ++n2;
        }
        return genericType;
    }

    public static Type extractType(JSType type) {
        if (type instanceof TypeRef) {
            return ((TypeRef)type).getTarget();
        }
        if (type instanceof ClassType) {
            return ((ClassType)type).getTarget();
        }
        if (type instanceof ArrayType) {
            return TypeInfoModelLoader.getInstance().getType("Array");
        }
        if (type instanceof MapType) {
            return TypeInfoModelLoader.getInstance().getType("Object");
        }
        if (type instanceof AnyType) {
            return TypeInfoModelLoader.getInstance().getType("Object");
        }
        if (type instanceof RecordType) {
            return ((RecordType)type).getTarget();
        }
        return null;
    }

    public static JSType extractArrayItemType(JSType type, ITypeInfoContext context) {
        if (type instanceof ArrayType) {
            return ((ArrayType)type).getItemType();
        }
        if (type instanceof MapType) {
            return ((MapType)type).getValueType();
        }
        if (type != null && type.getName().equals("XML")) {
            return type;
        }
        if (type != null && type.getName().equals("XMLList")) {
            return context.getTypeRef("XML");
        }
        return null;
    }

    public static String getName(JSType type) {
        return type != null ? type.getName() : null;
    }

    public static String getName(Type type) {
        if (type.isProxy()) {
            return URI.decode((String)((InternalEObject)type).eProxyURI().fragment());
        }
        return type.getName();
    }

    public static Type createProxy(String typeName) {
        Type type = TypeInfoModelFactory.eINSTANCE.createType();
        type.setName(typeName);
        ((InternalEObject)type).eSetProxyURI(TypeUtil.createProxyURI(typeName));
        return type;
    }

    public static URI createProxyURI(String typeName) {
        return URI.createGenericURI((String)PROXY_SCHEME, (String)PROXY_OPAQUE_PART, (String)URI.encodeFragment((String)typeName, (boolean)false));
    }

    public static Type createProxy(Type type) {
        Type result = TypeInfoModelFactory.eINSTANCE.createType();
        if (type.isProxy()) {
            ((InternalEObject)result).eSetProxyURI(((InternalEObject)type).eProxyURI());
        } else {
            String typeName = type.getName();
            result.setName(typeName);
            ((InternalEObject)result).eSetProxyURI(TypeUtil.createProxyURI(typeName));
        }
        return result;
    }

    public static boolean isTypeProxy(URI uri) {
        return PROXY_SCHEME.equals(uri.scheme()) && PROXY_OPAQUE_PART.equals(uri.opaquePart());
    }

    public static URI createProxyResourceURI() {
        return URI.createGenericURI((String)PROXY_SCHEME, (String)PROXY_OPAQUE_PART, null);
    }

    public static EObject resolve(InternalEObject proxy, EObject objectContext) {
        ResourceSet resourceSet;
        Resource resource = objectContext.eResource();
        if (resource != null && (resourceSet = resource.getResourceSet()) instanceof TypeInfoResourceSet) {
            return ((TypeInfoResourceSet)resourceSet).resolve(proxy, objectContext, resource);
        }
        return EcoreUtil.resolve((EObject)proxy, (EObject)objectContext);
    }

    public static boolean isDeclaringTypeVisible(Member member) {
        return member.getDeclaringType() != null && !(((EObject)member.getDeclaringType()).eContainer() instanceof RecordType);
    }

    public static boolean isValueTypeVisible(JSType type) {
        if (type == null) {
            return false;
        }
        if (type instanceof UndefinedType) {
            return false;
        }
        return !(type instanceof RecordType);
    }
}

