/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.parser.jsdoc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.dltk.javascript.parser.jsdoc.JSDocTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSDocTags {
    private final List<JSDocTag> tags = new ArrayList<JSDocTag>();

    public List<JSDocTag> list() {
        return Collections.unmodifiableList(this.tags);
    }

    public JSDocTag get(String tagName) {
        for (JSDocTag tag : this.tags) {
            if (!tagName.equals(tag.name())) continue;
            return tag;
        }
        return null;
    }

    public JSDocTag get(String[] tagNames) {
        for (JSDocTag tag : this.tags) {
            String[] stringArray = tagNames;
            int n = tagNames.length;
            int n2 = 0;
            while (n2 < n) {
                String tagName = stringArray[n2];
                if (tagName.equals(tag.name())) {
                    return tag;
                }
                ++n2;
            }
        }
        return null;
    }

    public List<JSDocTag> list(String tagName) {
        List<JSDocTag> result = null;
        for (JSDocTag tag : this.tags) {
            if (!tagName.equals(tag.name())) continue;
            if (result == null) {
                result = new ArrayList<JSDocTag>();
            }
            result.add(tag);
        }
        return result != null ? result : Collections.emptyList();
    }

    public List<JSDocTag> list(String[] tagNames) {
        List<JSDocTag> result = null;
        block0: for (JSDocTag tag : this.tags) {
            String[] stringArray = tagNames;
            int n = tagNames.length;
            int n2 = 0;
            while (n2 < n) {
                String tagName = stringArray[n2];
                if (tagName.equals(tag.name())) {
                    if (result == null) {
                        result = new ArrayList<JSDocTag>();
                    }
                    result.add(tag);
                    continue block0;
                }
                ++n2;
            }
        }
        return result != null ? result : Collections.emptyList();
    }

    public int count(String tagName) {
        int result = 0;
        for (JSDocTag tag : this.tags) {
            if (!tagName.equals(tag.name())) continue;
            ++result;
        }
        return result;
    }

    public int count(String[] tagNames) {
        int result = 0;
        block0: for (JSDocTag tag : this.tags) {
            String[] stringArray = tagNames;
            int n = tagNames.length;
            int n2 = 0;
            while (n2 < n) {
                String tagName = stringArray[n2];
                if (tagName.equals(tag.name())) {
                    ++result;
                    continue block0;
                }
                ++n2;
            }
        }
        return result;
    }

    public void add(JSDocTag tag) {
        this.tags.add(tag);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        boolean first = true;
        for (JSDocTag tag : this.tags) {
            if (!first) {
                sb.append(",\n ");
            } else {
                first = false;
            }
            sb.append(tag);
        }
        sb.append(']');
        return sb.toString();
    }
}

