/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.dltk.internal.javascript.ti.ChildReference;
import org.eclipse.dltk.internal.javascript.ti.ILazyValue;
import org.eclipse.dltk.internal.javascript.ti.IValue;
import org.eclipse.dltk.internal.javascript.ti.IValueProvider;
import org.eclipse.dltk.internal.javascript.ti.PhantomValue;
import org.eclipse.dltk.internal.javascript.ti.Value;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinference.ReferenceKind;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.JSTypeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReference
implements IValueReference,
IValueProvider {
    @Override
    public abstract IValue getValue();

    @Override
    public abstract IValue createValue();

    @Override
    public void setValue(IValueReference value) {
        IValue val = this.createValue();
        if (val != null && value != null) {
            IValue src = ((IValueProvider)((Object)value)).getValue();
            if (src == PhantomValue.VALUE) {
                val.addReference(src);
                return;
            }
            if (src == null) {
                src = new LazyReferenceValue(value);
                val.addReference(src);
                return;
            }
            val.clear();
            if (src instanceof Value && ((IValueProvider)((Object)value)).isReference() || value.isParentOf(this)) {
                val.addReference(src);
            } else {
                val.addValue(src);
            }
        }
    }

    @Override
    public void addValue(IValueReference value, boolean copy) {
        IValue val = this.createValue();
        if (val != null && value != null) {
            IValue src = ((IValueProvider)((Object)value)).getValue();
            if (src == PhantomValue.VALUE) {
                val.addReference(src);
                return;
            }
            if (src == null) {
                src = new LazyReferenceValue(value);
                val.addReference(src);
                return;
            }
            if (!copy && src instanceof Value && ((IValueProvider)((Object)value)).isReference() || value.isParentOf(this)) {
                val.addReference(src);
            } else {
                val.addValue(src);
            }
        }
    }

    @Override
    public boolean isParentOf(IValueReference anotherReference) {
        while (anotherReference != null) {
            if (this.equals(anotherReference)) {
                return true;
            }
            anotherReference = anotherReference.getParent();
        }
        return false;
    }

    @Override
    public void clear() {
        IValue value = this.getValue();
        if (value != null) {
            value.clear();
        }
    }

    @Override
    public boolean exists() {
        return this.getValue() != null;
    }

    @Override
    public final Object getAttribute(String key) {
        return this.getAttribute(key, false);
    }

    @Override
    public Object getAttribute(String key, boolean includeReferences) {
        IValue value = this.getValue();
        return value != null ? value.getAttribute(key, includeReferences) : null;
    }

    @Override
    public IRType getDeclaredType() {
        IValue value = this.getValue();
        return value != null ? value.getDeclaredType() : null;
    }

    @Override
    public JSTypeSet getDeclaredTypes() {
        IValue value = this.getValue();
        return value != null ? value.getDeclaredTypes() : JSTypeSet.emptySet();
    }

    @Override
    public ReferenceKind getKind() {
        IValue value = this.getValue();
        return value != null ? value.getKind() : ReferenceKind.UNKNOWN;
    }

    @Override
    public ReferenceLocation getLocation() {
        IValue value = this.getValue();
        return value != null ? value.getLocation() : ReferenceLocation.UNKNOWN;
    }

    @Override
    public JSTypeSet getTypes() {
        IValue value = this.getValue();
        return value != null ? value.getTypes() : JSTypeSet.emptySet();
    }

    @Override
    public void setAttribute(String key, Object value) {
        IValue val = this.createValue();
        if (val != null) {
            val.setAttribute(key, value);
        }
    }

    @Override
    public void setDeclaredType(IRType type) {
        IValue value = this.createValue();
        if (value != null) {
            value.setDeclaredType(type);
        }
    }

    @Override
    public void setKind(ReferenceKind kind) {
        IValue value = this.createValue();
        if (value != null) {
            value.setKind(kind);
        }
    }

    @Override
    public void setLocation(ReferenceLocation location) {
        IValue value = this.createValue();
        if (value != null) {
            value.setLocation(location);
        }
    }

    @Override
    public IValueReference getChild(String name) {
        return new ChildReference(this, name);
    }

    @Override
    public IValueReference createChild(String name) {
        this.createValue().createChild(name, 1);
        return this.getChild(name);
    }

    @Override
    public boolean hasChild(String name) {
        IValue value = this.getValue();
        return value != null && value.getChild(name, true) != null;
    }

    @Override
    public Set<String> getDirectChildren() {
        IValue value = this.getValue();
        return value != null ? value.getDirectChildren() : Collections.emptySet();
    }

    @Override
    public Set<String> getDeletedChildren() {
        IValue value = this.getValue();
        return value != null ? value.getDeletedChildren() : Collections.emptySet();
    }

    private static final class LazyReferenceValue
    extends Value
    implements ILazyValue {
        private final IValueReference reference;
        private boolean resolved = false;
        private boolean finalResolve;
        private boolean typeResolved;

        public LazyReferenceValue(IValueReference value) {
            this.reference = value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof LazyReferenceValue) {
                return this.reference.equals(((LazyReferenceValue)obj).reference);
            }
            return false;
        }

        public int hashCode() {
            return this.reference.hashCode();
        }

        public void resolve() {
            if (!this.resolved) {
                this.resolved = true;
                IValue value = ((IValueProvider)((Object)this.reference)).getValue();
                if (value != null) {
                    if (this.finalResolve && value instanceof Value) {
                        ((Value)value).resolveLazyValues(new HashSet<Value>());
                    }
                    if (value instanceof Value && ((IValueProvider)((Object)this.reference)).isReference()) {
                        this.addReference(value);
                    } else {
                        this.addValue(value);
                    }
                } else {
                    boolean resolvedToType = false;
                    if (!this.finalResolve && !this.typeResolved) {
                        this.typeResolved = true;
                        IValueReference parent = this.reference.getParent();
                        while (parent instanceof IValueProvider) {
                            value = ((IValueProvider)((Object)parent)).getValue();
                            if (value != null) {
                                resolvedToType = !value.getTypes().isEmpty() || !value.getDeclaredTypes().isEmpty();
                                break;
                            }
                            parent = parent.getParent();
                        }
                    }
                    this.resolved = this.finalResolve || resolvedToType;
                }
            }
        }

        public void setFinalResolve() {
            this.finalResolve = true;
        }

        public String getLazyName() {
            return null;
        }

        public boolean isResolved() {
            return this.resolved;
        }

        public String toString() {
            return "LazyReferenceValue[resolved:" + this.resolved + ",reference:" + this.reference + ']';
        }
    }
}

