/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.internal.javascript.ti.ElementValue;
import org.eclipse.dltk.internal.javascript.ti.ITypeInferenceContext;
import org.eclipse.dltk.internal.javascript.ti.IValue;
import org.eclipse.dltk.internal.javascript.ti.IValueProvider;
import org.eclipse.dltk.internal.javascript.ti.PackageOrClassValue;
import org.eclipse.dltk.internal.javascript.ti.PackagesValue;
import org.eclipse.dltk.internal.javascript.ti.TopValueThis;
import org.eclipse.dltk.internal.javascript.ti.Value;
import org.eclipse.dltk.internal.javascript.ti.ValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.TypeMode;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelLoader;
import org.eclipse.dltk.javascript.typeinfo.model.TypeKind;

public class TopValueCollection
extends ValueCollection {
    private final TopValueThis thisValue = new TopValueThis(this);

    public boolean isScope() {
        return true;
    }

    public TopValueCollection(ITypeInferenceContext context) {
        super(null, new TopValue(context));
        IValueCollection topValueCollection = context.getTopValueCollection();
        if (topValueCollection instanceof IValueProvider) {
            this.getValue().addValue(((IValueProvider)((Object)topValueCollection)).getValue());
        }
    }

    public IValueReference getThis() {
        return this.thisValue;
    }

    private static final class TopValue
    extends Value {
        private final ITypeInferenceContext context;
        private final Map<String, IValue> memberCache = new HashMap<String, IValue>();

        public TopValue(ITypeInferenceContext context) {
            this.context = context;
        }

        protected ITypeSystem getTypeSystem() {
            return this.context;
        }

        protected IValue findMember(String name, boolean resolve) {
            IValue member = super.findMember(name, resolve);
            if (resolve && member == null) {
                IValue value = this.memberCache.get(name);
                if (value != null) {
                    return value;
                }
                Member element = this.context.resolve(name);
                if (element != null) {
                    value = this.context.valueOf(element);
                    if (value == null) {
                        value = ElementValue.createFor(element, this.context);
                    }
                    this.memberCache.put(name, value);
                    return value;
                }
                if (name.equals("[]")) {
                    value = ElementValue.createFor(TypeInfoModelLoader.getInstance().getType("Array"), this.context);
                    this.memberCache.put(name, value);
                    return value;
                }
                Type type = this.context.getKnownType(name, TypeMode.CODE);
                if (type != null && type.getKind() != TypeKind.UNKNOWN) {
                    value = ElementValue.createClass(this.context, type);
                    this.memberCache.put(name, value);
                    return value;
                }
                if ("Packages".equals(name)) {
                    value = new PackagesValue(this.context);
                    this.memberCache.put(name, value);
                    return value;
                }
                if (name.startsWith("Packages.")) {
                    value = new PackageOrClassValue(name.substring("Packages.".length()), this.context);
                    this.memberCache.put(name, value);
                    return value;
                }
                if ("java".equals(name) || name.startsWith("java.")) {
                    value = new PackageOrClassValue(name, this.context);
                    this.memberCache.put(name, value);
                    return value;
                }
            }
            return member;
        }

        protected void childCreated(String name) {
            super.childCreated(name);
            this.memberCache.remove(name);
        }
    }
}

