/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.indexing.core;

import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.core.search.indexing.IProjectIndexer;
import org.eclipse.dltk.core.search.indexing.IndexDocument;
import org.eclipse.dltk.core.search.indexing.IndexManager;
import org.eclipse.dltk.core.search.indexing.core.ArchiveProjectFragmentRequest;
import org.eclipse.dltk.core.search.indexing.core.ExternalProjectFragmentRequest;
import org.eclipse.dltk.core.search.indexing.core.IndexRequest;
import org.eclipse.dltk.core.search.indexing.core.Messages;
import org.eclipse.dltk.core.search.indexing.core.ProjectRequest;
import org.eclipse.dltk.core.search.indexing.core.RemoveIndexRequest;
import org.eclipse.dltk.core.search.indexing.core.SourceModuleRemoveRequest;
import org.eclipse.dltk.core.search.indexing.core.SourceModuleRequest;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.search.processing.IJob;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractProjectIndexer
implements IProjectIndexer,
IProjectIndexer.Internal {
    private final IndexManager manager = ModelManager.getModelManager().getIndexManager();

    public void request(IJob job) {
        this.manager.request(job);
    }

    public void requestIfNotWaiting(IJob job) {
        this.manager.requestIfNotWaiting(job);
    }

    public IndexManager getIndexManager() {
        return this.manager;
    }

    public void indexProject(IScriptProject project) {
        ProjectRequest request = new ProjectRequest(this, project);
        this.requestIfNotWaiting(request);
    }

    public void indexLibrary(IScriptProject project, IPath path) {
        try {
            IProjectFragment fragment = project.findProjectFragment(path);
            if (fragment != null) {
                if (!path.segment(0).equals("#special#builtin#")) {
                    IndexRequest request = fragment.isArchive() ? new ArchiveProjectFragmentRequest(this, fragment, DLTKLanguageManager.getLanguageToolkit(fragment)) : new ExternalProjectFragmentRequest(this, fragment, DLTKLanguageManager.getLanguageToolkit(fragment));
                    this.requestIfNotWaiting(request);
                }
            } else {
                DLTKCore.warn(NLS.bind((String)Messages.MixinIndexer_unknownProjectFragment, (Object)path));
            }
        }
        catch (Exception e) {
            DLTKCore.error(NLS.bind((String)Messages.MixinIndexer_indexLibraryError, (Object)path), e);
        }
    }

    public void indexProjectFragment(IScriptProject project, IPath path) {
        IProjectFragment fragmentToIndex = null;
        try {
            IProjectFragment[] fragments;
            IProjectFragment[] iProjectFragmentArray = fragments = project.getProjectFragments();
            int n = fragments.length;
            int n2 = 0;
            while (n2 < n) {
                IProjectFragment fragment = iProjectFragmentArray[n2];
                if (fragment.getPath().equals((Object)path)) {
                    fragmentToIndex = fragment;
                    break;
                }
                ++n2;
            }
        }
        catch (ModelException e) {
            DLTKCore.error("Failed to index fragment:" + path.toString(), (Throwable)((Object)e));
        }
        if (fragmentToIndex == null || !fragmentToIndex.isExternal() || fragmentToIndex.isBuiltin()) {
            this.requestIfNotWaiting(new ProjectRequest(this, project));
            return;
        }
        IndexRequest indexRequest = fragmentToIndex.isArchive() ? new ArchiveProjectFragmentRequest(this, fragmentToIndex, DLTKLanguageManager.getLanguageToolkit(project)) : new ExternalProjectFragmentRequest(this, fragmentToIndex, DLTKLanguageManager.getLanguageToolkit(project));
        this.requestIfNotWaiting(indexRequest);
    }

    public void indexSourceModule(ISourceModule module, IDLTKLanguageToolkit toolkit) {
        this.request(new SourceModuleRequest(this, module, toolkit));
    }

    public void reconciled(ISourceModule workingCopy, IDLTKLanguageToolkit toolkit) {
    }

    public void removeProjectFragment(IScriptProject project, IPath sourceFolder) {
        this.requestIfNotWaiting(new ProjectRequest(this, project));
    }

    public void removeSourceModule(IScriptProject project, String path) {
        this.request(new SourceModuleRemoveRequest(this, project, path));
    }

    public void removeProject(IPath projectPath) {
        this.requestIfNotWaiting(new RemoveIndexRequest(this, projectPath));
    }

    public void removeLibrary(IScriptProject project, IPath path) {
        this.requestIfNotWaiting(new RemoveIndexRequest(this, path));
    }

    public void startIndexing() {
    }

    public boolean wantRefreshOnStart() {
        return true;
    }

    public void indexSourceModule(Index index, IDLTKLanguageToolkit toolkit, ISourceModule module, IPath containerPath) {
        IndexDocument document = new IndexDocument(toolkit, module, containerPath, index);
        index.remove(document.getContainerRelativePath());
        this.doIndexing(document);
    }

    public abstract void doIndexing(IndexDocument var1);

    public Index getProjectIndex(IScriptProject project) {
        return this.getIndexManager().getIndex(project.getProject().getFullPath(), true, true);
    }

    public Index getProjectFragmentIndex(IProjectFragment fragment) {
        return this.getIndexManager().getIndex(fragment.getPath(), true, true);
    }
}

