/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.scriptview;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.navigator.ProjectFragmentContainer;
import org.eclipse.dltk.internal.ui.scriptview.ScriptMessages;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.jface.resource.ImageDescriptor;

public class LibraryContainer
extends ProjectFragmentContainer {
    public LibraryContainer(IScriptProject project) {
        super(project);
    }

    public boolean equals(Object obj) {
        if (obj instanceof LibraryContainer) {
            LibraryContainer other = (LibraryContainer)obj;
            return this.getScriptProject().equals(other.getScriptProject());
        }
        return false;
    }

    public int hashCode() {
        return this.getScriptProject().hashCode();
    }

    public IAdaptable[] getChildren() {
        return this.getProjectFragments();
    }

    public ImageDescriptor getImageDescriptor() {
        return DLTKPluginImages.DESC_OBJS_LIBRARY;
    }

    public String getLabel() {
        return ScriptMessages.LibraryContainer_libraries;
    }

    public IProjectFragment[] getProjectFragments() {
        ArrayList<IProjectFragment> list = new ArrayList<IProjectFragment>();
        try {
            IProjectFragment[] roots = this.getScriptProject().getProjectFragments();
            int i = 0;
            while (i < roots.length) {
                int classpathEntryKind;
                IProjectFragment root = roots[i];
                IBuildpathEntry rawBuildpathEntry = root.getRawBuildpathEntry();
                if (rawBuildpathEntry != null && (classpathEntryKind = rawBuildpathEntry.getEntryKind()) == 1) {
                    list.add(root);
                }
                ++i;
            }
        }
        catch (ModelException modelException) {}
        return list.toArray(new IProjectFragment[list.size()]);
    }
}

