/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.formatter.internal.nodes;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.formatter.IFormatterContext;
import org.eclipse.dltk.formatter.IFormatterDocument;
import org.eclipse.dltk.formatter.IFormatterNode;
import org.eclipse.dltk.formatter.IFormatterWriter;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterBlockWithBeginEndNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.IBracketsConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BracketsNode
extends FormatterBlockWithBeginEndNode {
    private IBracketsConfiguration configuration;

    public BracketsNode(IFormatterDocument document, IBracketsConfiguration configuration) {
        super(document);
        Assert.isNotNull((Object)configuration);
        this.configuration = configuration;
    }

    @Override
    public void accept(IFormatterContext context, IFormatterWriter visitor) throws Exception {
        if (this.configuration.isBeginLineBreaking()) {
            visitor.writeLineBreak(context);
        }
        if (this.configuration.isBracketsIndenting()) {
            context.incIndent();
        }
        if (this.getBegin() != null) {
            IFormatterNode[] nodes = this.getBegin();
            int i = 0;
            while (i < nodes.length) {
                nodes[i].accept(context, visitor);
                ++i;
            }
        }
        this.acceptBody(context, visitor);
        if (this.configuration.isEndLineBreaking()) {
            visitor.writeLineBreak(context);
        }
        if (this.getEnd() != null) {
            visitor.write(context, this.getEnd().getStartOffset(), this.getEnd().getEndOffset());
        }
        if (this.configuration.isBracketsIndenting()) {
            context.decIndent();
        }
    }

    protected void acceptNodes(List<IFormatterNode> nodes, IFormatterContext context, IFormatterWriter visitor) throws Exception {
        if (this.isIndenting()) {
            context.incIndent();
        }
        super.acceptNodes(nodes, context, visitor);
        if (this.isIndenting()) {
            context.decIndent();
        }
    }

    @Override
    protected boolean isIndenting() {
        return this.configuration.isIndenting();
    }
}

