/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.dltk.internal.javascript.ti.ILazyValue;
import org.eclipse.dltk.internal.javascript.ti.IValue;
import org.eclipse.dltk.internal.javascript.ti.IValueProvider;
import org.eclipse.dltk.internal.javascript.ti.ImmutableValue;
import org.eclipse.dltk.internal.javascript.ti.ImmutableValueCollection;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencer2;
import org.eclipse.dltk.javascript.typeinference.IValueCollection;
import org.eclipse.dltk.javascript.typeinference.ReferenceKind;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.JSTypeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Value
extends ImmutableValue {
    @Override
    protected ITypeSystem getTypeSystem() {
        return TypeInferencer2.DELEGATING_TYPE_SYSTEM;
    }

    @Override
    public void setDeclaredType(IRType declaredType) {
        this.declaredType = declaredType;
    }

    @Override
    public void addType(IRType type) {
        if (type != null) {
            this.types.add(type);
        }
    }

    @Override
    public void setKind(ReferenceKind kind) {
        this.kind = kind;
    }

    @Override
    public void setLocation(ReferenceLocation location) {
        this.location = location;
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (value != null) {
            if (this.attributes == null) {
                this.attributes = new HashMap();
            }
            this.attributes.put(key, value);
        } else if (this.attributes != null) {
            this.attributes.remove(key);
        }
    }

    @Override
    public void deleteChild(String name) {
        if (this.deletedChildren == null) {
            this.deletedChildren = new HashSet();
        }
        this.deletedChildren.add(name);
    }

    @Override
    public void putChild(String name, IValue value) {
        this.inherited.put(name, value);
    }

    @Override
    public IValue createChild(String name, int flags) {
        IValue child = (IValue)this.children.get(name);
        if (child == null && (child = (IValue)this.inherited.get(name)) == null) {
            if ((flags & 1) == 0 && (child = this.findMember(name, false)) != null) {
                return child;
            }
            if (this.hasReferences()) {
                HashSet result = new HashSet();
                Value.execute(this, new CreateChildOperation(name), result, new HashSet<IValue>());
                if (!result.isEmpty()) {
                    return (IValue)result.iterator().next();
                }
            }
            child = new Value();
            this.children.put(name, (Value)child);
            this.childCreated(name);
        }
        return child;
    }

    @Override
    public void clear() {
        this.references.clear();
        this.children.clear();
        this.inherited.clear();
        this.types.clear();
    }

    @Override
    public void addValue(IValue src) {
        if (src instanceof ImmutableValue) {
            IdentityHashMap<ImmutableValue, ImmutableValue> processing = new IdentityHashMap<ImmutableValue, ImmutableValue>();
            this.addValueRecursive((ImmutableValue)src, processing, 0);
            for (Map.Entry<ImmutableValue, ImmutableValue> entry : processing.entrySet()) {
                ImmutableValue input = entry.getKey();
                ImmutableValue output = entry.getValue();
                for (IValue ref : input.references) {
                    IValue refOut = processing.get(ref);
                    if (refOut == null) {
                        refOut = ref;
                    }
                    output.references.add(refOut);
                }
            }
        } else {
            if (src.getDeclaredType() != null) {
                this.types.add(src.getDeclaredType());
            }
            this.types.addAll(src.getTypes());
            if (src.getKind() == ReferenceKind.METHOD) {
                IValue returnType;
                Object element = src.getAttribute("ELEMENT", false);
                if (element != null) {
                    this.setAttribute("ELEMENT", element);
                }
                if ((returnType = src.getChild("()", false)) != null) {
                    JSTypeSet myReturnTypes = this.createChild("()", 0).getTypes();
                    myReturnTypes.addAll(returnType.getTypes());
                    myReturnTypes.addAll(returnType.getDeclaredTypes());
                }
            }
        }
    }

    @Override
    public void addReference(IValue src) {
        assert (src != null);
        if (src == this) {
            return;
        }
        this.references.add(src);
    }

    private void addValueRecursive(ImmutableValue src, Map<ImmutableValue, ImmutableValue> processing, int depth) {
        if (!processing.containsKey(src)) {
            processing.put(src, this);
            if (depth > 8) {
                return;
            }
            if (src.declaredType != null) {
                this.types.add(src.declaredType);
            } else {
                this.types.addAll(src.types);
            }
            if (src.attributes != null) {
                if (this.attributes == null) {
                    this.attributes = new HashMap();
                }
                this.attributes.putAll(src.attributes);
            }
            for (Map.Entry<String, ImmutableValue> entry : src.children.entrySet()) {
                IValue child = this.createChild(entry.getKey(), 0);
                if (!(child instanceof Value)) continue;
                ((Value)child).addValueRecursive(entry.getValue(), processing, depth + 1);
            }
            if (src.kind != ReferenceKind.UNKNOWN && this.kind == ReferenceKind.UNKNOWN) {
                this.kind = src.kind;
            }
            if (src.location != ReferenceLocation.UNKNOWN && this.location == ReferenceLocation.UNKNOWN) {
                this.location = src.location;
            }
        }
    }

    public void putDirectChild(String name, ImmutableValue value) {
        this.children.put(name, value);
    }

    public void resolveLazyValues(Set<Value> visited) {
        if (visited.add(this)) {
            for (IValue value : this.references) {
                if (value instanceof ILazyValue && !((ILazyValue)((Object)value)).isResolved()) {
                    ((ILazyValue)((Object)value)).setFinalResolve();
                    continue;
                }
                if (!(value instanceof Value)) continue;
                ((Value)value).resolveLazyValues(visited);
            }
            for (IValue value : this.children.values()) {
                if (!(value instanceof Value)) continue;
                ((Value)value).resolveLazyValues(visited);
            }
            if (this.attributes != null) {
                for (Object attibute : this.attributes.values()) {
                    IValue value;
                    if (!(attibute instanceof IValueProvider) || !((value = ((IValueProvider)attibute).getValue()) instanceof Value)) continue;
                    ((Value)value).resolveLazyValues(visited);
                }
            }
        }
    }

    public ImmutableValue getImmutableValue(Map<Object, Object> visited) {
        ImmutableValue immutableValue = (ImmutableValue)visited.get(this);
        if (immutableValue != null) {
            return immutableValue;
        }
        if (this instanceof ILazyValue) {
            ((ILazyValue)((Object)this)).resolve();
        }
        JSTypeSet typeSet = JSTypeSet.create();
        typeSet.addAll(this.types);
        HashSet<String> deletedChilds = null;
        if (this.deletedChildren != null) {
            deletedChilds = new HashSet<String>(this.deletedChildren.size(), 0.9f);
            deletedChilds.addAll(this.deletedChildren);
        }
        HashMap<String, ImmutableValue> childs = new HashMap<String, ImmutableValue>(this.children.size(), 0.9f);
        HashMap<String, IValue> inherits = new HashMap<String, IValue>(this.inherited.size(), 0.9f);
        HashSet<IValue> refers = new HashSet<IValue>(this.references.size(), 0.9f);
        HashMap<String, Object> atts = null;
        if (this.attributes != null) {
            atts = new HashMap<String, Object>(this.attributes.size(), 0.9f);
            for (Map.Entry entry : this.attributes.entrySet()) {
                if (entry.getValue() instanceof Value) {
                    atts.put((String)entry.getKey(), ((Value)entry.getValue()).getImmutableValue(visited));
                    continue;
                }
                if (entry.getValue() instanceof IValueCollection) {
                    atts.put((String)entry.getKey(), ImmutableValueCollection.getImmutableValueCollection((IValueCollection)entry.getValue(), visited));
                    continue;
                }
                atts.put((String)entry.getKey(), entry.getValue());
            }
        }
        immutableValue = new ImmutableValue(this.declaredType, typeSet, deletedChilds, this.kind, this.location, childs, inherits, refers, atts);
        visited.put(this, immutableValue);
        for (IValue value : this.references) {
            if (value instanceof Value) {
                refers.add(((Value)value).getImmutableValue(visited));
                continue;
            }
            refers.add(value);
        }
        for (Map.Entry entry : this.children.entrySet()) {
            if (entry.getValue() instanceof Value) {
                childs.put((String)entry.getKey(), ((Value)entry.getValue()).getImmutableValue(visited));
                continue;
            }
            childs.put((String)entry.getKey(), (ImmutableValue)entry.getValue());
        }
        for (Map.Entry entry : this.inherited.entrySet()) {
            if (entry.getValue() instanceof Value) {
                inherits.put((String)entry.getKey(), ((Value)entry.getValue()).getImmutableValue(visited));
                continue;
            }
            inherits.put((String)entry.getKey(), (IValue)entry.getValue());
        }
        return immutableValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CreateChildOperation
    implements ImmutableValue.Handler<Set<IValue>> {
        private final String childName;

        public CreateChildOperation(String childName) {
            this.childName = childName;
        }

        @Override
        public void process(ImmutableValue value, Set<IValue> result) {
            if (result.isEmpty() && !value.hasReferences()) {
                result.add(value.createChild(this.childName, 0));
            }
        }
    }
}

