/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.index2.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.index2.search.ISearchRequestor;
import org.eclipse.dltk.core.index2.search.ModelAccess;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchDocument;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.core.search.matching.ModuleFactory;
import org.eclipse.dltk.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.SourceModule;
import org.eclipse.dltk.internal.core.search.matching.AndPattern;
import org.eclipse.dltk.internal.core.search.matching.FieldPattern;
import org.eclipse.dltk.internal.core.search.matching.MethodDeclarationPattern;
import org.eclipse.dltk.internal.core.search.matching.MethodPattern;
import org.eclipse.dltk.internal.core.search.matching.OrPattern;
import org.eclipse.dltk.internal.core.search.matching.TypeDeclarationPattern;
import org.eclipse.dltk.internal.core.search.matching.TypeReferencePattern;
import org.eclipse.dltk.internal.core.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewSearchEngine {
    private ISourceModule[] workingCopies;
    private WorkingCopyOwner workingCopyOwner;

    public void search(SearchPattern pattern, SearchParticipant[] participants, IDLTKSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        this.findMatches(pattern, participants, scope, requestor, monitor);
    }

    void findMatches(SearchPattern pattern, SearchParticipant[] participants, IDLTKSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (participants == null) {
            return;
        }
        int length = participants.length;
        if (monitor != null) {
            monitor.beginTask(Messages.engine_searching, 100 * length);
        }
        try {
            try {
                requestor.beginReporting();
                int i = 0;
                while (i < participants.length) {
                    block24: {
                        SearchParticipant participant = participants[i];
                        if (monitor != null && monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        try {
                            try {
                                if (monitor != null) {
                                    monitor.subTask(Messages.bind(Messages.engine_searching_indexing, new String[]{participant.getDescription()}));
                                }
                                participant.beginSearching();
                                requestor.enterParticipant(participant);
                                HashSet<String> indexMatchPathSet = new HashSet<String>();
                                this.collectPaths(pattern, scope, indexMatchPathSet, monitor);
                                String[] indexMatchPaths = indexMatchPathSet.toArray(new String[indexMatchPathSet.size()]);
                                if (monitor != null && monitor.isCanceled()) {
                                    throw new OperationCanceledException();
                                }
                                if (monitor != null) {
                                    monitor.subTask(Messages.bind(Messages.engine_searching_matching, new String[]{participant.getDescription()}));
                                }
                                if (indexMatchPaths.length != 0) {
                                    int indexMatchLength = indexMatchPaths.length;
                                    SearchDocument[] indexMatches = new SearchDocument[indexMatchLength];
                                    int j = 0;
                                    while (j < indexMatchLength) {
                                        indexMatches[j] = participant.getDocument(indexMatchPaths[j], null);
                                        ++j;
                                    }
                                    SearchDocument[] matches = ModuleFactory.addWorkingCopies(pattern, indexMatches, this.getWorkingCopies(), participant);
                                    HashSet<Path> paths = new HashSet<Path>();
                                    ArrayList<SearchDocument> filteredMatches = new ArrayList<SearchDocument>();
                                    int q = 0;
                                    while (q < matches.length) {
                                        Path path = new Path(matches[q].getPath());
                                        if (paths.add(path)) {
                                            filteredMatches.add(matches[q]);
                                        }
                                        ++q;
                                    }
                                    SearchDocument[] fmatches = filteredMatches.toArray(new SearchDocument[filteredMatches.size()]);
                                    participant.locateMatches(fmatches, pattern, scope, requestor, (IProgressMonitor)(monitor == null ? null : new SubProgressMonitor(monitor, 50)));
                                }
                            }
                            catch (Exception e) {
                                DLTKCore.error("An exception was thrown when locating matches", e);
                                requestor.exitParticipant(participant);
                                participant.doneSearching();
                                break block24;
                            }
                        }
                        catch (Throwable throwable) {
                            requestor.exitParticipant(participant);
                            participant.doneSearching();
                            throw throwable;
                        }
                        requestor.exitParticipant(participant);
                        participant.doneSearching();
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                DLTKCore.error("An exception was thrown when locating matches", e);
                requestor.endReporting();
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        finally {
            requestor.endReporting();
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected void collectPaths(SearchPattern pattern, IDLTKSearchScope scope, final Collection<String> paths, IProgressMonitor monitor) {
        ISearchEngine searchEngine;
        ISearchEngine.MatchRule matchRule;
        ISearchEngine.SearchFor searchFor;
        String elementName;
        String qualifier;
        int elementType;
        block8: {
            SearchPattern p;
            block12: {
                FieldPattern fieldPattern;
                block14: {
                    block13: {
                        block11: {
                            block10: {
                                block9: {
                                    block7: {
                                        elementType = 0;
                                        qualifier = null;
                                        elementName = null;
                                        searchFor = null;
                                        matchRule = null;
                                        if (!(pattern instanceof TypeDeclarationPattern)) break block7;
                                        elementType = 7;
                                        elementName = new String(((TypeDeclarationPattern)pattern).simpleName);
                                        matchRule = ModelAccess.convertSearchRule(pattern.getMatchRule());
                                        searchFor = ISearchEngine.SearchFor.DECLARATIONS;
                                        break block8;
                                    }
                                    if (!(pattern instanceof TypeReferencePattern)) break block9;
                                    elementType = 7;
                                    elementName = new String(((TypeReferencePattern)pattern).simpleName);
                                    matchRule = ModelAccess.convertSearchRule(pattern.getMatchRule());
                                    searchFor = ISearchEngine.SearchFor.REFERENCES;
                                    break block8;
                                }
                                if (!(pattern instanceof MethodDeclarationPattern)) break block10;
                                elementType = 9;
                                elementName = new String(((MethodDeclarationPattern)pattern).simpleName);
                                matchRule = ModelAccess.convertSearchRule(pattern.getMatchRule());
                                searchFor = ISearchEngine.SearchFor.DECLARATIONS;
                                break block8;
                            }
                            if (!(pattern instanceof MethodPattern)) break block11;
                            elementType = 9;
                            MethodPattern methodPattern = (MethodPattern)pattern;
                            elementName = new String(methodPattern.selector);
                            matchRule = ModelAccess.convertSearchRule(pattern.getMatchRule());
                            searchFor = ISearchEngine.SearchFor.REFERENCES;
                            break block8;
                        }
                        if (!(pattern instanceof FieldPattern)) break block12;
                        elementType = 8;
                        fieldPattern = (FieldPattern)pattern;
                        elementName = new String(fieldPattern.name);
                        matchRule = ModelAccess.convertSearchRule(pattern.getMatchRule());
                        if (!fieldPattern.findDeclarations || !fieldPattern.findReferences) break block13;
                        searchFor = ISearchEngine.SearchFor.ALL_OCCURRENCES;
                        break block8;
                    }
                    if (!fieldPattern.findDeclarations) break block14;
                    searchFor = ISearchEngine.SearchFor.DECLARATIONS;
                    break block8;
                }
                if (!fieldPattern.findReferences) break block8;
                searchFor = ISearchEngine.SearchFor.REFERENCES;
                break block8;
            }
            if (pattern instanceof AndPattern) {
                AndPattern andPattern = (AndPattern)pattern;
                do {
                    p = andPattern.currentPattern();
                    this.collectPaths(p, scope, paths, monitor);
                } while (andPattern.hasNextQuery());
            } else if (pattern instanceof OrPattern) {
                OrPattern orPattern = (OrPattern)pattern;
                SearchPattern[] searchPatternArray = orPattern.getPatterns();
                int n = searchPatternArray.length;
                int n2 = 0;
                while (n2 < n) {
                    p = searchPatternArray[n2];
                    this.collectPaths(p, scope, paths, monitor);
                    ++n2;
                }
            }
        }
        if (elementType > 0 && elementName != null && searchFor != null && matchRule != null && (searchEngine = ModelAccess.getSearchEngine(scope.getLanguageToolkit())) != null) {
            ISearchRequestor requestor = new ISearchRequestor(){

                public void match(int elementType, int flags, int offset, int length, int nameOffset, int nameLength, String elementName, String metadata, String doc, String qualifier, String parent, ISourceModule sourceModule, boolean isReference) {
                    paths.add(sourceModule.getPath().toString());
                }
            };
            searchEngine.search(elementType, qualifier, elementName, 0, 0, 0, searchFor, matchRule, scope, requestor, monitor);
            if (matchRule == ISearchEngine.MatchRule.CAMEL_CASE) {
                searchEngine.search(elementType, qualifier, elementName, 0, 0, 0, searchFor, ISearchEngine.MatchRule.PREFIX, scope, requestor, monitor);
            }
        }
    }

    private ISourceModule[] getWorkingCopies() {
        int length;
        ISourceModule[] copies;
        if (this.workingCopies != null) {
            if (this.workingCopyOwner == null) {
                copies = ModelManager.getModelManager().getWorkingCopies(DefaultWorkingCopyOwner.PRIMARY, false);
                if (copies == null) {
                    copies = this.workingCopies;
                } else {
                    ISourceModule unit;
                    HashMap<IPath, ISourceModule> pathToCUs = new HashMap<IPath, ISourceModule>();
                    int i = 0;
                    while (i < copies.length) {
                        unit = copies[i];
                        pathToCUs.put(unit.getPath(), unit);
                        ++i;
                    }
                    i = 0;
                    while (i < this.workingCopies.length) {
                        unit = this.workingCopies[i];
                        pathToCUs.put(unit.getPath(), unit);
                        ++i;
                    }
                    length = pathToCUs.size();
                    copies = new ISourceModule[length];
                    pathToCUs.values().toArray(copies);
                }
            } else {
                copies = this.workingCopies;
            }
        } else {
            copies = this.workingCopyOwner != null ? ModelManager.getModelManager().getWorkingCopies(this.workingCopyOwner, true) : ModelManager.getModelManager().getWorkingCopies(DefaultWorkingCopyOwner.PRIMARY, false);
        }
        if (copies == null) {
            return null;
        }
        ISourceModule[] result = null;
        length = copies.length;
        int index = 0;
        int i = 0;
        while (i < length) {
            SourceModule copy = (SourceModule)copies[i];
            try {
                if (!copy.isPrimary() || copy.hasUnsavedChanges() || copy.hasResourceChanged()) {
                    if (result == null) {
                        result = new ISourceModule[length];
                    }
                    result[index++] = copy;
                }
            }
            catch (ModelException modelException) {}
            ++i;
        }
        if (index != length && result != null) {
            ISourceModule[] iSourceModuleArray = result;
            result = new ISourceModule[index];
            System.arraycopy(iSourceModuleArray, 0, result, 0, index);
        }
        return result;
    }

    public boolean isEnabled(IDLTKLanguageToolkit toolkit) {
        return ModelAccess.getIndexerParticipant(toolkit) != null;
    }
}

