/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.BuildpathChange;
import org.eclipse.dltk.internal.core.BuildpathValidation;
import org.eclipse.dltk.internal.core.DeltaProcessingState;
import org.eclipse.dltk.internal.core.ExternalFolderChange;
import org.eclipse.dltk.internal.core.ModelElementDelta;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ModelOperation;
import org.eclipse.dltk.internal.core.ProjectReferenceChange;
import org.eclipse.dltk.internal.core.ScriptProject;

public abstract class ChangeBuildpathOperation
extends ModelOperation {
    protected final boolean canChangeResources;

    public ChangeBuildpathOperation(IModelElement[] elements, boolean canChangeResources) {
        super(elements);
        this.canChangeResources = canChangeResources;
    }

    protected boolean canModifyRoots() {
        return true;
    }

    protected void buildpathChanged(BuildpathChange change) throws ModelException {
        ScriptProject project = change.project;
        project.resetCaches();
        if (this.canChangeResources) {
            if (this.isTopLevelOperation() && !ResourcesPlugin.getWorkspace().isTreeLocked()) {
                new BuildpathValidation(project).validate();
            }
            new ProjectReferenceChange(project, change.oldResolvedBuildpath).updateProjectReferencesIfNecessary();
            new ExternalFolderChange(project, change.oldResolvedBuildpath).updateExternalFoldersIfNecessary(true, null);
        } else {
            DeltaProcessingState state = ModelManager.getDeltaState();
            ModelElementDelta delta = new ModelElementDelta(this.getModel());
            int result = change.generateDelta(delta, true);
            if ((result & BuildpathChange.HAS_DELTA) != 0) {
                this.addDelta(delta);
                state.rootsAreStale = true;
                change.requestIndexing();
                state.addBuildpathValidation(project);
            }
            if ((result & BuildpathChange.HAS_PROJECT_CHANGE) != 0) {
                state.addProjectReferenceChange(project, change.oldResolvedBuildpath);
            }
            if ((result & BuildpathChange.HAS_LIBRARY_CHANGE) != 0) {
                state.addExternalFolderChange(project, change.oldResolvedBuildpath);
            }
        }
    }

    protected ISchedulingRule getSchedulingRule() {
        return null;
    }

    public boolean isReadOnly() {
        return !this.canChangeResources;
    }
}

