/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.ISourceableBlock;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.Label;
import org.eclipse.dltk.javascript.ast.Statement;

public class LabelledStatement
extends Statement
implements ISourceableBlock {
    private Label label;
    private int colon = -1;
    private Statement statement;

    public LabelledStatement(JSNode parent) {
        super(parent);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            if (this.label != null) {
                this.label.traverse(visitor);
            }
            if (this.statement != null) {
                this.statement.traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public Label getLabel() {
        return this.label;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public int getColonPosition() {
        return this.colon;
    }

    public void setColonPosition(int colon) {
        this.colon = colon;
    }

    public String toSourceString(String indentationString) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(indentationString);
        buffer.append(LabelledStatement.toSourceString(this.label, indentationString));
        buffer.append(":\n");
        buffer.append(LabelledStatement.toSourceString(this.statement, String.valueOf(indentationString) + "    "));
        return buffer.toString();
    }

    public boolean isBlock() {
        return true;
    }
}

