/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceNode;
import org.eclipse.dltk.core.search.matching2.MatchingCollector;
import org.eclipse.dltk.internal.javascript.parser.structure.StructureReporter3;
import org.eclipse.dltk.internal.javascript.parser.structure.StructureRequestor;
import org.eclipse.dltk.internal.javascript.ti.JSDocSupport;
import org.eclipse.dltk.internal.javascript.ti.JSMethod;
import org.eclipse.dltk.internal.javascript.ti.JSVariable;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencer2;
import org.eclipse.dltk.javascript.ast.AbstractNavigationVisitor;
import org.eclipse.dltk.javascript.ast.Argument;
import org.eclipse.dltk.javascript.ast.Comment;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.JSDeclaration;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.JSScope;
import org.eclipse.dltk.javascript.ast.Method;
import org.eclipse.dltk.javascript.ast.ObjectInitializer;
import org.eclipse.dltk.javascript.ast.ObjectInitializerPart;
import org.eclipse.dltk.javascript.ast.PropertyExpression;
import org.eclipse.dltk.javascript.ast.PropertyInitializer;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.ast.VariableDeclaration;
import org.eclipse.dltk.javascript.core.JSBindings;
import org.eclipse.dltk.javascript.internal.core.TemporaryBindings;
import org.eclipse.dltk.javascript.internal.search.ArgumentDeclarationNode;
import org.eclipse.dltk.javascript.internal.search.FieldDeclarationNode;
import org.eclipse.dltk.javascript.internal.search.FieldReferenceNode;
import org.eclipse.dltk.javascript.internal.search.LocalVariableDeclarationNode;
import org.eclipse.dltk.javascript.internal.search.LocalVariableReferenceNode;
import org.eclipse.dltk.javascript.internal.search.MatchingNode;
import org.eclipse.dltk.javascript.internal.search.MethodDeclarationNode;
import org.eclipse.dltk.javascript.internal.search.MethodReferenceNode;
import org.eclipse.dltk.javascript.internal.search.TypeReferenceNode;
import org.eclipse.dltk.javascript.parser.JSProblemReporter;
import org.eclipse.dltk.javascript.parser.jsdoc.JSDocTag;
import org.eclipse.dltk.javascript.parser.jsdoc.JSDocTags;
import org.eclipse.dltk.javascript.search.IMatchLocatorHandler;
import org.eclipse.dltk.javascript.search.IMatchLocatorValue;
import org.eclipse.dltk.javascript.search.IMatchLocatorVisitor;
import org.eclipse.dltk.javascript.structure.FunctionDeclaration;
import org.eclipse.dltk.javascript.structure.FunctionExpression;
import org.eclipse.dltk.javascript.structure.FunctionNode;
import org.eclipse.dltk.javascript.structure.IDeclaration;
import org.eclipse.dltk.javascript.structure.IScope;
import org.eclipse.dltk.javascript.structure.ScriptScope;
import org.eclipse.dltk.javascript.structure.VariableNode;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.ITypeChecker;
import org.eclipse.dltk.javascript.typeinfo.ReferenceSource;
import org.eclipse.dltk.javascript.typeinfo.TypeInfoManager;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptMatchLocatorVisitor
extends AbstractNavigationVisitor<IMatchLocatorValue>
implements IMatchLocatorVisitor {
    private final ReferenceSource referenceSource;
    private final IMatchLocatorHandler[] handlers;
    private JSDocSupport jsdocSupport = new JSDocSupport();
    private final JSProblemReporter fReporter = null;
    private final ITypeChecker fTypeChecker = null;
    private final Stack<IScope> scopes = new Stack();
    private final List<MatchingNode> nodes = new ArrayList<MatchingNode>();

    public JavaScriptMatchLocatorVisitor(ReferenceSource referenceSource) {
        this.referenceSource = referenceSource;
        List<IMatchLocatorHandler> extensions = TypeInfoManager.createExtensions(referenceSource, IMatchLocatorHandler.class, this);
        this.handlers = extensions.toArray(new IMatchLocatorHandler[extensions.size()]);
    }

    public void resolveMatchingNodes(TypeInferencer2 inferencer2, Script script, ISourceModule module) {
        if (this.needsResolve()) {
            final ArrayList tmpNodes = new ArrayList();
            final JSBindings bindings = TemporaryBindings.build(inferencer2, module, script);
            bindings.run(new Runnable(){

                public void run() {
                    for (MatchingNode node : JavaScriptMatchLocatorVisitor.this.nodes) {
                        tmpNodes.add(node.resolvePotentialMatch(bindings));
                    }
                }
            });
            this.nodes.clear();
            this.nodes.addAll(tmpNodes);
        }
    }

    private boolean needsResolve() {
        for (MatchingNode node : this.nodes) {
            if (!node.needsResolve()) continue;
            return true;
        }
        return false;
    }

    public void report(MatchingCollector<MatchingNode> matchingCollector) {
        for (MatchingNode node : this.nodes) {
            matchingCollector.report((Object)node);
        }
        this.nodes.clear();
    }

    public IMatchLocatorValue visit(ASTNode node) {
        IMatchLocatorHandler[] iMatchLocatorHandlerArray = this.handlers;
        int n = this.handlers.length;
        int n2 = 0;
        while (n2 < n) {
            IMatchLocatorHandler handler = iMatchLocatorHandlerArray[n2];
            IMatchLocatorValue value = handler.handle(node);
            if (value != IMatchLocatorHandler.CONTINUE) {
                return value;
            }
            ++n2;
        }
        return (IMatchLocatorValue)super.visit(node);
    }

    private void push(IScope scope) {
        this.scopes.push(scope);
    }

    private IScope pop() {
        return this.scopes.pop();
    }

    private IScope peek() {
        return this.scopes.peek();
    }

    public IMatchLocatorValue visitScript(Script node) {
        this.scopes.clear();
        this.push(new ScriptScope());
        this.handleScopeDeclarations((JSScope)node);
        super.visitScript(node);
        this.pop();
        return null;
    }

    public IMatchLocatorValue visitFunctionStatement(FunctionStatement node) {
        return this.createFunctionDeclaration(node, node.getName());
    }

    private IMatchLocatorValue createFunctionDeclaration(FunctionStatement node, Identifier name) {
        JSMethod method = new JSMethod(node, this.referenceSource);
        this.jsdocSupport.processMethod(node, method, this.fReporter, this.fTypeChecker);
        FunctionNode functionNode = node.isDeclaration() ? new FunctionDeclaration(this.peek(), node, method) : new FunctionExpression(this.peek(), node, method);
        method.setLocation(ReferenceLocation.create(this.referenceSource, node.start(), node.end(), functionNode.getNameNode()));
        functionNode.buildArgumentNodes();
        this.push(functionNode);
        this.addFunctionDeclaration((Expression)name, node, method);
        this.visitFunctionBody(node);
        this.pop();
        return null;
    }

    @Override
    public void visitFunctionBody(FunctionStatement function) {
        this.handleScopeDeclarations((JSScope)function);
        super.visitFunctionStatement(function);
    }

    @Override
    public void addFunctionDeclaration(Expression identifier, FunctionStatement function, IModelBuilder.IMethod method) {
        this.nodes.add(new MethodDeclarationNode((Expression)(identifier != null ? identifier : function), method));
        HashMap<String, Argument> arguments = new HashMap<String, Argument>();
        for (Argument argument : function.getArguments()) {
            arguments.put(argument.getIdentifier().getName(), argument);
        }
        for (IModelBuilder.IParameter parameter : method.getParameters()) {
            Argument argument = (Argument)arguments.get(parameter.getName());
            if (argument == null) continue;
            this.nodes.add(new ArgumentDeclarationNode(argument, method.getLocation().getSourceModule(), parameter.getType()));
        }
        Comment comment = JSDocSupport.getComment((JSNode)function);
        if (comment != null) {
            JSDocTags tags = JSDocSupport.parse(comment);
            for (JSDocTag tag : tags.list("@param")) {
                IModelBuilder.IParameter parameter;
                JSDocSupport.ParameterNode node = JSDocSupport.parseParameter(tag);
                if (node == null || (parameter = method.getParameter(node.name)) == null) continue;
                Identifier ref = new Identifier(null);
                ref.setName(node.name);
                int start = tag.fromValueOffset(node.offset);
                ref.setStart(start);
                ref.setEnd(start + node.name.length());
                this.nodes.add(new LocalVariableReferenceNode(ref, parameter.getLocation(), true));
            }
        }
    }

    @Override
    public void addFieldDeclaration(Expression identifier, JSType type) {
        this.nodes.add(new FieldDeclarationNode(identifier, this.referenceSource.getSourceModule(), type));
    }

    private void handleScopeDeclarations(JSScope scope) {
        for (JSDeclaration declaration : scope.getDeclarations()) {
            if (declaration instanceof VariableDeclaration) {
                this.createVariable((VariableDeclaration)declaration);
                continue;
            }
            boolean cfr_ignored_0 = declaration instanceof FunctionStatement;
        }
    }

    private void createVariable(VariableDeclaration declaration) {
        JSVariable variable = new JSVariable(declaration.getVariableName());
        variable.setLocation(declaration.getInitializer() != null ? ReferenceLocation.create(this.referenceSource, declaration.start(), declaration.end(), (ISourceNode)declaration.getIdentifier()) : ReferenceLocation.create(this.referenceSource, declaration.start(), declaration.end()));
        this.jsdocSupport.processVariable(declaration, variable, this.fReporter, this.fTypeChecker);
        VariableNode variableNode = new VariableNode(this.peek(), declaration, variable);
        this.peek().addChild(variableNode);
        if (this.scopes.size() == 1) {
            this.addFieldDeclaration((Expression)declaration.getIdentifier(), variable.getType());
        } else {
            this.nodes.add(new LocalVariableDeclarationNode(declaration.getIdentifier(), this.referenceSource.getSourceModule(), variable.getType()));
        }
    }

    public IMatchLocatorValue visitPropertyExpression(PropertyExpression node) {
        this.visit((ASTNode)node.getObject());
        Expression property = node.getProperty();
        if (property instanceof Identifier) {
            Identifier identifier = (Identifier)property;
            if (StructureReporter3.isCallExpression((Expression)node)) {
                this.nodes.add(new MethodReferenceNode(identifier));
            } else {
                this.nodes.add(new FieldReferenceNode(identifier));
            }
        } else {
            this.visit((ASTNode)property);
        }
        return null;
    }

    public IMatchLocatorValue visitIdentifier(Identifier node) {
        String name = node.getName();
        IDeclaration resolved = this.peek().resolve(name);
        if (resolved != null) {
            if (resolved.getParent() instanceof ScriptScope) {
                if (resolved instanceof FunctionNode) {
                    this.nodes.add(new MethodReferenceNode(node, resolved.getLocation()));
                } else {
                    this.nodes.add(new FieldReferenceNode(node, resolved.getLocation()));
                }
            } else {
                this.nodes.add(new LocalVariableReferenceNode(node, resolved.getLocation()));
            }
        } else if (StructureReporter3.isCallExpression((Expression)node)) {
            this.nodes.add(new MethodReferenceNode(node));
        } else {
            this.nodes.add(new FieldReferenceNode(node));
        }
        return null;
    }

    public IMatchLocatorValue visitObjectInitializer(ObjectInitializer node) {
        for (ObjectInitializerPart part : node.getInitializers()) {
            if (part instanceof Method) {
                this.visitMethod((Method)part);
                continue;
            }
            if (!(part instanceof PropertyInitializer)) continue;
            PropertyInitializer pi = (PropertyInitializer)part;
            if (pi.getValue() instanceof FunctionStatement) {
                this.createFunctionDeclaration((FunctionStatement)pi.getValue(), (Identifier)pi.getName());
                continue;
            }
            this.addFieldDeclaration(pi.getName(), null);
            this.visit((ASTNode)pi.getValue());
        }
        return null;
    }

    @Override
    public void acceptTypeReference(ASTNode node, String typeName) {
        this.nodes.add(new TypeReferenceNode(node, typeName));
    }

    @Override
    public void acceptTypeReference(ASTNode node, JSType type) {
        this.nodes.add(new TypeReferenceNode(node, StructureRequestor.collectContainedTypeNames(type)));
    }
}

