/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.RTypes;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelPackage;
import org.eclipse.dltk.javascript.typeinfo.model.UnionType;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionTypeImpl
extends MinimalEObjectImpl
implements UnionType {
    protected EList<JSType> targets;

    protected UnionTypeImpl() {
    }

    protected EClass eStaticClass() {
        return TypeInfoModelPackage.Literals.UNION_TYPE;
    }

    @Override
    public EList<JSType> getTargets() {
        if (this.targets == null) {
            this.targets = new EObjectContainmentEList(JSType.class, (InternalEObject)this, 0);
        }
        return this.targets;
    }

    @Override
    public String getName() {
        if (this.targets != null && !this.targets.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (JSType type : this.targets) {
                if (sb.length() != 0) {
                    sb.append('|');
                }
                sb.append(type.getName());
            }
            return sb.toString();
        }
        return "";
    }

    @Override
    public IRType toRType(ITypeSystem typeSystem) {
        if (this.targets == null || this.targets.isEmpty()) {
            return RTypes.none();
        }
        ArrayList<IRType> targets = new ArrayList<IRType>(this.targets.size());
        for (JSType type : this.targets) {
            targets.add(RTypes.create(typeSystem, type));
        }
        return RTypes.union(targets);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getTargets()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getTargets();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getTargets().clear();
                this.getTargets().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getTargets().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.targets != null && !this.targets.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }
}

