/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.javascript.ast.Argument;
import org.eclipse.dltk.javascript.ast.ArrayInitializer;
import org.eclipse.dltk.javascript.ast.AsteriskExpression;
import org.eclipse.dltk.javascript.ast.BinaryOperation;
import org.eclipse.dltk.javascript.ast.BooleanLiteral;
import org.eclipse.dltk.javascript.ast.BreakStatement;
import org.eclipse.dltk.javascript.ast.CallExpression;
import org.eclipse.dltk.javascript.ast.CaseClause;
import org.eclipse.dltk.javascript.ast.CatchClause;
import org.eclipse.dltk.javascript.ast.CommaExpression;
import org.eclipse.dltk.javascript.ast.ConditionalOperator;
import org.eclipse.dltk.javascript.ast.ConstStatement;
import org.eclipse.dltk.javascript.ast.ContinueStatement;
import org.eclipse.dltk.javascript.ast.DecimalLiteral;
import org.eclipse.dltk.javascript.ast.DefaultClause;
import org.eclipse.dltk.javascript.ast.DefaultXmlNamespaceStatement;
import org.eclipse.dltk.javascript.ast.DoWhileStatement;
import org.eclipse.dltk.javascript.ast.EmptyExpression;
import org.eclipse.dltk.javascript.ast.EmptyStatement;
import org.eclipse.dltk.javascript.ast.ErrorExpression;
import org.eclipse.dltk.javascript.ast.FinallyClause;
import org.eclipse.dltk.javascript.ast.ForEachInStatement;
import org.eclipse.dltk.javascript.ast.ForInStatement;
import org.eclipse.dltk.javascript.ast.ForStatement;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.GetAllChildrenExpression;
import org.eclipse.dltk.javascript.ast.GetArrayItemExpression;
import org.eclipse.dltk.javascript.ast.GetLocalNameExpression;
import org.eclipse.dltk.javascript.ast.GetMethod;
import org.eclipse.dltk.javascript.ast.INodeVisitor;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.IfStatement;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.JSUserNode;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.LabelledStatement;
import org.eclipse.dltk.javascript.ast.NewExpression;
import org.eclipse.dltk.javascript.ast.NullExpression;
import org.eclipse.dltk.javascript.ast.ObjectInitializer;
import org.eclipse.dltk.javascript.ast.ParenthesizedExpression;
import org.eclipse.dltk.javascript.ast.PropertyExpression;
import org.eclipse.dltk.javascript.ast.PropertyInitializer;
import org.eclipse.dltk.javascript.ast.RegExpLiteral;
import org.eclipse.dltk.javascript.ast.ReturnStatement;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.ast.SetMethod;
import org.eclipse.dltk.javascript.ast.StatementBlock;
import org.eclipse.dltk.javascript.ast.StringLiteral;
import org.eclipse.dltk.javascript.ast.SwitchStatement;
import org.eclipse.dltk.javascript.ast.ThisExpression;
import org.eclipse.dltk.javascript.ast.ThrowStatement;
import org.eclipse.dltk.javascript.ast.TryStatement;
import org.eclipse.dltk.javascript.ast.UnaryOperation;
import org.eclipse.dltk.javascript.ast.VariableDeclaration;
import org.eclipse.dltk.javascript.ast.VariableStatement;
import org.eclipse.dltk.javascript.ast.VoidExpression;
import org.eclipse.dltk.javascript.ast.WhileStatement;
import org.eclipse.dltk.javascript.ast.WithStatement;
import org.eclipse.dltk.javascript.ast.XmlAttributeIdentifier;
import org.eclipse.dltk.javascript.ast.XmlLiteral;
import org.eclipse.dltk.javascript.ast.YieldOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ASTVisitor<E>
implements INodeVisitor<E> {
    private static final Map<Class<? extends ASTNode>, Integer> HANDLERS = new HashMap<Class<? extends ASTNode>, Integer>();

    static {
        HANDLERS.put(ArrayInitializer.class, 0);
        HANDLERS.put(BinaryOperation.class, 1);
        HANDLERS.put(BooleanLiteral.class, 2);
        HANDLERS.put(BreakStatement.class, 3);
        HANDLERS.put(CallExpression.class, 4);
        HANDLERS.put(CommaExpression.class, 5);
        HANDLERS.put(ConditionalOperator.class, 6);
        HANDLERS.put(ConstStatement.class, 7);
        HANDLERS.put(ContinueStatement.class, 8);
        HANDLERS.put(DecimalLiteral.class, 9);
        HANDLERS.put(DoWhileStatement.class, 10);
        HANDLERS.put(EmptyExpression.class, 11);
        HANDLERS.put(ForStatement.class, 12);
        HANDLERS.put(ForInStatement.class, 13);
        HANDLERS.put(ForEachInStatement.class, 14);
        HANDLERS.put(FunctionStatement.class, 15);
        HANDLERS.put(GetArrayItemExpression.class, 16);
        HANDLERS.put(Identifier.class, 17);
        HANDLERS.put(IfStatement.class, 18);
        HANDLERS.put(LabelledStatement.class, 19);
        HANDLERS.put(NewExpression.class, 20);
        HANDLERS.put(NullExpression.class, 21);
        HANDLERS.put(ObjectInitializer.class, 22);
        HANDLERS.put(ParenthesizedExpression.class, 23);
        HANDLERS.put(PropertyExpression.class, 24);
        HANDLERS.put(RegExpLiteral.class, 25);
        HANDLERS.put(ReturnStatement.class, 26);
        HANDLERS.put(Script.class, 27);
        HANDLERS.put(StatementBlock.class, 28);
        HANDLERS.put(StringLiteral.class, 29);
        HANDLERS.put(SwitchStatement.class, 30);
        HANDLERS.put(ThisExpression.class, 31);
        HANDLERS.put(ThrowStatement.class, 32);
        HANDLERS.put(TryStatement.class, 33);
        HANDLERS.put(UnaryOperation.class, 34);
        HANDLERS.put(VariableStatement.class, 35);
        HANDLERS.put(VoidExpression.class, 36);
        HANDLERS.put(YieldOperator.class, 37);
        HANDLERS.put(WhileStatement.class, 38);
        HANDLERS.put(WithStatement.class, 39);
        HANDLERS.put(XmlLiteral.class, 40);
        HANDLERS.put(DefaultXmlNamespaceStatement.class, 41);
        HANDLERS.put(XmlAttributeIdentifier.class, 42);
        HANDLERS.put(AsteriskExpression.class, 43);
        HANDLERS.put(GetAllChildrenExpression.class, 44);
        HANDLERS.put(GetLocalNameExpression.class, 45);
        HANDLERS.put(ErrorExpression.class, 46);
        HANDLERS.put(EmptyStatement.class, 47);
    }

    public E visit(Collection<? extends ASTNode> nodes) {
        E result = null;
        for (ASTNode aSTNode : nodes) {
            result = this.visit(aSTNode);
        }
        return result;
    }

    protected void visitList(Collection<? extends ASTNode> nodes) {
        for (ASTNode aSTNode : nodes) {
            this.visit(aSTNode);
        }
    }

    private final E handle(ASTNode node, int handlerIndex) {
        switch (handlerIndex) {
            case 0: {
                return this.visitArrayInitializer((ArrayInitializer)node);
            }
            case 1: {
                return this.visitBinaryOperation((BinaryOperation)node);
            }
            case 2: {
                return this.visitBooleanLiteral((BooleanLiteral)node);
            }
            case 3: {
                return this.visitBreakStatement((BreakStatement)node);
            }
            case 4: {
                return this.visitCallExpression((CallExpression)node);
            }
            case 5: {
                return this.visitCommaExpression((CommaExpression)node);
            }
            case 6: {
                return this.visitConditionalOperator((ConditionalOperator)node);
            }
            case 7: {
                return this.visitConstDeclaration((ConstStatement)node);
            }
            case 8: {
                return this.visitContinueStatement((ContinueStatement)node);
            }
            case 9: {
                return this.visitDecimalLiteral((DecimalLiteral)node);
            }
            case 10: {
                return this.visitDoWhileStatement((DoWhileStatement)node);
            }
            case 11: {
                return this.visitEmptyExpression((EmptyExpression)node);
            }
            case 12: {
                return this.visitForStatement((ForStatement)node);
            }
            case 13: {
                return this.visitForInStatement((ForInStatement)node);
            }
            case 14: {
                return this.visitForEachInStatement((ForEachInStatement)node);
            }
            case 15: {
                return this.visitFunctionStatement((FunctionStatement)node);
            }
            case 16: {
                return this.visitGetArrayItemExpression((GetArrayItemExpression)node);
            }
            case 17: {
                return this.visitIdentifier((Identifier)node);
            }
            case 18: {
                return this.visitIfStatement((IfStatement)node);
            }
            case 19: {
                return this.visitLabelledStatement((LabelledStatement)node);
            }
            case 20: {
                return this.visitNewExpression((NewExpression)node);
            }
            case 21: {
                return this.visitNullExpression((NullExpression)node);
            }
            case 22: {
                return this.visitObjectInitializer((ObjectInitializer)node);
            }
            case 23: {
                return this.visitParenthesizedExpression((ParenthesizedExpression)node);
            }
            case 24: {
                return this.visitPropertyExpression((PropertyExpression)node);
            }
            case 25: {
                return this.visitRegExpLiteral((RegExpLiteral)node);
            }
            case 26: {
                return this.visitReturnStatement((ReturnStatement)node);
            }
            case 27: {
                return this.visitScript((Script)node);
            }
            case 28: {
                return this.visitStatementBlock((StatementBlock)node);
            }
            case 29: {
                return this.visitStringLiteral((StringLiteral)node);
            }
            case 30: {
                return this.visitSwitchStatement((SwitchStatement)node);
            }
            case 31: {
                return this.visitThisExpression((ThisExpression)node);
            }
            case 32: {
                return this.visitThrowStatement((ThrowStatement)node);
            }
            case 33: {
                return this.visitTryStatement((TryStatement)node);
            }
            case 34: {
                return this.visitUnaryOperation((UnaryOperation)node);
            }
            case 35: {
                return this.visitVariableStatement((VariableStatement)node);
            }
            case 36: {
                return this.visitVoidExpression((VoidExpression)node);
            }
            case 37: {
                return this.visitYieldOperator((YieldOperator)node);
            }
            case 38: {
                return this.visitWhileStatement((WhileStatement)node);
            }
            case 39: {
                return this.visitWithStatement((WithStatement)node);
            }
            case 40: {
                return this.visitXmlLiteral((XmlLiteral)node);
            }
            case 41: {
                return this.visitDefaultXmlNamespace((DefaultXmlNamespaceStatement)node);
            }
            case 42: {
                return this.visitXmlPropertyIdentifier((XmlAttributeIdentifier)node);
            }
            case 43: {
                return this.visitAsteriskExpression((AsteriskExpression)node);
            }
            case 44: {
                return this.visitGetAllChildrenExpression((GetAllChildrenExpression)node);
            }
            case 45: {
                return this.visitGetLocalNameExpression((GetLocalNameExpression)node);
            }
            case 46: {
                return this.visitErrorExpression((ErrorExpression)node);
            }
            case 47: {
                return this.visitEmptyStatement((EmptyStatement)node);
            }
        }
        return this.visitUnknownNode(node);
    }

    @Override
    public E visit(ASTNode node) {
        JSNode original;
        if (node == null) {
            return null;
        }
        Integer handler = HANDLERS.get(node.getClass());
        if (handler != null) {
            return this.handle(node, handler);
        }
        if (node instanceof JSUserNode && (original = ((JSUserNode)node).getOriginal()) != null && (handler = HANDLERS.get(((Object)((Object)original)).getClass())) != null) {
            return this.handle(original, handler);
        }
        return this.visitUnknownNode(node);
    }

    public abstract E visitArrayInitializer(ArrayInitializer var1);

    public abstract E visitBinaryOperation(BinaryOperation var1);

    public abstract E visitBooleanLiteral(BooleanLiteral var1);

    public abstract E visitBreakStatement(BreakStatement var1);

    public abstract E visitCallExpression(CallExpression var1);

    @Deprecated
    public final E visitCaseClause(CaseClause node) {
        return null;
    }

    @Deprecated
    public final E visitCatchClause(CatchClause node) {
        return null;
    }

    public abstract E visitCommaExpression(CommaExpression var1);

    public abstract E visitConditionalOperator(ConditionalOperator var1);

    public abstract E visitConstDeclaration(ConstStatement var1);

    public abstract E visitContinueStatement(ContinueStatement var1);

    public abstract E visitDecimalLiteral(DecimalLiteral var1);

    @Deprecated
    public final E visitDefaultClause(DefaultClause node) {
        return null;
    }

    public abstract E visitDoWhileStatement(DoWhileStatement var1);

    public abstract E visitEmptyExpression(EmptyExpression var1);

    @Deprecated
    public final E visitFinallyClause(FinallyClause node) {
        return null;
    }

    public abstract E visitForStatement(ForStatement var1);

    public abstract E visitForInStatement(ForInStatement var1);

    public abstract E visitForEachInStatement(ForEachInStatement var1);

    public abstract E visitFunctionStatement(FunctionStatement var1);

    @Deprecated
    public final E visitArgument(Argument argument) {
        return null;
    }

    public abstract E visitGetArrayItemExpression(GetArrayItemExpression var1);

    @Deprecated
    public final E visitGetMethod(GetMethod node) {
        return null;
    }

    public abstract E visitIdentifier(Identifier var1);

    public abstract E visitIfStatement(IfStatement var1);

    @Deprecated
    public final E visitKeyword(Keyword node) {
        return null;
    }

    public abstract E visitLabelledStatement(LabelledStatement var1);

    public abstract E visitNewExpression(NewExpression var1);

    public abstract E visitNullExpression(NullExpression var1);

    public abstract E visitObjectInitializer(ObjectInitializer var1);

    public abstract E visitParenthesizedExpression(ParenthesizedExpression var1);

    public abstract E visitPropertyExpression(PropertyExpression var1);

    @Deprecated
    public final E visitPropertyInitializer(PropertyInitializer node) {
        return null;
    }

    public abstract E visitRegExpLiteral(RegExpLiteral var1);

    public abstract E visitReturnStatement(ReturnStatement var1);

    public abstract E visitScript(Script var1);

    @Deprecated
    public final E visitSetMethod(SetMethod node) {
        return null;
    }

    public abstract E visitStatementBlock(StatementBlock var1);

    public abstract E visitStringLiteral(StringLiteral var1);

    public abstract E visitSwitchStatement(SwitchStatement var1);

    public abstract E visitThisExpression(ThisExpression var1);

    public abstract E visitThrowStatement(ThrowStatement var1);

    public abstract E visitTryStatement(TryStatement var1);

    public abstract E visitUnaryOperation(UnaryOperation var1);

    public abstract E visitVariableStatement(VariableStatement var1);

    @Deprecated
    public final E visitVariableDeclaration(VariableDeclaration node) {
        return null;
    }

    public abstract E visitVoidExpression(VoidExpression var1);

    public abstract E visitYieldOperator(YieldOperator var1);

    public abstract E visitWhileStatement(WhileStatement var1);

    public abstract E visitWithStatement(WithStatement var1);

    public abstract E visitXmlLiteral(XmlLiteral var1);

    public abstract E visitDefaultXmlNamespace(DefaultXmlNamespaceStatement var1);

    public abstract E visitXmlPropertyIdentifier(XmlAttributeIdentifier var1);

    public abstract E visitAsteriskExpression(AsteriskExpression var1);

    public abstract E visitGetAllChildrenExpression(GetAllChildrenExpression var1);

    public abstract E visitGetLocalNameExpression(GetLocalNameExpression var1);

    public E visitErrorExpression(ErrorExpression node) {
        return null;
    }

    public abstract E visitEmptyStatement(EmptyStatement var1);

    public E visitUnknownNode(ASTNode node) {
        throw new UnsupportedOperationException("Unknown node type: " + node.getClass().getName());
    }
}

