/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.wizards.buildpath;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.util.CoreUtility;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPVariableElement;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPVariableElementLabelProvider;
import org.eclipse.dltk.internal.ui.wizards.buildpath.VariableCreationDialog;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class VariableBlock {
    private final ListDialogField fVariablesList;
    private Control fControl;
    private CLabel fWarning;
    private boolean fHasChanges;
    private List fSelectedElements = new ArrayList(0);
    private boolean fAskToBuild;
    private final boolean fEditOnDoubleclick;

    public VariableBlock(boolean inPreferencePage, String initSelection) {
        this.fEditOnDoubleclick = inPreferencePage;
        this.fAskToBuild = true;
        String[] buttonLabels = new String[]{NewWizardMessages.VariableBlock_vars_add_button, NewWizardMessages.VariableBlock_vars_edit_button, NewWizardMessages.VariableBlock_vars_remove_button};
        VariablesAdapter adapter = new VariablesAdapter();
        BPVariableElementLabelProvider labelProvider = new BPVariableElementLabelProvider(inPreferencePage);
        this.fVariablesList = new ListDialogField(adapter, buttonLabels, (ILabelProvider)labelProvider);
        this.fVariablesList.setDialogFieldListener(adapter);
        this.fVariablesList.setLabelText(NewWizardMessages.VariableBlock_vars_label);
        this.fVariablesList.setRemoveButtonIndex(2);
        this.fVariablesList.enableButton(1, false);
        this.refresh(initSelection);
    }

    public boolean hasChanges() {
        return this.fHasChanges;
    }

    public void setChanges(boolean hasChanges) {
        this.fHasChanges = hasChanges;
    }

    public Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fVariablesList}, true, 0, 0);
        LayoutUtil.setHorizontalGrabbing(this.fVariablesList.getListControl(null));
        this.fWarning = new CLabel(composite, 0);
        this.fWarning.setLayoutData((Object)new GridData(4, 128, true, false, this.fVariablesList.getNumberOfControls() - 1, 1));
        this.fControl = composite;
        return composite;
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        this.fVariablesList.getTableViewer().addDoubleClickListener(listener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fVariablesList.getTableViewer().addSelectionChangedListener(listener);
    }

    private Shell getShell() {
        if (this.fControl != null) {
            return this.fControl.getShell();
        }
        return DLTKUIPlugin.getActiveWorkbenchShell();
    }

    private boolean containsReadOnly(List selected) {
        int i = selected.size() - 1;
        while (i >= 0) {
            if (((BPVariableElement)selected.get(i)).isReadOnly()) {
                return true;
            }
            --i;
        }
        return false;
    }

    private boolean canEdit(List selected, boolean containsReadOnly) {
        return selected.size() == 1 && !containsReadOnly;
    }

    private void doSelectionChanged(DialogField field) {
        List selected = this.fVariablesList.getSelectedElements();
        boolean containsReadOnly = this.containsReadOnly(selected);
        this.fVariablesList.enableButton(1, this.canEdit(selected, containsReadOnly));
        this.fVariablesList.enableButton(2, !containsReadOnly);
        this.fSelectedElements = selected;
    }

    private void editEntries(BPVariableElement entry) {
        List existingEntries = this.fVariablesList.getElements();
        VariableCreationDialog dialog = new VariableCreationDialog(this.getShell(), entry, existingEntries);
        if (dialog.open() != 0) {
            return;
        }
        BPVariableElement newEntry = dialog.getBuildpathElement();
        if (entry == null) {
            this.fVariablesList.addElement(newEntry);
            entry = newEntry;
            this.fHasChanges = true;
        } else {
            boolean hasChanges;
            boolean bl = hasChanges = !entry.getName().equals(newEntry.getName()) || !entry.getPath().equals((Object)newEntry.getPath());
            if (hasChanges) {
                this.fHasChanges = true;
                entry.setName(newEntry.getName());
                entry.setPath(newEntry.getPath());
                this.fVariablesList.refresh();
            }
        }
        this.fVariablesList.selectElements((ISelection)new StructuredSelection((Object)entry));
    }

    public List getSelectedElements() {
        return this.fSelectedElements;
    }

    public boolean performOk() {
        ArrayList<String> removedVariables = new ArrayList<String>();
        ArrayList<String> changedVariables = new ArrayList<String>();
        removedVariables.addAll(Arrays.asList(DLTKCore.getBuildpathVariableNames()));
        List changedElements = this.fVariablesList.getElements();
        int i = changedElements.size() - 1;
        while (i >= 0) {
            BPVariableElement curr = (BPVariableElement)changedElements.get(i);
            if (curr.isReadOnly()) {
                changedElements.remove(curr);
            } else {
                IPath path = curr.getPath();
                IPath prevPath = DLTKCore.getBuildpathVariable((String)curr.getName());
                if (prevPath != null && prevPath.equals((Object)path)) {
                    changedElements.remove(curr);
                } else {
                    changedVariables.add(curr.getName());
                }
            }
            removedVariables.remove(curr.getName());
            --i;
        }
        int steps = changedElements.size() + removedVariables.size();
        if (steps > 0) {
            boolean needsBuild = false;
            if (this.fAskToBuild && this.doesChangeRequireFullBuild(removedVariables, changedVariables)) {
                String title = NewWizardMessages.VariableBlock_needsbuild_title;
                String message = NewWizardMessages.VariableBlock_needsbuild_message;
                MessageDialog buildDialog = new MessageDialog(this.getShell(), title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
                int res = buildDialog.open();
                if (res != 0 && res != 1) {
                    return false;
                }
                needsBuild = res == 0;
            }
            VariableBlockRunnable runnable = new VariableBlockRunnable(removedVariables, changedElements);
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
            try {
                dialog.run(true, true, (IRunnableWithProgress)runnable);
            }
            catch (InvocationTargetException invocationTargetException) {
                ExceptionHandler.handle(new InvocationTargetException(new NullPointerException()), this.getShell(), NewWizardMessages.VariableBlock_variableSettingError_titel, NewWizardMessages.VariableBlock_variableSettingError_message);
                return false;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            if (needsBuild) {
                CoreUtility.getBuildJob(null).schedule();
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doesChangeRequireFullBuild(List removed, List changed) {
        try {
            IScriptModel model = DLTKCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            IScriptProject[] projects = model.getScriptProjects();
            int i = 0;
            block2: while (true) {
                if (i >= projects.length) {
                    return false;
                }
                IBuildpathEntry[] entries = projects[i].getRawBuildpath();
                int k = 0;
                while (true) {
                    if (k >= entries.length) {
                        ++i;
                        continue block2;
                    }
                    IBuildpathEntry curr = entries[k];
                    if (curr.getEntryKind() == 4) {
                        String var = curr.getPath().segment(0);
                        if (removed.contains(var)) return true;
                        if (changed.contains(var)) {
                            return true;
                        }
                    }
                    ++k;
                }
                break;
            }
        }
        catch (ModelException modelException) {
            return true;
        }
    }

    public void setAskToBuild(boolean askToBuild) {
        this.fAskToBuild = askToBuild;
    }

    public void refresh(String initSelection) {
        BPVariableElement initSelectedElement = null;
        String[] entries = DLTKCore.getBuildpathVariableNames();
        ArrayList<BPVariableElement> elements = new ArrayList<BPVariableElement>(entries.length);
        int i = 0;
        while (i < entries.length) {
            String name = entries[i];
            IPath entryPath = DLTKCore.getBuildpathVariable((String)name);
            if (entryPath != null) {
                BPVariableElement elem = new BPVariableElement(name, entryPath);
                elements.add(elem);
                if (name.equals(initSelection)) {
                    initSelectedElement = elem;
                }
            } else {
                DLTKUIPlugin.logErrorMessage("VariableBlock: Buildpath variable with null value: " + name);
            }
            ++i;
        }
        this.fVariablesList.setElements(elements);
        if (initSelectedElement != null) {
            StructuredSelection sel = new StructuredSelection(initSelectedElement);
            this.fVariablesList.selectElements((ISelection)sel);
        } else {
            this.fVariablesList.selectFirstElement();
        }
        this.fHasChanges = false;
    }

    public void setSelection(String elementName) {
        int i = 0;
        while (i < this.fVariablesList.getSize()) {
            BPVariableElement elem = (BPVariableElement)this.fVariablesList.getElement(i);
            if (elem.getName().equals(elementName)) {
                this.fVariablesList.selectElements((ISelection)new StructuredSelection((Object)elem));
                return;
            }
            ++i;
        }
    }

    private class VariableBlockRunnable
    implements IRunnableWithProgress {
        private final List fToRemove;
        private final List fToChange;

        public VariableBlockRunnable(List toRemove, List toChange) {
            this.fToRemove = toRemove;
            this.fToChange = toChange;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(NewWizardMessages.VariableBlock_operation_desc, 1);
            try {
                try {
                    this.setVariables(monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
                catch (OperationCanceledException operationCanceledException) {
                    throw new InterruptedException();
                }
            }
            finally {
                monitor.done();
            }
        }

        public void setVariables(IProgressMonitor monitor) throws ModelException, CoreException {
            int nVariables = this.fToChange.size() + this.fToRemove.size();
            String[] names = new String[nVariables];
            IPath[] paths = new IPath[nVariables];
            int k = 0;
            int i = 0;
            while (i < this.fToChange.size()) {
                BPVariableElement curr = (BPVariableElement)this.fToChange.get(i);
                names[k] = curr.getName();
                paths[k] = curr.getPath();
                ++k;
                ++i;
            }
            i = 0;
            while (i < this.fToRemove.size()) {
                names[k] = (String)this.fToRemove.get(i);
                paths[k] = null;
                ++k;
                ++i;
            }
            DLTKCore.setBuildpathVariables((String[])names, (IPath[])paths, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
    }

    private class VariablesAdapter
    implements IDialogFieldListener,
    IListAdapter {
        private VariablesAdapter() {
        }

        @Override
        public void customButtonPressed(ListDialogField field, int index) {
            switch (index) {
                case 0: {
                    VariableBlock.this.editEntries(null);
                    break;
                }
                case 1: {
                    List selected = field.getSelectedElements();
                    VariableBlock.this.editEntries((BPVariableElement)selected.get(0));
                }
            }
        }

        @Override
        public void selectionChanged(ListDialogField field) {
            VariableBlock.this.doSelectionChanged(field);
        }

        @Override
        public void doubleClicked(ListDialogField field) {
            List selected;
            if (VariableBlock.this.fEditOnDoubleclick && VariableBlock.this.canEdit(selected = field.getSelectedElements(), VariableBlock.this.containsReadOnly(selected))) {
                VariableBlock.this.editEntries((BPVariableElement)selected.get(0));
            }
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
        }
    }
}

